

if(typeof String.prototype.trim !== 'function') {
  String.prototype.trim = function() {
    return this.replace(/^\s+|\s+$/g, ''); 
  }
}

function replaceAttribute(object,attr,oldVal,newVal)
{
	if (!object)
		return;

	var values = object.getAttribute(attr).split(" ");
	
	var newValues="";
	
	for (var c=0;c<values.length;c++)
	{
		if (values[c]!=oldVal)
			newValues+=values[c]+" ";
	}
	
	var needsAdd = true;
	values = newValues.split(" ");
	for (var c=0;c<values.length;c++)
	{
		// All done since new class is already in
		if (values[c]==newVal){
			object.setAttribute(attr,newValues.trim());
			return;
		}
	}
	newValues+=newVal;
	object.setAttribute(attr,newValues);
}

function disableWidget(widget)
{
	var div = document.createElement('div');
	div.style.opacity=.5; 
	div.style.background='none repeat scroll 0 0 #EEEEEE';
	div.style.position='relative';
	
	
	var parent = widget.parentNode;
	
	var w = parent.clientWidth;
	var h = parent.clientHeight;
	div.style.width = w+'px';
	div.style.height = h+'px';
	div.style.bottom = h+'px';
	div.id=widget.id +'_disabledDiv';
	
	parent.appendChild(div);
	return div;
}


function enableWidget(disabledDiv)
{
	var parent = disabledDiv.parentNode;
	
	parent.removeChild(disabledDiv);
}


function getElementsByClass(className)
{
	var all = document.getElementsByTagName("*");
	var match = [];
	var count = 0;
	
	for(var a=0;a<all.length;a++)
	{
		if (all[a].getAttribute("class")!=null && all[a].getAttribute("class").indexOf(className)>-1){
			match[count] = all[a];
			count++;
		}	
	}
	return match;
}

function encodeHTML(str)
{
	str = str.replace(/&/g,"&amp;");
	str = str.replace(/</g,"&lt;");
	str = str.replace(/>/g,"&gt;");
	return str;
}

function encodeJSON(str)
{
	str = str.replace(/'/g,"\\'");
	return str;
}

function decodeHTML(str)
{
	str = str.replace(/&amp;/g,"&");
	str = str.replace(/&lt;/g,"<");
	str = str.replace(/&gt;/g,">");
	return str;
}

