
// Must also include Hashtable.js for this

function URL(href){
	this.href = href;
	this.base = href;
	this.params = new Hashtable();
	if (href.indexOf("?")>-1)
	{	
		var query = href.substring(href.indexOf("?")+1);
		var s = this.nextSep(query);
		while (s>0)
		{	
			if (s>0)
			{
				var name = query.substring(0,query.indexOf("="));
				var val = query.substring(query.indexOf("=")+1,s);
				this.params.put(name,val);
				query = query.substring(s);
				s = this.nextSep(query);
			}
		}
		this.base = href.substring(0,href.indexOf("?"));
	}
	
};
URL.prototype.nextSep = function(query)
{
	var s = query.indexOf("&");
	if (s==-1)
		s = query.length;
	return s;
}

URL.prototype.removeParam = function(param)
{
	this.params.remove(param);
}

URL.prototype.getParam = function(name)
{
	return this.params.get(name);
}

URL.prototype.addParam = function(name,val)
{
	return this.params.put(name,val);
}

URL.prototype.toString = function()
{
	var url = this.base;
	
	var length = this.params.length();
	for (var l=0;l<length;l++)
	{
		if (l==0)
			url+="?";
		else
			url+="&";
		url+=this.params.keyAt(l)+"="+this.params.valAt(l);	
	}
	return url;
}
