/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.web;

import com.ibm.ut.help.common.IContentReplacer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplacerOutputStream
extends OutputStream {
    private OutputStream out;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private Properties replacements = new Properties();
    private String charset = "UTF-8";

    public ReplacerOutputStream() {
        this(new ByteArrayOutputStream());
    }

    public ReplacerOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        int read;
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(this.buffer.toByteArray()), this.charset);
        StringBuffer sbuf = new StringBuffer();
        char[] cbuf = new char[8192];
        while ((read = reader.read(cbuf)) > -1) {
            sbuf.append(cbuf, 0, read);
        }
        reader.close();
        this.buffer = new ByteArrayOutputStream();
        String x = sbuf.toString();
        Enumeration<Object> keys = this.replacements.keys();
        while (keys.hasMoreElements()) {
            String regex = (String)keys.nextElement();
            Object replacement = this.replacements.get(regex);
            x = replacement instanceof String ? x.replaceAll(regex, (String)replacement) : this.replaceAll(x, regex, (IContentReplacer)replacement);
        }
        this.out.write(x.getBytes(this.charset));
        this.out.flush();
    }

    public void replaceAll(String regex, String replacement) {
        this.replacements.setProperty(regex, replacement);
    }

    public void replaceAll(String regex, IContentReplacer replacer) {
        this.replacements.put(regex, replacer);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    private String replaceAll(String x, String regex, IContentReplacer replacement) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher((CharSequence)x);
        while (m.find()) {
            String group = m.group();
            x = ((String)x).substring(0, ((String)x).indexOf(group)) + replacement.replace(group) + ((String)x).substring(((String)x).indexOf(group) + group.length());
        }
        return x;
    }
}

