/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.web;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.security.IAuthenticator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HTMLUtil {
    private static final String[] decoded = new String[]{"&", ">", "<", "\"", "'", " "};
    private static final String[] encoded = new String[]{"&amp;", "&gt;", "&lt;", "&quot;", "&#39;", "&nbsp;"};
    private static final String[] decoded2 = new String[]{"%", "(", ")", ":", "\\", " ", ">", "=", "+", "#"};
    private static final String[] encoded2 = new String[]{"%25", "%28", "%29", "%3A", "%5C", "%20", "%3E", "%3D", "%2B", "%23"};
    private static Hashtable<String, IAuthenticator> authenticators = new Hashtable();

    public static String decode(String s) {
        int i = 0;
        while (i < encoded.length) {
            s = HTMLUtil.replaceAll(s, encoded[i], decoded[i]);
            ++i;
        }
        i = 0;
        while (i < encoded2.length) {
            s = HTMLUtil.replaceAll(s, encoded2[i], decoded2[i]);
            ++i;
        }
        return s;
    }

    public static String encode(String s) {
        int i = 0;
        while (i < decoded.length) {
            s = HTMLUtil.replaceAll(s, decoded[i], encoded[i]);
            ++i;
        }
        return s;
    }

    public static String encodeURL(String s) {
        int i = 0;
        while (i < decoded2.length) {
            s = HTMLUtil.replaceAll(s, decoded2[i], encoded2[i]);
            ++i;
        }
        return s;
    }

    public static String removeURLParam(String url, String param) {
        int i = url.indexOf("&" + param + "=");
        if (i > -1) {
            String s1 = url.substring(0, i);
            String s2 = url.substring(i);
            s2 = s2.indexOf("&") > -1 ? s2.substring(s2.indexOf("&") - 1) : "";
            return s1 + s2;
        }
        i = url.indexOf("?" + param + "=");
        if (i > -1) {
            String s1 = url.substring(0, i);
            String s2 = url.substring(i);
            s2 = s2.indexOf("&") > -1 ? "?" + s2.substring(s2.indexOf("&")) : "";
            return s1 + s2;
        }
        return url;
    }

    public static String addURLParam(String url, String name, String val) {
        char op = (url = HTMLUtil.removeURLParam(url, name)).indexOf("?") == -1 ? (char)'?' : '&';
        return url + op + name + "=" + val;
    }

    public static String resolveURL(String url) {
        while (url.contains("../")) {
            url = url.replaceFirst("/[^/]*/\\.\\.", "");
        }
        return url;
    }

    public static String toString(String html) {
        html = HTMLUtil.replaceAll(html, "<br />", "\n");
        Pattern p = Pattern.compile("<li.*?>");
        Matcher m = p.matcher(html);
        while (m.find()) {
            String group = m.group();
            html = html.replaceFirst(group, "\n - ");
        }
        html = HTMLUtil.stripHTML(html);
        return html;
    }

    public static String stripHTML(String s) {
        return s.replaceAll("<[^>]*>", "");
    }

    public static String getICBaseURL(HttpServletRequest req) {
        String url = req.getRequestURL().toString();
        String baseURL = url.substring(0, req.getRequestURL().indexOf(req.getServletPath()));
        return baseURL;
    }

    public static String replaceAll(String str, String find, String replace) {
        if (find.equals("(") || find.equals(")")) {
            return str;
        }
        if (find.equals("\\")) {
            find = "\\\\";
        }
        if (find.equals("+")) {
            find = "\\+";
        }
        String[] split = ("START" + str + "END").split(find);
        StringBuffer buffer = new StringBuffer();
        int s = 0;
        while (s < split.length) {
            buffer.append(split[s]);
            buffer.append(replace);
            ++s;
        }
        return buffer.substring(5, buffer.length() - ("END" + replace).length());
    }

    public static String getMethod(HttpServletRequest req) {
        String method = req.getParameter("method");
        if (method != null) {
            return method;
        }
        return req.getMethod();
    }

    public static String getAcceptType(HttpServletRequest req) {
        if (req.getParameter("accept") != null) {
            return req.getParameter("accept");
        }
        String uri = req.getRequestURL().toString();
        if (uri.endsWith(".json")) {
            return "json";
        }
        if (uri.endsWith(".html")) {
            return "html";
        }
        if (uri.endsWith(".xml")) {
            return "xml";
        }
        if (uri.endsWith(".txt")) {
            return "text";
        }
        return req.getHeader("Accept");
    }

    public static boolean isLocalHost(String host) {
        String hostName;
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            InetAddress localAddress;
                            block9: {
                                InetAddress callerAddress = InetAddress.getByName(host);
                                localAddress = InetAddress.getLocalHost();
                                hostName = callerAddress.getHostName().toLowerCase();
                                if (!hostName.equals(localAddress.getHostAddress())) break block9;
                                return true;
                            }
                            if (!hostName.equals(localAddress.getHostName().toLowerCase())) break block10;
                            return true;
                        }
                        if (!hostName.equals("127.0.0.1")) break block11;
                        return true;
                    }
                    if (!hostName.equals("localhost")) break block12;
                    return true;
                }
                if (!hostName.equals("localhost.localdomain")) break block13;
                return true;
            }
            if (!hostName.equals("::1")) break block14;
            return true;
        }
        try {
            if (hostName.equals("0:0:0:0:0:0:0:1")) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            Activator.logError("Could not get Local Host info.", e);
        }
        return false;
    }
}

