/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.topic.modifiers;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.ITopicModifier;
import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.help.common.web.LocaleUtil;
import com.ibm.ut.help.parser.TagElement;
import com.ibm.ut.help.parser.TagParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class FooterTopicModifier
implements ITopicModifier {
    private IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ut.help.common.topicFooter");
    private Locale locale;
    private String path;
    private boolean modified = false;

    public String loadFooter(IConfigurationElement config) {
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            Bundle bundle = Platform.getBundle((String)config.getAttribute("plugin"));
            URL url = bundle.getEntry(config.getAttribute("html"));
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            in.close();
        }
        catch (Exception e) {
            Activator.logError("Could not load footer in " + config.getAttribute("plugin"), e);
        }
        return buffer.toString();
    }

    public void startElement(TagElement element) {
    }

    public void endElement(TagElement element) {
        if (element.getTag().equals("body") && !this.alreadyHasFooter(element)) {
            Properties props = new Properties();
            props.setProperty("class", "dynamicFooter");
            TagElement newFooter = new TagElement("div", props);
            int c = 0;
            while (c < this.configs.length) {
                String footer;
                String regex = this.configs[c].getAttribute("matchesTopics");
                if (this.path.matches(regex) && !(footer = this.loadFooter(this.configs[c])).equals("")) {
                    newFooter.addChild((Object)("<div class=\"footerTopicModifier\">" + footer + "</div>"));
                    this.modified = true;
                }
                ++c;
            }
            element.addChild((Object)newFooter);
        }
    }

    public void characters(TagElement element, String chars) {
    }

    public void comment(String chunk) {
    }

    private boolean alreadyHasFooter(TagElement element) {
        List kids = element.getChildren();
        int k = 0;
        while (k < kids.size()) {
            if (kids.get(k) instanceof TagElement && ((TagElement)kids.get(k)).getTag() != null && ((TagElement)kids.get(k)).getTag().equals("span") && ((TagElement)kids.get(k)).getProperty("class").contains("dynamicFooter")) {
                return true;
            }
            ++k;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return Preferences.get("com.ibm.ut.help.common", "topicFootersEnabled").equals("true");
    }

    @Override
    public boolean shouldModify(HttpServletRequest request) {
        this.locale = LocaleUtil.getLocale(request);
        this.path = request.getRequestURI();
        return this.configs.length > 0;
    }

    @Override
    public boolean didModify() {
        return this.modified;
    }

    @Override
    public void setParser(TagParser parser) {
    }
}

