/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.site;

import com.ibm.ut.help.common.io.Resource;
import com.ibm.ut.help.common.site.Category;
import com.ibm.ut.help.common.site.Feature;
import com.ibm.ut.help.common.site.Site;
import com.ibm.ut.help.common.web.HTMLUtil;
import com.ibm.ut.help.parser.ITagHandler;
import com.ibm.ut.help.parser.TagElement;
import com.ibm.ut.help.parser.TagParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class SiteXMLParser
implements ITagHandler {
    private static Hashtable<String, SiteXMLParser> parsers = new Hashtable();
    private Hashtable<String, Category> categoryTable = new Hashtable();
    private Feature feature = null;
    private Category category = null;
    private String uri = null;
    private List<Feature> features = new ArrayList<Feature>();
    private TagParser parser;
    private boolean di = false;

    private SiteXMLParser() {
    }

    public static URI formatSitePath(String site) throws URISyntaxException {
        site = HTMLUtil.decode((String)site);
        if (!((String)(site = HTMLUtil.replaceAll((String)site, "\\\\", "/"))).endsWith("/")) {
            site = (String)site + "/";
        }
        if (((String)site).startsWith("http") && !((String)site).endsWith("site/")) {
            site = (String)site + "site/";
        }
        return ((String)site).startsWith("http") ? new URI((String)site) : new URI("file:///" + (String)site);
    }

    public static SiteXMLParser parse(Site site) throws IOException {
        site.getSiteXML();
        return SiteXMLParser.parse(site.getSiteXML());
    }

    public static SiteXMLParser parse(Resource siteXML) throws IOException {
        SiteXMLParser p = parsers.get(siteXML.toString());
        if (p == null) {
            p = new SiteXMLParser();
            p.parse(siteXML.getStream());
            parsers.put(siteXML.toString(), p);
        }
        return p;
    }

    public void parse(InputStream in) throws IOException {
        this.parser = new TagParser();
        this.parser.parse(in, (ITagHandler)this);
    }

    public void startElement(TagElement element) {
        if (element.getTag().equals("feature")) {
            this.feature = new Feature(element.getProperty("id"), element.getProperty("version"));
            this.features.add(this.feature);
        } else if (element.getTag().equals("category")) {
            Category c = this.getCategory(element.getProperty("name"));
            if (!element.getProperty("depends").equals("")) {
                c.dependOn(this.getCategory(element.getProperty("depends")));
            }
            this.feature.setCategory(c);
            c.addFeature(this.feature);
        } else if (element.getTag().equals("category-def")) {
            this.category = this.getCategory(element.getProperty("name"));
            this.category.setLabel(element.getProperty("label"));
            if (!element.getProperty("depends").equals("")) {
                this.category.dependOn(this.getCategory(element.getProperty("depends")));
            }
        }
    }

    public void characters(TagElement element, String chars) {
        chars = chars.trim();
        if (element.getTag().equals("description") && this.parser.getParentTag().getTag().equals("category-def")) {
            this.category.setDescription(chars);
        }
        if (element.getTag().equals("uri")) {
            this.uri = chars;
        }
    }

    public void comment(String chunk) {
        if (chunk.contains("Dependencies Included")) {
            this.di = true;
        }
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public String getRepository() {
        return this.uri;
    }

    public List<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        Enumeration<Category> elements = this.categoryTable.elements();
        while (elements.hasMoreElements()) {
            categories.add(elements.nextElement());
        }
        return categories;
    }

    public List<String> getCategoryNames() {
        ArrayList<String> categories = new ArrayList<String>();
        Enumeration<Category> elements = this.categoryTable.elements();
        while (elements.hasMoreElements()) {
            categories.add(elements.nextElement().toString());
        }
        return categories;
    }

    private Category getCategory(String name) {
        Category c = this.categoryTable.get(name);
        if (c == null) {
            c = new Category(name);
            this.categoryTable.put(name, c);
        }
        return c;
    }

    public void endElement(TagElement element) {
    }

    public boolean isDependencyInfoPresent() {
        return this.di;
    }
}

