/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.site;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.connector.PlatformConnector;
import com.ibm.ut.help.common.io.FileHandler;
import com.ibm.ut.help.common.io.ZipFileUtility;
import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.help.common.site.FavoritesService;
import com.ibm.ut.help.common.site.Site;
import com.ibm.ut.help.common.site.SitesFeedParser;
import com.ibm.ut.help.common.web.URLUtil;
import com.ibm.ut.help.parser.json.JSONElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SiteManager {
    public static String UPDATER_PLUGIN_ID = "com.ibm.ccl.help.webapp.war.updater";
    public static final String SITES_FEED = System.getProperty("help.sites") != null ? System.getProperty("help.sites") : "https://public.dhe.ibm.com/software/rationalsdp/documentation/infrastructure/sites.rss";
    public static final File UPLOADS_DIRECTORY = System.getProperty("help.uploads") != null ? new File(System.getProperty("help.uploads")) : new File(PlatformConnector.getConfigurationLocation(), UPDATER_PLUGIN_ID + "/uploads");

    static {
        UPLOADS_DIRECTORY.mkdirs();
    }

    public static void addSite(Site site) {
        List<Site> sites = SiteManager.getSites();
        if (sites.contains(site)) {
            return;
        }
        sites = new ArrayList<Site>();
        sites.add(site);
        if (site.isFavorite()) {
            FavoritesService.addFavorite(site.getUID(), site.getURI());
        }
        SiteManager.addSites(sites);
    }

    public static Site addSite(String siteName, String fileName, InputStream in, long timestamp) throws IOException {
        int read;
        File zipFile = new File(UPLOADS_DIRECTORY, fileName);
        zipFile.getParentFile().mkdirs();
        zipFile.delete();
        zipFile.createNewFile();
        FileOutputStream out = new FileOutputStream(zipFile);
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        in.close();
        out.close();
        zipFile.setLastModified(timestamp);
        return SiteManager.addSite(siteName, zipFile);
    }

    public static Site addSite(String siteName, File zipFile) throws IOException {
        File folder = new File(UPLOADS_DIRECTORY, siteName);
        folder.mkdirs();
        ZipFileUtility.extractZip(zipFile, folder);
        zipFile.delete();
        Site site = SiteManager.getUploadSite(siteName);
        if (site == null) {
            FileHandler.delete(folder);
        }
        return site;
    }

    public static void addSites(List<Site> newSites) {
        List<Site> sites = SiteManager.getPrefSites();
        sites.addAll(newSites);
        SiteManager.setPrefSites(sites);
    }

    public static void setPrefSites(List<Site> sites) {
        StringBuffer buffer = new StringBuffer();
        int s = 0;
        while (s < sites.size()) {
            buffer.append(sites.get(s).getName());
            buffer.append(",");
            buffer.append(sites.get(s).getURI());
            if (s != sites.size() - 1) {
                buffer.append(",");
            }
            ++s;
        }
        Preferences.set(UPDATER_PLUGIN_ID, "localSites", buffer.toString());
    }

    public static List<Site> getSites() {
        List<Site> sites = SiteManager.getPublicSites();
        sites.addAll(SiteManager.getPrefSites());
        sites.addAll(SiteManager.getUploadSites());
        return sites;
    }

    public static List<Site> getVisibleSites() {
        List<Site> sites = SiteManager.getPublicSites();
        sites.addAll(SiteManager.getPrefSites());
        sites.addAll(SiteManager.getVisibleUploadSites());
        return sites;
    }

    public static List<Site> getVisibleFavoriteSites() {
        List<Site> sites = SiteManager.getVisibleSites();
        int s = 0;
        while (s < sites.size()) {
            if (!sites.get(s).isFavorite()) {
                sites.remove(s--);
            }
            ++s;
        }
        return sites;
    }

    public static List<Site> getFavoriteSites() {
        List<Site> sites = SiteManager.getSites();
        int s = 0;
        while (s < sites.size()) {
            if (!sites.get(s).isFavorite()) {
                sites.remove(s--);
            }
            ++s;
        }
        return sites;
    }

    public static List<Site> getPrefSites() {
        String[] rawSites = Preferences.get(UPDATER_PLUGIN_ID, "localSites").split(",");
        ArrayList<Site> sites = new ArrayList<Site>();
        int r = 0;
        while (r + 1 < rawSites.length) {
            Site site = new Site();
            site.setName(rawSites[r]);
            site.setURI(rawSites[r + 1]);
            site.setType("localsite");
            site.setFavorite(FavoritesService.isFavorite(site.getUID(), site.getURI()));
            sites.add(site);
            r += 2;
        }
        return sites;
    }

    public static List<Site> getPublicSites() {
        SitesFeedParser feed = new SitesFeedParser();
        try {
            feed.parse(URLUtil.getStream(new URL(SITES_FEED)));
            return feed.getSites();
        }
        catch (Exception e) {
            Activator.logError("Unable to get public sites from '" + SITES_FEED + "'", e);
            e.printStackTrace();
            return new ArrayList<Site>();
        }
    }

    public static Site getUploadSite(String name) {
        List<Site> sites = SiteManager.getUploadSites();
        int s = 0;
        while (s < sites.size()) {
            if (sites.get(s).getName().equals(name)) {
                return sites.get(s);
            }
            ++s;
        }
        return null;
    }

    public static List<Site> getUploadSites() {
        ArrayList<Site> sites = new ArrayList<Site>();
        SiteManager.findUploadSites(UPLOADS_DIRECTORY, sites);
        return sites;
    }

    public static List<Site> getVisibleUploadSites() {
        ArrayList<Site> sites = new ArrayList<Site>();
        SiteManager.findUploadSites(UPLOADS_DIRECTORY, sites);
        int s = sites.size() - 1;
        while (s >= 0) {
            if (((Site)sites.get(s)).getName().startsWith(".")) {
                sites.remove(s);
            }
            --s;
        }
        return sites;
    }

    public static void deleteUploadSite(Site site) {
        File[] list = UPLOADS_DIRECTORY.listFiles();
        int l = 0;
        while (l < list.length) {
            if (list[l].getName().equals(site.getName())) {
                FileHandler.delete(list[l]);
            }
            ++l;
        }
    }

    public static JSONElement getSitesAsJSON(List<Site> sites) {
        ArrayList<JSONElement> elements = new ArrayList<JSONElement>();
        int s = 0;
        while (s < sites.size()) {
            elements.add(sites.get(s).toJSON());
            ++s;
        }
        JSONElement root = new JSONElement();
        root.setProperty("label", "title");
        root.setProperty("identifier", "uid");
        root.put((Object)"items", elements);
        return root;
    }

    public static List<Site> getVersionSites(String title) {
        List<Site> sites = SiteManager.getPublicSites();
        int s = 0;
        while (s < sites.size()) {
            if (sites.get(s).getName().equals(title)) {
                return sites.get(s).getChildren();
            }
            ++s;
        }
        return new ArrayList<Site>();
    }

    public static List<Site> getVersionSitesById(String id) {
        List<Site> sites = SiteManager.getPublicSites();
        int s = 0;
        while (s < sites.size()) {
            if (sites.get(s).getId().equals(id)) {
                return sites.get(s).getChildren();
            }
            ++s;
        }
        return new ArrayList<Site>();
    }

    private static void findUploadSites(File file, List<Site> sites) {
        if (file.getName().equalsIgnoreCase("site.xml")) {
            Site site = new Site();
            site.setName(file.getParentFile().getName());
            site.setURI(file.getAbsolutePath());
            site.setType("localsite");
            site.setFavorite(FavoritesService.isFavorite(site.getUID(), site.getURI()));
            sites.add(site);
        } else if (file.isDirectory()) {
            File[] list = file.listFiles();
            int l = 0;
            while (l < list.length) {
                SiteManager.findUploadSites(list[l], sites);
                ++l;
            }
        }
    }

    public static Site getSite(String name) {
        List<Site> sites = SiteManager.getSites();
        int s = 0;
        while (s < sites.size()) {
            if (sites.get(s).getName().equals(name)) {
                return sites.get(s);
            }
            ++s;
        }
        return null;
    }

    public static Site getSiteByUID(String uid) {
        List<Site> sites = SiteManager.getSites();
        String[] facets = uid.split("->");
        Site site = null;
        int f = 0;
        while (f < facets.length) {
            Site tmp = SiteManager.getSiteByUID(sites, facets[f]);
            if (tmp != null) {
                sites = tmp.getChildren();
                site = tmp;
            }
            ++f;
        }
        return site;
    }

    private static Site getSiteByUID(List<Site> sites, String uid) {
        if (sites == null) {
            return null;
        }
        int s = 0;
        while (s < sites.size()) {
            if (sites.get(s).getUID().endsWith(uid)) {
                return sites.get(s);
            }
            ++s;
        }
        return null;
    }
}

