/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.site;

import com.ibm.ut.help.common.event.ProgressMonitor;
import com.ibm.ut.help.common.io.FileHandler;
import com.ibm.ut.help.common.io.Resource;
import com.ibm.ut.help.common.io.ZipFileUtility;
import com.ibm.ut.help.common.site.Category;
import com.ibm.ut.help.common.site.Feature;
import com.ibm.ut.help.common.site.SiteManager;
import com.ibm.ut.help.common.site.SiteXMLParser;
import com.ibm.ut.help.common.web.ProxyUtil;
import com.ibm.ut.help.common.web.URLUtil;
import com.ibm.ut.help.parser.json.JSONElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class Site {
    private String uri;
    private String name;
    private String type;
    private Site parent = null;
    private List<Site> children = null;
    private List<Category> categories = null;
    private boolean favorite;
    private String id = "";
    private boolean isZip = false;
    private File unzippedDir = null;
    private Resource siteXML = null;
    private Resource repository = null;

    public Site() {
    }

    public Site(String uri, String name, String type, boolean favorite) {
        this(uri, name, type, favorite, null);
    }

    public Site(String uri, String name, String type, boolean favorite, Site parent) {
        this.setURI(uri);
        this.name = name;
        this.type = type;
        this.favorite = favorite;
        this.parent = parent;
    }

    public void setURI(String uri) {
        String end = (uri = FileHandler.replaceAll(uri, "\\\\", "/")).substring(uri.lastIndexOf("/") + 1);
        boolean isURIsite = end.contains(".") ? uri.substring(uri.lastIndexOf(".")).equalsIgnoreCase(".xml") : false;
        boolean bl = this.isZip = end.contains(".") ? uri.substring(uri.lastIndexOf(".")).equalsIgnoreCase(".zip") : false;
        if (!this.isZip && !isURIsite) {
            uri = new Resource(new Resource(uri), "site.xml").toString();
        }
        this.uri = uri;
        if (this.isZip) {
            String name = uri.substring(uri.lastIndexOf("/") + 1);
            name = name.substring(0, name.lastIndexOf("."));
            this.unzippedDir = new File(SiteManager.UPLOADS_DIRECTORY, "." + name);
        } else {
            this.siteXML = new Resource(uri);
        }
    }

    public Resource getSiteXML() {
        if (this.siteXML != null) {
            return this.siteXML;
        }
        if (this.isZip()) {
            try {
                String zipName = this.uri.substring(this.uri.lastIndexOf("/") + 1, this.uri.lastIndexOf("."));
                URL url = new URL(this.uri.substring(0, this.uri.lastIndexOf("/")) + "/sitexmls/" + zipName + ".site.xml");
                url.openStream().close();
                this.siteXML = new Resource(url);
            }
            catch (Exception exception) {}
        }
        this.siteXML = new Resource(this.getRepository(), "site.xml");
        return this.siteXML;
    }

    public boolean isExtracted() {
        return !this.isZip() || this.unzippedDir != null && this.unzippedDir.exists();
    }

    public String getURI() {
        return this.uri;
    }

    public Resource getRepository() {
        return this.getRepository((IProgressMonitor)new NullProgressMonitor());
    }

    public Resource getRepository(IProgressMonitor monitor) {
        if (this.repository != null) {
            return this.repository;
        }
        if (!this.isZip) {
            this.repository = new Resource(this.uri).getParent();
        } else if (!this.isExtracted()) {
            try {
                this.repository = new Resource(this.extractRepository(monitor));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.repository = new Resource(this.unzippedDir);
        }
        return this.repository;
    }

    public String extractRepository(IProgressMonitor monitor) throws IOException {
        String line;
        IProgressMonitor unzipMonitor;
        File zipFile;
        if (!this.isZip) {
            return this.uri;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String name = this.getURI().substring(this.getURI().lastIndexOf("/") + 1);
        long lastModified = 0L;
        if (this.getURI().startsWith("http") || this.getURI().startsWith("ftp")) {
            URLConnection c = URLUtil.getConnection(new URL(this.uri));
            int length = c.getContentLength();
            lastModified = c.getLastModified();
            InputStream in = c.getInputStream();
            zipFile = new File(SiteManager.UPLOADS_DIRECTORY, name);
            zipFile.getParentFile().mkdirs();
            zipFile.delete();
            zipFile.createNewFile();
            FileOutputStream out = new FileOutputStream(zipFile);
            monitor.beginTask("", 1000);
            ProgressMonitor downMonitor = new ProgressMonitor(monitor, 900);
            downMonitor.beginTask("Downloading " + name + " " + this.formatLength(length), length);
            this.transfer(in, out, downMonitor, length, name);
            downMonitor.done();
            unzipMonitor = new SubProgressMonitor(monitor, 100);
            if (monitor.isCanceled()) {
                zipFile.delete();
                return null;
            }
        } else {
            zipFile = new File(this.getURI());
            lastModified = zipFile.lastModified();
            unzipMonitor = monitor;
        }
        FileHandler.delete(this.unzippedDir);
        this.unzippedDir.mkdirs();
        ZipFileUtility.extractZip(zipFile, this.unzippedDir, unzipMonitor);
        File xsite = new File(this.unzippedDir, "site.xml");
        StringBuffer buffer = new StringBuffer();
        BufferedReader br = new BufferedReader(new FileReader(xsite));
        while ((line = br.readLine()) != null) {
            if (line.contains("</site>")) {
                buffer.append("    <uri>" + this.getURI() + "</uri>\n");
            }
            buffer.append(line + "\n");
        }
        br.close();
        monitor.done();
        PrintWriter pw = new PrintWriter(new FileWriter(xsite));
        pw.append(buffer.toString());
        pw.close();
        this.unzippedDir.setLastModified(lastModified);
        return this.unzippedDir.getAbsolutePath();
    }

    public List<String> getCategoryNames() {
        if (this.categories == null) {
            this.getCategories();
        }
        ArrayList<String> names = new ArrayList<String>();
        int c = 0;
        while (c < this.categories.size()) {
            names.add(this.categories.get(c).getName());
            ++c;
        }
        return names;
    }

    public List<Category> getCategories() {
        if (this.categories != null) {
            return this.categories;
        }
        try {
            SiteXMLParser parser = SiteXMLParser.parse(this);
            this.categories = parser.getCategories();
            if (!parser.isDependencyInfoPresent()) {
                Properties d = new Properties();
                d = this.loadDepends(d, new Resource(this.getSiteXML().getParent(), "category_dependenices.txt"));
                d = this.loadDepends(d, new Resource(this.getSiteXML().getParent(), "categorydependency"));
                int c = 0;
                while (c < this.categories.size()) {
                    if (d.containsKey(this.categories.get(c).getName())) {
                        this.categories.get(c).dependOn(new Category(d.getProperty(this.categories.get(c).getName())));
                    }
                    ++c;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.categories = new ArrayList<Category>();
        }
        if (this.categories.isEmpty()) {
            try {
                List<Feature> features = SiteXMLParser.parse(this).getFeatures();
                int f = 0;
                while (f < features.size()) {
                    this.categories.add(new Category(features.get(f).getName()));
                    ++f;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.categories;
    }

    private String formatLength(int length) {
        Object x = "" + length;
        Object res = "";
        while (((String)x).length() > 3) {
            res = "," + ((String)x).substring(((String)x).length() - 3) + (String)res;
            x = ((String)x).substring(0, ((String)x).length() - 3);
        }
        res = (String)x + (String)res;
        return (String)res + " KB";
    }

    private void transfer(InputStream in, OutputStream out, ProgressMonitor monitor, int size, String name) throws IOException {
        int read;
        int total = 0;
        byte[] buffer = new byte[16384];
        while ((read = in.read(buffer)) > 0 && !monitor.isCanceled()) {
            out.write(buffer, 0, read);
            monitor.worked(read);
            monitor.subTask("Downloading " + name + " " + this.formatLength((total += read) / 1000) + " of " + this.formatLength(size / 1000));
        }
        in.close();
        out.close();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isFavorite() {
        if (this.favorite) {
            return true;
        }
        if (this.children != null) {
            int c = 0;
            while (c < this.children.size()) {
                if (this.children.get(c).isFavorite()) {
                    return true;
                }
                ++c;
            }
        }
        return false;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public void addChild(Site child) {
        if (this.children == null) {
            this.children = new ArrayList<Site>();
        }
        this.children.add(child);
    }

    public List<Site> getChildren() {
        return this.children;
    }

    public String getUID() {
        return (String)(this.parent != null ? this.parent.getUID() + "->" : "") + this.getName().replaceAll(" ", "_");
    }

    public JSONElement toJSON() {
        JSONElement element = new JSONElement();
        element.setProperty("title", this.getName());
        element.setProperty("link", this.getURI());
        element.setProperty("type", this.getType());
        element.setProperty("uid", this.getUID());
        element.setProperty("favorite", "" + this.isFavorite());
        if (this.parent != null) {
            element.setProperty("parentname", this.parent.getName());
        }
        element.setProperty("favorite", "" + this.isFavorite());
        if (this.getChildren() == null) {
            element.put((Object)"children", new ArrayList());
        } else {
            ArrayList<JSONElement> elements = new ArrayList<JSONElement>();
            List<Site> kids = this.getChildren();
            int k = 0;
            while (k < kids.size()) {
                elements.add(kids.get(k).toJSON());
                ++k;
            }
            element.put((Object)"children", elements);
        }
        return element;
    }

    public String toString() {
        return this.getUID();
    }

    public boolean equals(Object x) {
        if (x instanceof Site) {
            Site candidate = (Site)x;
            return candidate.getName().equals(this.getName()) && candidate.getURI().equals(this.getURI());
        }
        try {
            new URI(x.toString());
            return x.equals(this.getURI());
        }
        catch (Exception exception) {
            return x.equals(this.getName());
        }
    }

    public void setParent(Site parent) {
        this.parent = parent;
    }

    public Site getParent() {
        return this.parent;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isZip() {
        return this.isZip;
    }

    public boolean isStale() throws IOException {
        if (this.isZip()) {
            long remoteTime;
            if (!this.isExtracted()) {
                return false;
            }
            long localTime = this.unzippedDir.lastModified();
            SiteXMLParser p = SiteXMLParser.parse(this);
            String repo = p.getRepository();
            if (repo.startsWith("http")) {
                URL url = new URL(repo);
                URLConnection c = ProxyUtil.getConnection(url);
                remoteTime = c.getLastModified();
            } else {
                File file = new File(repo);
                remoteTime = file.lastModified();
            }
            return remoteTime > localTime;
        }
        throw new IOException("Site is not zip");
    }

    private Properties loadDepends(Properties d, Resource res) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(res.getStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains("$")) continue;
                d.setProperty(line.substring(0, line.indexOf("$")), line.substring(line.indexOf("$") + 1));
            }
            br.close();
        }
        catch (Exception exception) {}
        return d;
    }
}

