/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.site;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.site.Category;
import com.ibm.ut.help.parser.TagAdapter;
import com.ibm.ut.help.parser.TagElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Feature {
    public static final String UADELIVERY_PROPERTIES = "uadelivery.properties";
    public static final String INCLUDE_IN_UPDATE = "includeInUpdate";
    private String version;
    private String name;
    private Category category = null;
    private Properties props = new Properties();

    public Feature(String name) {
        this.name = name;
    }

    public Feature(File file) throws IOException {
        InputStream featurexml;
        FeatureParser parser = new FeatureParser();
        InputStream uadeliveryproperties = null;
        if (file.isDirectory()) {
            featurexml = new FileInputStream(new File(file, "feature.xml"));
            File ua = new File(file, UADELIVERY_PROPERTIES);
            if (ua.exists()) {
                uadeliveryproperties = new FileInputStream(ua);
            }
        } else {
            ZipFile zip = new ZipFile(file);
            featurexml = zip.getInputStream(zip.getEntry("feature.xml"));
            ZipEntry ua = zip.getEntry(UADELIVERY_PROPERTIES);
            if (ua != null) {
                uadeliveryproperties = zip.getInputStream(ua);
            }
        }
        try {
            parser.parse(featurexml);
        }
        catch (Exception e) {
            Activator.logWarning("Could not parse feature: " + String.valueOf(file), e);
        }
        if (uadeliveryproperties != null) {
            try {
                this.props.load(uadeliveryproperties);
            }
            catch (Exception e) {
                Activator.logWarning("Could not load uadelivery.properties for feature: " + String.valueOf(file), e);
            }
        }
    }

    public Feature(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public boolean isTranslation() {
        return this.name.endsWith(".nl") || this.name.endsWith(".nl2") || this.name.endsWith(".nl2bidi") || this.name.endsWith(".nls") || this.name.endsWith(".nls1") || this.name.endsWith(".nls2") || this.name.endsWith(".nls2bidi");
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    private class FeatureParser
    extends TagAdapter {
        private FeatureParser() {
        }

        public void startElement(TagElement element) {
            if (element.getTag().equals("feature")) {
                Feature.this.setName(element.getProperty("id"));
                Feature.this.setVersion(element.getProperty("version"));
            }
        }
    }
}

