/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.security;

import com.ibm.ut.help.common.security.AuthDetails;
import com.ibm.ut.help.common.security.AuthException;
import com.ibm.ut.help.common.security.IAuthenticator;
import com.ibm.ut.help.common.security.UserAdminAuthenticator;
import com.ibm.ut.help.common.web.URLUtil;
import com.ibm.ut.help.parser.TagAdapter;
import com.ibm.ut.help.parser.TagElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;

public class IntranetAuthenticator
implements IAuthenticator {
    private final String loginURL = "https://w3.ibm.com/pkmslogin.form";

    static {
        Security.setProperty("ssl.SocketFactory.provider", "com.ibm.jsse2.SSLSocketFactoryImpl");
        Security.setProperty("ssl.ServerSocketFactory.provider", "com.ibm.jsse2.SSLServerSocketFactoryImpl");
    }

    @Override
    public AuthDetails authenticate(String user, String password) throws AuthException {
        if (user == null || password == null) {
            throw new AuthException("Invalid Authentication");
        }
        try {
            String line;
            URL url = new URL("https://w3.ibm.com/pkmslogin.form");
            Properties props = new Properties();
            props.setProperty("username", user);
            props.setProperty("login-form-type", "pwd");
            props.setProperty("password", password);
            props.setProperty("ibm-submit", "Submit");
            props.setProperty("name", user);
            props.setProperty("email", user);
            Properties reqHeaders = new Properties();
            reqHeaders.setProperty("host", "w3.ibm.com");
            HttpsURLConnection c = (HttpsURLConnection)URLUtil.postConnection(url, props, reqHeaders);
            InputStream in = c.getInputStream();
            Object content = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                content = (String)content + line + "\n";
            }
            br.close();
            if (((String)content).contains("Please sign in using your Internet address")) {
                throw new AuthException("Invalid Authentication");
            }
            AuthDetails details = new AuthDetails(user);
            details.setEmail(user);
            in = URLUtil.getStream(new URL("http://w3.ibm.com/jct03019wt/bluepages/simpleSearch.wss?searchBy=Internet+address&location=All+locations&searchFor=" + user));
            BluePageParser bp = new BluePageParser();
            bp.parse(in);
            details.setUser(bp.getFullName());
            try {
                UserAdminAuthenticator.createUser(user, user, password, new String[0]);
            }
            catch (Exception exception) {}
            return details;
        }
        catch (IOException e) {
            throw new AuthException(e.getLocalizedMessage());
        }
    }

    @Override
    public boolean isMember(AuthDetails user, String group) {
        return UserAdminAuthenticator.isMember(user.getId(), group);
    }

    public class BluePageParser
    extends TagAdapter {
        private String fullName;

        public void characters(TagElement element, String chars) {
            if (element.getTag().equals("value") && this.parser.getParentTag().getProperty("name").equals("cn")) {
                this.fullName = chars.trim();
            }
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

