/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.prefs;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.help.common.web.URLUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PreferenceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.setCharacterEncoding("UTF-8");
        if (req.getParameter("method") != null && req.getParameter("method").equalsIgnoreCase("post")) {
            this.doPost(req, resp);
            return;
        }
        String plugin = req.getParameter("plugin");
        if (plugin == null) {
            resp.sendError(400, "'plugin' parameter missing");
            return;
        }
        String name = req.getParameter("name");
        if (plugin == null) {
            resp.sendError(400, "'name' parameter missing");
            return;
        }
        resp.getWriter().append(Preferences.get(plugin, name));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestHost = req.getRemoteHost();
        String localIP = InetAddress.getLocalHost().getHostAddress();
        String localName = InetAddress.getLocalHost().getHostName();
        if (!(requestHost.equals("127.0.0.1") || requestHost.equals("localhost") || requestHost.equals(localIP) || requestHost.equals(localName) || requestHost.equals("localhost.localdomain") || requestHost.equals("::1"))) {
            resp.sendError(403, "Only users logged in locally to the IC can modify preferences.");
            return;
        }
        String plugin = req.getParameter("plugin");
        if (plugin == null) {
            resp.sendError(400, "'plugin' parameter missing");
            return;
        }
        String name = req.getParameter("name");
        if (name == null) {
            resp.sendError(400, "'name' parameter missing");
            return;
        }
        String value = req.getParameter("value");
        if (value == null) {
            resp.sendError(400, "'value' parameter missing");
            return;
        }
        Preferences.set(plugin, name, value);
    }

    public static String getRemotePref(String baseURL, String plugin, String name) {
        try {
            String service = "/" + PreferenceServlet.class.getCanonicalName();
            URL url = new URL(baseURL + service + "?plugin=" + plugin + "&name=" + name);
            InputStream in = URLUtil.getStream(url);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            in.close();
            return line;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void setRemotePref(String baseURL, String plugin, String name, String value) {
        String service = "/" + PreferenceServlet.class.getCanonicalName();
        try {
            URL url = new URL(baseURL + service + "?method=post&plugin=" + plugin + "&name=" + name + "&value=" + value);
            url.openStream();
        }
        catch (IOException e) {
            Activator.logError("Could not set remote pref: " + baseURL + service + "?method=post&plugin=" + plugin + "&name=" + name + "&value=" + value, e);
        }
    }
}

