/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.osgi.framework.Bundle;

public class LocalResourceService
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String service = "/ltopic";
        String uri = req.getRequestURL().toString();
        String id = uri.substring(uri.indexOf(service) + service.length());
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if (id == null) {
            return;
        }
        ServletOutputStream out = resp.getOutputStream();
        resp.setContentType("text; charset=UTF-8");
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        int slash = id.indexOf("/");
        if (slash == -1) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)id.substring(0, slash));
        if (bundle == null) {
            this.tryRemote(id, (OutputStream)out);
            return;
        }
        URL url = bundle.getEntry(id.substring(slash));
        if (url == null) {
            this.tryRemote(id, (OutputStream)out);
            return;
        }
        InputStream in = url.openStream();
        if (in == null) {
            this.tryRemote(id, (OutputStream)out);
            return;
        }
        this.transfer(in, (OutputStream)out);
    }

    public void tryRemote(String id, OutputStream out) throws IOException {
        InputStream in = HelpSystem.getHelpContent((String)id);
        if (in != null) {
            this.transfer(in, out);
        }
    }

    public void transfer(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) > -1) {
            out.write(buffer, 0, read);
        }
        in.close();
    }
}

