/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import com.ibm.ut.help.common.connector.PlatformConnector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class FileHandler {
    public static final File DELETE_QUEUE = new File(PlatformConnector.getConfigurationLocation(), "com.ibm.ut.help.common/delete.ini");
    private static List deleteFiles = null;

    public static void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            int l = 0;
            while (l < list.length) {
                FileHandler.delete(list[l]);
                ++l;
            }
        }
        file.delete();
    }

    private static List loadDeleteQueue() throws IOException {
        String line;
        ArrayList<File> files = new ArrayList<File>();
        if (!DELETE_QUEUE.exists()) {
            return files;
        }
        BufferedReader br = new BufferedReader(new FileReader(DELETE_QUEUE));
        while ((line = br.readLine()) != null) {
            files.add(new File(line));
        }
        br.close();
        return files;
    }

    public static void saveQueue() throws IOException {
        if (deleteFiles == null) {
            deleteFiles = FileHandler.loadDeleteQueue();
        }
        FileHandler.saveDeleteQueue(deleteFiles);
    }

    private static void saveDeleteQueue(List list) throws IOException {
        DELETE_QUEUE.delete();
        DELETE_QUEUE.getParentFile().mkdirs();
        DELETE_QUEUE.createNewFile();
        BufferedWriter bw = new BufferedWriter(new FileWriter(DELETE_QUEUE));
        int l = 0;
        while (l < list.size()) {
            bw.append(((File)list.get(l)).getAbsolutePath() + "\n");
            ++l;
        }
        bw.close();
    }

    public static void deleteASAP(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            int l = 0;
            while (l < list.length) {
                FileHandler.deleteASAP(list[l]);
                ++l;
            }
        }
        if (!file.delete()) {
            file.deleteOnExit();
            if (deleteFiles == null) {
                deleteFiles = FileHandler.loadDeleteQueue();
            }
            deleteFiles.add(file);
        }
    }

    public static void deleteQueue() throws IOException {
        if (deleteFiles == null) {
            deleteFiles = FileHandler.loadDeleteQueue();
        }
        int d = 0;
        while (d < deleteFiles.size()) {
            if (((File)deleteFiles.get(d)).delete()) {
                deleteFiles.remove(d--);
            }
            ++d;
        }
    }

    public static void copy(File src, File dest) throws IOException {
        if (!src.exists()) {
            return;
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        File newDest = new File(dest, src.getName());
        if (src.isDirectory()) {
            File[] files = src.listFiles();
            int f = 0;
            while (f < files.length) {
                FileHandler.copy(files[f], newDest);
                ++f;
            }
        } else {
            int read;
            newDest.createNewFile();
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(newDest);
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            in.close();
            out.close();
        }
    }

    public static String resolvePath(String path) {
        if (((String)path).contains("@config.dir")) {
            String config = PlatformConnector.getConfigurationLocation();
            config = config.substring(0, config.length() - 1);
            path = ((String)path).substring(0, ((String)path).indexOf("@config.dir")) + config + ((String)path).substring(((String)path).indexOf("@config.dir") + "@config.dir".length());
        }
        if (((String)path).contains("@user.home")) {
            String user = System.getProperty("user.home");
            path = ((String)path).substring(0, ((String)path).indexOf("@user.home")) + user + ((String)path).substring(((String)path).indexOf("@user.home") + "@user.home".length());
        }
        path = FileHandler.replaceAll((String)path, "\\\\", "/");
        path = ((String)path).replaceAll("/[^/]*/\\.\\.", "");
        return path;
    }

    public static String replaceAll(String str, String find, String replace) {
        String[] split = ("START" + str + "END").split(find);
        StringBuffer buffer = new StringBuffer();
        int s = 0;
        while (s < split.length) {
            buffer.append(split[s]);
            buffer.append(replace);
            ++s;
        }
        return buffer.substring(5, buffer.length() - ("END" + replace).length());
    }

    public static void extractFromBundle(String bundleID, String file, File dest) throws IOException {
        int read;
        Bundle bundle = Platform.getBundle((String)bundleID);
        if (bundle == null) {
            throw new IOException("Bundle " + bundleID + " is unavailable.");
        }
        URL url = bundle.getEntry(file);
        if (url == null) {
            throw new IOException(file + " could not be found in bundle " + bundleID);
        }
        dest.getParentFile().mkdirs();
        InputStream in = url.openStream();
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        in.close();
        out.close();
    }

    public static int writeFile(File file, OutputStream out) throws IOException {
        int read;
        FileInputStream fin = new FileInputStream(file);
        byte[] buffer = new byte[8192];
        int contentLength = 0;
        while ((read = fin.read(buffer)) > -1) {
            out.write(buffer, 0, read);
            contentLength += read;
        }
        out.flush();
        fin.close();
        return contentLength;
    }
}

