/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import com.ibm.ut.help.common.web.HTMLUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class ExceptionUtil {
    public static String shortMessage(Throwable e) {
        StringBuffer buffer = new StringBuffer();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(out));
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            buffer.append(line);
            reader.close();
            out.close();
        }
        catch (Exception exception) {}
        return buffer.toString();
    }

    public static String toString(Throwable e) {
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(out));
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            reader.close();
            out.close();
        }
        catch (Exception exception) {}
        return buffer.toString();
    }

    public static String toHTML(Throwable e) {
        String error = ExceptionUtil.toString(e);
        error = HTMLUtil.replaceAll(error, " ", "&nbsp;");
        error = HTMLUtil.replaceAll(error, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        error = HTMLUtil.replaceAll(error, "\n", "<br/>");
        return error;
    }

    public static String stack(Throwable e) {
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] stack = e.getStackTrace();
        int s = 0;
        while (s < stack.length) {
            buffer.append(stack[s].toString());
            buffer.append("\n");
            ++s;
        }
        return buffer.toString();
    }

    public static String stackToHTML(Throwable e) {
        String error = ExceptionUtil.stack(e);
        error = HTMLUtil.replaceAll(error, " ", "&nbsp;");
        error = HTMLUtil.replaceAll(error, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        error = HTMLUtil.replaceAll(error, "\n", "<br/>");
        return error;
    }
}

