/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.ic;

import com.ibm.ut.help.common.MessageLibrary;
import com.ibm.ut.help.common.error.ErrorStatus;
import com.ibm.ut.help.common.ic.ConnectionManager;
import com.ibm.ut.help.common.ic.IC;
import com.ibm.ut.help.common.io.DuplicateDataException;
import com.ibm.ut.help.common.prefs.ICPreferences;
import com.ibm.ut.help.common.web.LocaleUtil;
import com.ibm.ut.help.parser.json.JSONElement;
import com.ibm.ut.help.parser.json.JSONParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConnectionService
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String service = "/" + ((Object)((Object)this)).getClass().getCanonicalName();
        String uri = req.getRequestURL().toString();
        String id = uri.substring(uri.indexOf(service) + service.length());
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        resp.setContentType("application/json; charset=UTF-8");
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        LocaleUtil.getLocale(req);
        if (id.equals("")) {
            JSONElement json = ConnectionManager.serializeICsJSON();
            resp.getWriter().println(json.toString());
            return;
        }
        if (id.equals("DEFAULTS")) {
            JSONElement json = ConnectionManager.serializeDefaultICsJSON();
            resp.getWriter().println(json.toString());
            return;
        }
        List ics = ICPreferences.getICs();
        int i = 0;
        while (i < ics.size()) {
            if (((IC)ics.get(i)).getName().equals(id)) {
                JSONElement json = ConnectionManager.serializeICJson((IC)ics.get(i));
                resp.getWriter().println(json.toString());
            }
            ++i;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            ServletInputStream body = req.getInputStream();
            JSONParser parser = new JSONParser();
            JSONElement json = parser.parse((InputStream)body);
            if (json == null) {
                resp.sendError(415);
                return;
            }
            ConnectionManager.setICs(json);
            resp.setHeader("location", req.getRequestURL().toString());
        }
        catch (IOException e) {
            resp.sendError(415, e.getLocalizedMessage());
        }
        catch (DuplicateDataException e) {
            ErrorStatus status = new ErrorStatus("CRRHS0102I", MessageLibrary.getErrorFormat("CRRHS0102I", e.getMessage(), LocaleUtil.getLocale(req)), "com.ibm.ut.help.common", e);
            resp.getWriter().print(status);
            status.logError();
        }
    }
}

