/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.ic;

import com.ibm.ut.help.common.ic.IC;
import com.ibm.ut.help.common.io.DuplicateDataException;
import com.ibm.ut.help.common.prefs.ICPreferences;
import com.ibm.ut.help.parser.json.JSONElement;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ConnectionManager {
    public static void setICs(JSONElement json) throws DuplicateDataException {
        ArrayList jsonICs = (ArrayList)json.get((Object)"items");
        ArrayList<IC> ics = new ArrayList<IC>();
        int j = 0;
        while (j < jsonICs.size()) {
            JSONElement jsonIC = (JSONElement)jsonICs.get(j);
            try {
                IC ic = new IC(jsonIC.getProperty("name"), jsonIC.getProperty("href"), jsonIC.getProperty("enabled").equalsIgnoreCase("true"));
                if (ics.contains(ic)) {
                    throw new DuplicateDataException(ic.getName());
                }
                ics.add(ic);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++j;
        }
        ConnectionManager.setICs(ics);
    }

    public static void setICs(List ics) {
        ICPreferences.setICs(ics);
    }

    public static JSONElement serializeICsJSON() {
        return ConnectionManager.serializeICsJSON(ICPreferences.getICs());
    }

    public static JSONElement serializeDefaultICsJSON() {
        return ConnectionManager.serializeICsJSON(ICPreferences.getDefaultICs());
    }

    public static JSONElement serializeICsJSON(List ics) {
        ArrayList<JSONElement> jsonICs = new ArrayList<JSONElement>();
        int i = 0;
        while (i < ics.size()) {
            jsonICs.add(ConnectionManager.serializeICJson((IC)ics.get(i)));
            ++i;
        }
        JSONElement root = new JSONElement();
        root.setProperty("label", "name");
        root.setProperty("identifier", "uid");
        root.put((Object)"items", jsonICs);
        return root;
    }

    public static JSONElement serializeICJson(IC ic) {
        JSONElement element = new JSONElement();
        element.setProperty("uid", UUID.randomUUID().toString());
        element.setProperty("name", ic.getName());
        element.setProperty("href", ic.getHref());
        element.setProperty("enabled", "" + ic.isEnabled());
        return element;
    }
}

