/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.event;

import com.ibm.ut.help.common.event.ProgressMonitor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HistoricalMonitor
extends ProgressMonitor {
    private List<Event> history = new ArrayList<Event>();
    private Event current = new Event("Initializing");

    public HistoricalMonitor(String xid) {
        super(xid);
    }

    @Override
    public void beginTask(String taskName, int totalWork) {
        super.beginTask(taskName, totalWork);
        this.updateTask(taskName);
    }

    @Override
    public void subTask(String taskName) {
        super.subTask(taskName);
        this.updateTask(taskName);
    }

    private void updateTask(String taskName) {
        this.current.timeLapse();
        this.history.add(this.current);
        this.current = new Event(taskName);
    }

    @Override
    public void internalWorked(double work) {
        super.internalWorked(work);
        if (this.isTaskFinished() && this.current != null) {
            this.current.timeLapse();
            this.history.add(this.current);
            this.current = null;
        }
    }

    public List<Event> getHistory() {
        return this.history;
    }

    public String printHistory() {
        StringBuffer b = new StringBuffer();
        int h = 0;
        while (h < this.history.size()) {
            b.append(" " + h + ". " + this.history.get(h).toString() + "\n");
            ++h;
        }
        return b.toString();
    }

    private class Event {
        private long time = new Date().getTime();
        private String name;

        public Event(String name) {
            this.name = name;
        }

        public void timeLapse() {
            this.time = new Date().getTime() - this.time;
        }

        public String toString() {
            return this.name + " " + this.time + " ms";
        }
    }
}

