/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.event;

import com.ibm.ut.help.common.IContentChangeListener;
import com.ibm.ut.help.common.connector.IConnectorOperation;
import com.ibm.ut.help.common.connector.PlatformConnector;
import com.ibm.ut.help.common.event.ContentChangeEvent;
import com.ibm.ut.help.common.prefs.Preferences;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ContentChangeEventManager
implements IConnectorOperation {
    private static List listeners;
    private static boolean initialized;

    static {
        initialized = false;
    }

    private ContentChangeEventManager() {
    }

    public static void initialize() {
        if (!initialized) {
            new Preferences("org.eclipse.help.base").addListener(new ICPreferenceListener());
            initialized = true;
        }
    }

    public static void addContentChangeListener(IContentChangeListener listener) {
        if (!initialized) {
            ContentChangeEventManager.initialize();
        }
        if (listeners == null) {
            listeners = new ArrayList();
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeContentChangeListener(IContentChangeListener listener) {
        if (!initialized) {
            ContentChangeEventManager.initialize();
        }
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }

    public static void contentUpdated(int action) throws MalformedURLException {
        ContentChangeEventManager.fireContentChanged(new ContentChangeEvent(action));
        Properties args = new Properties();
        args.setProperty("action", "" + action);
        PlatformConnector.sendToIDE("contentChanged", args);
    }

    @Override
    public String exec(Properties props, InputStream in) throws NumberFormatException, MalformedURLException {
        ContentChangeEventManager.fireContentChanged(new ContentChangeEvent(Integer.parseInt(props.getProperty("action"))));
        return null;
    }

    private static void fireContentChanged(ContentChangeEvent e) throws MalformedURLException {
        if (listeners == null) {
            return;
        }
        int l = 0;
        while (l < listeners.size()) {
            ((IContentChangeListener)listeners.get(l)).contentChanged(e);
            ++l;
        }
    }

    static class ICPreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        ICPreferenceListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("remoteHelpICEnabled")) {
                int newCount;
                String oVal = event.getOldValue() != null ? event.getOldValue().toString() : "";
                int oldCount = oVal.equals("") ? 0 : oVal.split(",").length;
                String nVal = event.getNewValue() != null ? event.getNewValue().toString() : "";
                int n = newCount = nVal.equals("") ? 0 : nVal.split(",").length;
                if (oldCount > newCount) {
                    try {
                        ContentChangeEventManager.fireContentChanged(new ContentChangeEvent(-2));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                } else if (oldCount < newCount) {
                    try {
                        ContentChangeEventManager.fireContentChanged(new ContentChangeEvent(2));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        ContentChangeEventManager.fireContentChanged(new ContentChangeEvent(0));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

