/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.error;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.error.IErrorAction;
import com.ibm.ut.help.common.io.ExceptionUtil;
import com.ibm.ut.help.common.io.HelpParser;
import com.ibm.ut.help.common.web.HTMLUtil;
import com.ibm.ut.help.parser.json.JSONElement;
import com.ibm.ut.help.parser.json.JSONParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.QueryTooComplexException;

public class ErrorStatus
implements IStatus {
    private Throwable e = null;
    private String stack = null;
    private String eid = null;
    private String message = null;
    private String pluginId;
    private HelpTopic help = null;
    private IErrorAction action = null;

    public ErrorStatus(String pluginId, Throwable e) {
        this.pluginId = pluginId;
        this.setException(e);
        this.message = e.getLocalizedMessage();
    }

    public ErrorStatus(String eid, String message, String pluginId) {
        this.eid = eid;
        this.message = message;
        this.pluginId = pluginId;
    }

    public ErrorStatus(String eid, String message, String pluginId, Throwable e) {
        this.eid = eid;
        this.message = message;
        this.pluginId = pluginId;
        this.e = e;
    }

    public ErrorStatus(HttpServletRequest req) throws IOException {
        this(new JSONParser().parse((InputStream)req.getInputStream()));
    }

    public ErrorStatus(JSONElement element) {
        this.eid = element.getProperty("eid");
        this.stack = element.getProperty("stack");
        this.message = element.getProperty("message");
        this.pluginId = element.getProperty("pluginId");
    }

    public void searchForTopic(String[] topics, Locale locale, String baseURL) {
        int t = 0;
        while (t < topics.length) {
            try {
                InputStream in = HelpSystem.getHelpContent((String)topics[t], (String)locale.toString());
                if (in != null) {
                    this.help = new HelpTopic(baseURL + "/topic", topics[t]);
                    in.close();
                    return;
                }
            }
            catch (Exception exception) {}
            ++t;
        }
    }

    public Throwable getException() {
        return this.e;
    }

    public void setException(Throwable e) {
        this.e = e;
    }

    public String getEid() {
        return this.eid;
    }

    public HelpTopic getHelp() {
        return this.help;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStack() {
        if (this.stack != null) {
            return this.stack;
        }
        if (this.e == null) {
            return "";
        }
        return ExceptionUtil.toString(this.e);
    }

    public void setAction(IErrorAction action) {
        this.action = action;
    }

    public IErrorAction getAction() {
        return this.action;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.eid + "\n");
        buffer.append(this.message + "\n");
        buffer.append(this.getStack());
        if (this.getAction() != null) {
            buffer.append("\naction::" + this.getAction().getLabel() + "\n" + this.getAction().getJSFunctionName() + "\n" + this.getAction().getJSFunctionBody());
        }
        return buffer.toString();
    }

    public String toHTML() {
        String s = this.getStack();
        s = HTMLUtil.replaceAll(s, "\n", "<br/>");
        s = HTMLUtil.replaceAll(s, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.eid + "\n");
        buffer.append(this.message + "\n");
        buffer.append(s);
        if (this.getAction() != null) {
            buffer.append("\naction::" + this.getAction().getLabel() + "\n" + this.getAction().getJSFunctionName() + "\n" + this.getAction().getJSFunctionBody());
        }
        return buffer.toString();
    }

    public JSONElement toJSON() {
        JSONElement element = new JSONElement();
        element.setProperty("eid", this.eid == null ? "null" : this.eid);
        element.setProperty("message", this.message);
        String stack = this.getStack();
        stack = HTMLUtil.replaceAll(stack, ":", "\\:");
        stack = HTMLUtil.replaceAll(stack, "\n", "<br/>");
        stack = HTMLUtil.replaceAll(stack, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        element.setProperty("stack", stack);
        element.setProperty("pluginId", this.pluginId);
        if (this.getHelp() != null) {
            element.setProperty("helpTitle", this.getHelp().getTitle());
            element.setProperty("helpHref", this.getHelp().getHref());
        }
        if (this.getAction() != null) {
            element.setProperty("actionLabel", this.getAction().getLabel());
            element.setProperty("actionFunctionName", this.getAction().getJSFunctionName());
            element.setProperty("actionFunctionBody", this.getAction().getJSFunctionBody());
        }
        return element;
    }

    public static ErrorStatus logError(String eid, String message, String pluginId, Throwable e) {
        ErrorStatus error = new ErrorStatus(eid, message, pluginId, e);
        ErrorStatus.logError(error);
        return error;
    }

    public static void logError(ErrorStatus error) {
        Activator.getDefault().getLog().log((IStatus)error);
    }

    public void logError() {
        Activator.getDefault().getLog().log((IStatus)this);
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }

    public int getCode() {
        return 0;
    }

    public String getPlugin() {
        return this.pluginId;
    }

    public int getSeverity() {
        return 4;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean isOK() {
        return false;
    }

    public boolean matches(int severityMask) {
        return true;
    }

    public static class HelpTopic {
        private String href;
        private String title;
        private static Properties map = new Properties();

        public HelpTopic(String baseURL, String href) {
            this.title = HelpTopic.getTitle(href);
            this.href = baseURL + href;
        }

        public String getTitle() {
            return this.title;
        }

        public String getHref() {
            return this.href;
        }

        public static String getTitle(String href) {
            if (!href.contains("/")) {
                return href;
            }
            String title = map.getProperty(href);
            if (title == null) {
                HelpParser parser = new HelpParser();
                try {
                    InputStream in = HelpSystem.getHelpContent((String)href);
                    if (in == null) {
                        title = href;
                    } else {
                        parser.parse(in);
                        title = parser.getTitle();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (title == null) {
                    title = href;
                }
                map.setProperty(href, title);
            }
            return title;
        }
    }

    private class SearchCollector
    implements ISearchHitCollector {
        private Collection results;

        public SearchCollector(Collection results) {
            this.results = results;
        }

        public void addHits(List hits, String wordsSearched) {
            if (this.results != null) {
                this.results.addAll(hits);
            }
        }

        public void addQTCException(QueryTooComplexException exception) throws QueryTooComplexException {
        }
    }
}

