/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.connector;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.connector.PlatformConnector;
import com.ibm.ut.help.parser.TagAdapter;
import com.ibm.ut.help.parser.TagElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class PlatformXMLParser
extends TagAdapter {
    public static final File PLATFORM_XML = System.getProperty("help.platform.xml") != null ? new File(System.getProperty("help.platform.xml")) : new File(PlatformConnector.getConfigurationLocation(), "org.eclipse.update/platform.xml");
    private List<File> links = new ArrayList<File>();

    public PlatformXMLParser() {
        try {
            this.parse(new FileInputStream(PLATFORM_XML));
        }
        catch (Exception e) {
            Activator.logWarning("Could not read: " + String.valueOf(PLATFORM_XML), e);
        }
    }

    public void startElement(TagElement element) {
        File link;
        String linkfile;
        if (element.getTag().equalsIgnoreCase("site") && element.getProperty("enabled").equalsIgnoreCase("true") && !(linkfile = element.getProperty("linkfile")).equals("") && (link = this.getLink(linkfile)) != null && link.exists()) {
            this.links.add(link);
        }
    }

    public List<File> getLinks() {
        return this.links;
    }

    private File getLink(String linkfile) {
        try {
            String line;
            File file = new File(linkfile);
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("path=")) continue;
                String path = line.substring("path=".length());
                File f = new File(path, "eclipse");
                if (f.exists()) {
                    return f;
                }
                return new File(path);
            }
        }
        catch (Exception e) {
            Activator.logError("Could not read linkfile: " + linkfile, e);
        }
        return null;
    }
}

