/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.connector;

import com.ibm.ut.help.common.connector.IConnectorOperation;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.server.WebappManager;

public class ConnectorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    private void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.setCharacterEncoding("UTF-8");
        Enumeration names = req.getParameterNames();
        Properties props = new Properties();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.equals("op")) continue;
            props.setProperty(name, req.getParameter(name));
        }
        String result = ConnectorServlet.exec(req.getParameter("op"), props, (InputStream)req.getInputStream());
        if (result != null) {
            resp.getWriter().append(result);
        }
    }

    public static String exec(String op, Properties props, InputStream in) throws NumberFormatException, MalformedURLException {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ut.help.common.connector");
        int c = 0;
        while (c < configs.length) {
            if (configs[c].getAttribute("operation").equals(op)) {
                try {
                    IConnectorOperation operation = (IConnectorOperation)configs[c].createExecutableExtension("class");
                    return operation.exec(props, in);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++c;
        }
        return null;
    }

    public static String getThisURL() {
        BaseHelpSystem.ensureWebappRunning();
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help/" + ConnectorServlet.class.getCanonicalName();
    }
}

