/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common;

import com.ibm.ut.help.common.io.FileHandler;
import com.ibm.ut.help.common.prefs.Preferences;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "com.ibm.ut.help.common";
    private static Plugin plugin;
    public static boolean LOG_WARN;
    public static boolean LOG_INFO;
    public static final IStatus OK_STATUS;
    public static final IStatus CANCEL_STATUS;

    static {
        LOG_WARN = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ut.help.common/debug/warn"));
        LOG_INFO = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ut.help.common/debug/info"));
        OK_STATUS = new Status(0, PLUGIN_ID, 0, "OK", null);
        CANCEL_STATUS = new Status(8, PLUGIN_ID, 1, "Canceled", null);
    }

    public void start(BundleContext context) throws Exception {
        Activator.logDebug("Loaded Updater");
        plugin = this;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        FileHandler.saveQueue();
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = Preferences.isDebug() ? new Status(4, PLUGIN_ID, message, ex) : new Status(4, PLUGIN_ID, message);
        Activator.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logError(String message) {
        Activator.logError(message, null);
    }

    public static synchronized void logWarning(String message) {
        if (Activator.getDefault() != null && Activator.getDefault().isDebugging() && LOG_WARN) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, null);
            Activator.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public static synchronized void logWarning(String message, Throwable e) {
        if (Activator.getDefault() != null && Activator.getDefault().isDebugging() && LOG_WARN) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, e);
            Activator.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public static synchronized void logDebug(String message) {
        if (Activator.getDefault() != null && Activator.getDefault().isDebugging() && LOG_INFO) {
            if (message == null) {
                message = "";
            }
            Status status = new Status(1, PLUGIN_ID, message);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }
}

