/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;

public class WordsCommand
implements LpexCommand {
    @Override
    public boolean doCommand(LpexView lpexView, String parameters) {
        if (lpexView != null) {
            int lastElement;
            int firstElement;
            boolean selection;
            boolean wordIsAny = false;
            if ((parameters = parameters.trim()).length() != 0) {
                if ("?".equals(parameters)) {
                    lpexView.doCommand("set messageText Syntax: words [any]");
                    return true;
                }
                if ("any".equals(parameters)) {
                    wordIsAny = true;
                } else {
                    lpexView.doCommand("set messageText \"" + parameters + "\" is not a correct parameter for the words command.");
                    return false;
                }
            }
            int words = 0;
            int characters = 0;
            int lines = 0;
            if (lpexView.queryOn("block.inView") && lpexView.queryOn("block.anythingSelected")) {
                selection = true;
                int linesBeforeStart = lpexView.queryInt("lines.beforeStart");
                firstElement = lpexView.queryInt("block.topElement") - linesBeforeStart;
                lastElement = lpexView.queryInt("block.bottomElement") - linesBeforeStart;
            } else {
                selection = false;
                firstElement = 1;
                lastElement = lpexView.elements();
            }
            LpexDocumentLocation loc = new LpexDocumentLocation(1, 1);
            int e = firstElement;
            while (e <= lastElement) {
                if (!lpexView.show(e)) {
                    loc.element = e;
                    if (lpexView.queryOn("visible", loc)) {
                        ++lines;
                        String text = selection ? lpexView.query("block.elementText", loc) : lpexView.elementText(e);
                        boolean inWord = false;
                        int i = 0;
                        while (i < text.length()) {
                            char c = text.charAt(i);
                            if (Character.isWhitespace(c)) {
                                inWord = false;
                            } else {
                                ++characters;
                                if (wordIsAny || Character.isLetterOrDigit(c)) {
                                    if (!inWord) {
                                        inWord = true;
                                        ++words;
                                    }
                                } else {
                                    inWord = false;
                                }
                            }
                            ++i;
                        }
                    }
                }
                ++e;
            }
            lpexView.doCommand("set messageText words: " + (String)(words == 1 ? "1 word, " : words + " words, ") + (String)(characters == 1 ? "1 non-space character, " : characters + " non-space characters, ") + (String)(lines == 1 ? "1 line." : lines + " lines."));
        }
        return true;
    }
}

