/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexPaletteAttributes;
import com.ibm.lpex.core.LpexView;

public class TestParser2
extends LpexCommonParser {
    static final String CLASS_TEXT = "text";
    static final String CLASS_COMMENT = "comment";
    private long classText;
    private long classComment;
    private long classAll;

    public TestParser2(LpexView lpexView) {
        super(lpexView);
    }

    @Override
    protected void initParser() {
        String toBackground = LpexPaletteAttributes.background(this.view);
        String attributes = LpexPaletteAttributes.convert("0 0 255 255 255 255", "255 255 255", toBackground);
        this.setStyle("t", attributes);
        attributes = LpexPaletteAttributes.convert("0 128 128 255 255 255", "255 255 255", toBackground);
        this.setStyle("c", attributes);
        this.classText = this.view.registerClass(CLASS_TEXT);
        this.classComment = this.view.registerClass(CLASS_COMMENT);
        this.classAll = this.classText | this.classComment;
    }

    @Override
    public void parseAll() {
        int element = 1;
        while (element <= this.view.elements()) {
            this.parseOneElement(element);
            ++element;
        }
    }

    @Override
    public void parseElement(int element) {
        this.parseOneElement(element);
    }

    public void parseOneElement(int element) {
        String text = this.view.elementText(element);
        long classes = this.view.elementClasses(element) & (this.classAll ^ 0xFFFFFFFFFFFFFFFFL);
        Object styles = "";
        int i = text.indexOf("//");
        if (i < 0) {
            if (text.length() > 0) {
                styles = this.styleString('t', text.length());
                classes |= this.classText;
            }
        } else {
            styles = this.styleString('t', i) + this.styleString('c', text.length() - i);
            classes |= this.classComment;
            if (i > 0) {
                classes |= this.classText;
            }
        }
        this.view.setElementStyle(element, (String)styles);
        this.view.setElementClasses(element, classes);
    }
}

