/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import java.util.HashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.ScrollBar;

class Syncher
extends LpexViewAdapter
implements DisposeListener {
    private static HashMap<LpexView, Syncher> _synchers = new HashMap();
    private LpexView _mainView;
    private LpexView _syncView;
    private int _scrollBarValue;

    private Syncher(LpexView mainView, LpexView syncView) {
        this._mainView = mainView;
        this._syncView = syncView;
        _synchers.put(this._mainView, this);
        this._mainView.addLpexViewListener(this);
        this._syncView.addLpexViewListener(this);
        this._mainView.window().textWindow().addDisposeListener((DisposeListener)this);
        this._scrollBarValue = this.scrollBarValue();
    }

    static void install(LpexView mainView, LpexView syncView) {
        if (mainView == null || syncView == null || mainView.window() == null) {
            return;
        }
        if (_synchers.get(mainView) != null) {
            Syncher.uninstall(mainView);
        }
        if (_synchers.get(syncView) != null) {
            Syncher.uninstall(syncView);
        }
        new Syncher(mainView, syncView);
    }

    static void uninstall(LpexView mainView) {
        Syncher syncher = _synchers.get(mainView);
        if (syncher != null) {
            syncher.uninstall();
        }
    }

    private void uninstall() {
        if (this._mainView != null) {
            this._mainView.removeLpexViewListener(this);
            LpexWindow mainWindow = this._mainView.window();
            if (mainWindow != null) {
                mainWindow.textWindow().removeDisposeListener((DisposeListener)this);
            }
            if (this._syncView != null) {
                this._syncView.removeLpexViewListener(this);
                this._syncView = null;
            }
            _synchers.remove(this._mainView);
            this._mainView = null;
        }
    }

    @Override
    public void disposed(LpexView lpexView) {
        this.uninstall();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.uninstall();
    }

    @Override
    public void shown(LpexView lpexView) {
        int scrollBarValue;
        if (lpexView == this._mainView && (scrollBarValue = this.scrollBarValue()) != this._scrollBarValue) {
            int actionId = this._syncView.actionId(scrollBarValue > this._scrollBarValue ? "scrollDown" : "scrollUp");
            int i = Math.abs(scrollBarValue - this._scrollBarValue);
            while (i > 0) {
                this._syncView.doAction(actionId);
                --i;
            }
            this._syncView.doCommand("screenShow view");
            this._mainView.window().textWindow().update();
            LpexWindow syncWindow = this._syncView.window();
            if (syncWindow != null) {
                syncWindow.textWindow().update();
            }
            this._scrollBarValue = scrollBarValue;
        }
    }

    private int scrollBarValue() {
        ScrollBar scrollBar = this._mainView.window().textWindow().getVerticalBar();
        return scrollBar.isVisible() ? scrollBar.getSelection() : 1;
    }
}

