/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexMarkListener;
import com.ibm.lpex.core.LpexMatch;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

class Nester
extends LpexViewAdapter
implements DisposeListener,
LpexMarkListener,
PaintListener {
    static final int MAX_LEVEL = 5;
    static final int INDENT = 3;
    static final int MARGIN = 17;
    static HashMap<LpexView, Nester> _nesters = new HashMap();
    LpexView _lpexView;
    String _initPrefixArea;
    String _initPrefixAreaText;
    String _initPrefixAreaMargin;
    LpexCommand _initParseCommand;
    int _markId;
    int _markId1;
    char _bracket;
    char _bracketStyle;
    Color _extentColor;
    Color _badExtentColor;
    Color _backgroundColor;
    Image _image;
    ArrayList<Extent> _extents = new ArrayList();
    boolean _validExtents;

    private Nester(LpexView lpexView) {
        this._lpexView = lpexView;
        _nesters.put(this._lpexView, this);
        this._lpexView.addLpexViewListener(this);
        this._lpexView.window().textWindow().addDisposeListener((DisposeListener)this);
        this._lpexView.window().textWindow().addPaintListener((PaintListener)this);
        this._lpexView.setOwnerDrawMargin(true);
        this._extentColor = new Color((Device)this._lpexView.window().getDisplay(), 0, 0, 128);
        this._badExtentColor = new Color((Device)this._lpexView.window().getDisplay(), 255, 0, 0);
        if ("off".equals(this._lpexView.query("current.prefixArea"))) {
            this._initPrefixArea = this._lpexView.query("prefixArea");
            this._initPrefixAreaText = this._lpexView.query("prefixAreaText");
            this._lpexView.doCommand("set prefixAreaText none");
        }
        if (this._lpexView.queryInt("current.prefixAreaMargin") < 17) {
            this._initPrefixAreaMargin = this._lpexView.query("prefixAreaMargin");
            this._lpexView.doCommand("set prefixAreaMargin 17");
        }
        this.initTransients();
        this._markId = this._lpexView.queryInt("markId.@NestingCommand");
        this._markId1 = this._lpexView.queryInt("markId.@NestingCommand1");
        this._lpexView.addLpexMarkListener(this._markId, this);
        this._lpexView.addLpexMarkListener(this._markId1, this);
    }

    final void initTransients() {
        if (this._backgroundColor != null) {
            this._backgroundColor.dispose();
        }
        String[] ma = this._lpexView.query("styleAttributes.prefixArea").split(" ");
        this._backgroundColor = new Color((Device)this._lpexView.window().getDisplay(), Integer.parseInt(ma[3]), Integer.parseInt(ma[4]), Integer.parseInt(ma[5]));
        this._lpexView.doCommand("set prefixArea on");
        this._initParseCommand = this._lpexView.defineCommand("parse", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView lpexView, String parameters) {
                return Nester.this.doParseCommand(lpexView, parameters);
            }
        });
    }

    static void install(LpexView lpexView) {
        int markPosition1;
        int markElement1;
        int markPosition;
        int markElement;
        if (lpexView == null || lpexView.window() == null) {
            return;
        }
        LpexDocumentLocation loc = lpexView.documentLocation();
        if (loc.element == 0) {
            lpexView.doCommand("set messageText No visible elements.");
            return;
        }
        if (lpexView.show(loc.element)) {
            lpexView.doCommand("set messageText Current position on a show line.");
            return;
        }
        lpexView.doCommand("parse");
        LpexDocumentLocation match = LpexMatch.match(lpexView, loc);
        if (match == null) {
            lpexView.doCommand("set messageText No match for the current position.");
            return;
        }
        if (_nesters.get(lpexView) != null) {
            Nester.uninstall(lpexView);
        }
        if (match.element >= loc.element) {
            markElement = loc.element;
            markPosition = match.position > loc.position ? loc.position : match.position;
            markElement1 = match.element;
            markPosition1 = match.position > loc.position ? match.position : loc.position;
        } else {
            markElement = match.element;
            markPosition = match.position;
            markElement1 = loc.element;
            markPosition1 = loc.position;
        }
        lpexView.doCommand("set mark.@NestingCommand " + markElement + " " + markPosition);
        lpexView.doCommand("set mark.@NestingCommand1 " + markElement1 + " " + markPosition1);
        Nester n = new Nester(lpexView);
        n._bracket = lpexView.elementText(markElement).charAt(markPosition - 1);
        String style = lpexView.elementStyle(markElement);
        n._bracketStyle = (char)(style.length() >= markPosition ? (int)style.charAt(markPosition - 1) : 33);
    }

    static void uninstall(LpexView lpexView) {
        Nester nester = _nesters.get(lpexView);
        if (nester != null) {
            nester.uninstall();
        }
    }

    private void uninstall() {
        if (this._lpexView != null) {
            Composite textWindow;
            this._lpexView.setOwnerDrawMargin(false);
            this._lpexView.defineCommand("parse", this._initParseCommand);
            this._lpexView.removeLpexViewListener(this);
            this._lpexView.removeLpexMarkListener(this._markId, this);
            this._lpexView.doCommand("set mark.@NestingCommand clear");
            this._lpexView.doCommand("set mark.@NestingCommand1 clear");
            LpexWindow lpexWindow = this._lpexView.window();
            if (lpexWindow != null && !(textWindow = lpexWindow.textWindow()).isDisposed()) {
                textWindow.removePaintListener((PaintListener)this);
                textWindow.removeDisposeListener((DisposeListener)this);
                textWindow.redraw();
            }
            if (this._initPrefixAreaMargin != null) {
                this._lpexView.doCommand("set prefixAreaMargin " + this._initPrefixAreaMargin);
            }
            if (this._initPrefixAreaText != null) {
                this._lpexView.doCommand("set prefixAreaText " + this._initPrefixAreaText);
            }
            if (this._initPrefixArea != null) {
                this._lpexView.doCommand("set prefixArea " + this._initPrefixArea);
            }
            this._extentColor.dispose();
            this._badExtentColor.dispose();
            this._backgroundColor.dispose();
            if (this._image != null) {
                this._image.dispose();
            }
            _nesters.remove(this._lpexView);
            this._lpexView = null;
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.uninstall();
    }

    @Override
    public void markChanged(LpexView lpexView, int markId) {
        this.uninstall();
    }

    @Override
    public void markDeleted(LpexView lpexView, int markId) {
        this.uninstall();
    }

    @Override
    public void disposed(LpexView lpexView) {
        this.uninstall();
    }

    @Override
    public void updateProfile(LpexView lpexView) {
        this.initTransients();
        this._validExtents = false;
    }

    @Override
    public void shown(LpexView lpexView) {
        this.getExtents();
        this.doubleBufferPaint(null);
    }

    public void paintControl(PaintEvent e) {
        if (e.x > this._lpexView.queryInt("prefixAreaWidth")) {
            return;
        }
        this.doubleBufferPaint(e);
    }

    boolean doParseCommand(LpexView lpexView, String parameters) {
        if (this._initParseCommand != null) {
            this._initParseCommand.doCommand(lpexView, parameters);
        } else {
            this._lpexView.doDefaultCommand("parse " + parameters);
        }
        this._validExtents = false;
        return true;
    }

    void doubleBufferPaint(PaintEvent e) {
        LpexWindow lpexWindow = this._lpexView.window();
        if (lpexWindow == null) {
            return;
        }
        int prefixAreaWidth = this._lpexView.queryInt("prefixAreaWidth");
        if (prefixAreaWidth == 0) {
            return;
        }
        int rowHeight = this._lpexView.queryInt("rowHeight");
        int rows = this._lpexView.queryInt("rows");
        int y = 0;
        int i = rows;
        while (i > 0 && this._lpexView.elementOfRow(i) == 0) {
            --rows;
            --i;
        }
        if (rows > 0 && this._lpexView.elementOfRow(1) == 0) {
            y += rowHeight;
            --rows;
        }
        if (rows == 0) {
            return;
        }
        int height = rows * rowHeight;
        int prefixAreaMargin = this._lpexView.queryInt("current.prefixAreaMargin");
        if (this._image != null) {
            Rectangle r = this._image.getBounds();
            if (r.width != prefixAreaMargin || r.height != height) {
                this._image.dispose();
                this._image = null;
            }
        }
        if (this._image == null) {
            this._image = new Image((Device)lpexWindow.getDisplay(), prefixAreaMargin, height);
        }
        GC imageGC = new GC((Drawable)this._image);
        imageGC.setBackground(this._backgroundColor);
        imageGC.fillRectangle(0, 0, prefixAreaMargin, height);
        imageGC.setLineStyle(1);
        imageGC.setLineWidth(1);
        this.doPaint(imageGC, y);
        GC g = e != null ? e.gc : new GC((Drawable)lpexWindow.textWindow());
        g.drawImage(this._image, this._lpexView.queryInt("expandHideAreaWidth") + prefixAreaWidth - prefixAreaMargin, y);
        imageGC.dispose();
        if (e == null) {
            g.dispose();
        }
    }

    void getExtents() {
        if (this._validExtents && this._lpexView.parser() != null) {
            return;
        }
        this._extents.clear();
        String start = this._lpexView.query("mark.@NestingCommand");
        String end = this._lpexView.query("mark.@NestingCommand1");
        if (start != null && end != null) {
            String[] loc = start.split(" ");
            LpexDocumentLocation top = new LpexDocumentLocation(Integer.parseInt(loc[0]), Integer.parseInt(loc[1]));
            loc = end.split(" ");
            LpexDocumentLocation match = new LpexDocumentLocation(Integer.parseInt(loc[0]), Integer.parseInt(loc[1]));
            if (top.element != match.element) {
                this._extents.add(new Extent(top.element, match.element, 0));
                this.getExtents(top, match, 1);
            }
        }
        this._validExtents = true;
    }

    void getExtents(LpexDocumentLocation start, LpexDocumentLocation end, int level) {
        if (level >= 5) {
            return;
        }
        boolean skippingFoundBlock = false;
        int startOffset = start.position;
        int e = start.element;
        while (e <= end.element) {
            if (!this._lpexView.show(e)) {
                String text = this._lpexView.elementText(e);
                int len = e != end.element ? text.length() : end.position;
                int i = startOffset;
                while (i < len) {
                    if (text.charAt(i) == this._bracket) {
                        char s;
                        String style = this._lpexView.elementStyle(e);
                        char c = s = i < style.length() ? (char)style.charAt(i) : (char)'!';
                        if (s == this._bracketStyle) {
                            int endElement;
                            LpexDocumentLocation top = new LpexDocumentLocation(e, i + 1);
                            LpexDocumentLocation match = LpexMatch.match(this._lpexView, top);
                            boolean mismatch = match == null || match.element > end.element || match.element == end.element && match.position == end.position;
                            int n = endElement = mismatch || match == null ? this._lpexView.elements() + 1 : match.element;
                            if (top.element != endElement) {
                                this._extents.add(new Extent(top.element, endElement, level));
                                this.getExtents(top, match != null ? match : end, level + 1);
                            }
                            if (match == null) {
                                return;
                            }
                            e = endElement;
                            startOffset = match.position;
                            skippingFoundBlock = true;
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (!skippingFoundBlock) {
                ++e;
                startOffset = 0;
            }
            skippingFoundBlock = false;
        }
    }

    void doPaint(GC gc, int imageShift) {
        if (this._extents.size() == 0) {
            return;
        }
        int rows = this._lpexView.queryInt("rows");
        int lowestShowing = this._lpexView.queryInt("lines") + 1 - (this._lpexView.queryInt("lines.beforeStart") + this._lpexView.queryInt("lines.afterEnd"));
        int highestShowing = 0;
        int i = 1;
        while (i <= rows) {
            int element = this._lpexView.elementOfRow(i);
            if (element != 0 && !this._lpexView.show(element)) {
                int line = this._lpexView.lineOfElement(element);
                if (line < lowestShowing) {
                    lowestShowing = line;
                }
                if (line > highestShowing) {
                    highestShowing = line;
                }
            }
            ++i;
        }
        if (highestShowing == 0) {
            return;
        }
        int rowHeight = this._lpexView.queryInt("rowHeight");
        int currentMargin = this._lpexView.queryInt("current.prefixAreaMargin");
        int windowHeight = this._lpexView.window().textWindow().getSize().y;
        int e = 0;
        while (e < this._extents.size()) {
            Extent extent = this._extents.get(e);
            int startLine = extent.startLine;
            int endLine = extent.endLine;
            if (startLine <= highestShowing && endLine >= lowestShowing) {
                int y;
                int startRow = -1;
                int endRow = -1;
                boolean realStart = false;
                boolean realEnd = false;
                int i2 = 1;
                while (i2 <= rows) {
                    int element = this._lpexView.elementOfRow(i2);
                    if (element != 0 && !this._lpexView.show(element)) {
                        int line = this._lpexView.lineOfElement(element);
                        if (line == startLine) {
                            startRow = i2 - 1;
                            realStart = true;
                        } else if (line > startLine && startRow == -1 && line <= endLine) {
                            endRow = startRow = i2 - 1;
                            boolean bl = realEnd = line == endLine;
                        }
                        if (line > endLine) break;
                        if (line == endLine) {
                            endRow = i2 - 1;
                            realEnd = true;
                            break;
                        }
                        if (line < endLine && startRow != -1) {
                            endRow = i2 - 1;
                        }
                    }
                    ++i2;
                }
                if (startRow >= 0 && (y = startRow * rowHeight - imageShift) < windowHeight) {
                    int height = (endRow - startRow + 1) * rowHeight;
                    if (realStart) {
                        y += rowHeight / 2;
                        height -= rowHeight / 2;
                    }
                    if (realEnd) {
                        height -= rowHeight / 2;
                    }
                    gc.setForeground(extent.bad ? this._badExtentColor : this._extentColor);
                    int x = currentMargin - 17 + 3 + extent.nestingLevel * 2;
                    gc.drawLine(x, y, x, y + height);
                    int arrowWidth = currentMargin - x - 3;
                    if (realStart) {
                        gc.drawLine(x, y, x + arrowWidth, y);
                        gc.drawLine(x + arrowWidth - 2, y - 2, x + arrowWidth + 1, y);
                        gc.drawLine(x + arrowWidth - 2, y + 2, x + arrowWidth + 1, y);
                    }
                    if (realEnd) {
                        gc.drawLine(x, y + height, x + arrowWidth, y + height);
                        gc.drawLine(x + arrowWidth - 2, y + height - 2, x + arrowWidth + 1, y + height);
                        gc.drawLine(x + arrowWidth - 2, y + height + 2, x + arrowWidth + 1, y + height);
                    }
                }
            }
            ++e;
        }
    }

    class Extent {
        int startLine;
        int endLine;
        int nestingLevel;
        boolean bad;

        Extent(int startElement, int endElement, int nestingLevel) {
            this.startLine = Nester.this._lpexView.lineOfElement(startElement);
            this.endLine = Nester.this._lpexView.lineOfElement(endElement);
            if (this.endLine == 0) {
                this.endLine = Nester.this._lpexView.queryInt("lines") + 1;
                this.bad = true;
            }
            this.nestingLevel = nestingLevel;
        }
    }
}

