/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import java.io.File;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public final class Lpex2 {
    private Shell _shell;
    private LpexMultiWindow _lpexMultiWindow;

    public static void main(String[] args) {
        new Lpex2(args).run().close();
    }

    private Lpex2(String[] parms) {
        String filename = null;
        String encoding = "";
        int i = 0;
        if (i < parms.length && !parms[i].startsWith("-") && !parms[i].startsWith("/")) {
            filename = LpexStringTokenizer.trimQuotes(parms[i++]);
        }
        while (i < parms.length - 1 && (parms[i].startsWith("-") || parms[i].startsWith("/"))) {
            String parm;
            if (!"encoding".equals(parm = parms[i++].substring(1)) && !"enc".equals(parm)) break;
            encoding = parms[i++];
        }
        if (filename != null) {
            if (filename.trim().length() == 0) {
                filename = null;
            } else {
                try {
                    filename = new File(filename).getCanonicalPath();
                }
                catch (Exception parm) {
                    // empty catch block
                }
            }
        }
        this._shell = new Shell();
        this._shell.setLayout((Layout)new FillLayout());
        this._shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                Lpex2.this.closeShell(event);
            }
        });
        LpexView lpexView1 = null;
        LpexView lpexView0 = new LpexView(filename, encoding, false);
        try {
            lpexView1 = new LpexView(lpexView0, false);
        }
        catch (LpexView.ViewInstantiationException viewInstantiationException) {
            // empty catch block
        }
        this._lpexMultiWindow = new LpexMultiWindow((Composite)this._shell, 0);
        this._lpexMultiWindow.newWindow(lpexView0, 2048);
        this._lpexMultiWindow.newWindow(lpexView1, 2112);
        this._shell.setText("Lpex2 - " + this.documentName());
        LpexViewAdapter lpexViewAdapter = new LpexViewAdapter(){

            @Override
            public void updateProfile(LpexView lpexView) {
                Lpex2.this.updateProfile(lpexView);
            }
        };
        lpexView0.addLpexViewListener(lpexViewAdapter);
        if (lpexView1 != null) {
            lpexView1.addLpexViewListener(lpexViewAdapter);
        }
        lpexView0.doCommand("set updateProfile.palette gray");
        lpexView0.doCommand("updateProfile");
        if (lpexView1 != null) {
            lpexView1.doCommand("updateProfile");
        }
        Rectangle bounds = new Rectangle(10, 10, 1000, 711);
        this._shell.setBounds(bounds);
        this._shell.open();
    }

    private String documentName() {
        LpexView lpexView = this._lpexMultiWindow.getFirstWindow().getLpexView();
        String name = lpexView.query("name");
        return name != null ? name : LpexResources.message("untitledDocument", lpexView.query("documentId"));
    }

    private Lpex2 run() {
        Display display = this._shell.getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this;
    }

    private Lpex2 close() {
        if (this._shell != null && !this._shell.isDisposed()) {
            this._shell.dispose();
        }
        this._shell = null;
        return this;
    }

    void updateProfile(LpexView lpexView) {
        lpexView.defineCommand("ver", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return view.doCommand("set splitWindow.orientation vertical");
            }
        });
        lpexView.defineCommand("hor", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return view.doCommand("set splitWindow.orientation horizontal");
            }
        });
    }

    private void closeShell(Event event) {
        event.doit = this.closeWindow();
    }

    private boolean closeWindow() {
        boolean close = true;
        LpexView lpexView = this._lpexMultiWindow.getFirstWindow().getLpexView();
        if (lpexView != null && (lpexView.queryInt("changes") != 0 || lpexView.queryOn("dirty"))) {
            MessageBox box = new MessageBox(this._shell, 452);
            box.setText(this._shell.getText());
            box.setMessage(LpexResources.message("file.saveChanges", this.documentName()));
            int rc = box.open();
            if (rc == 64) {
                lpexView.doCommand("save");
                if (lpexView.query("status") != null) {
                    close = false;
                }
            } else if (rc == 256) {
                close = false;
            }
        }
        return close;
    }
}

