/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexBaseAction;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

class KeyReferenceDialog
extends PopupDialog {
    LpexView _lpexView;
    IWorkbench _workbench;
    Table _table;
    static final String[] hiddenActions = new String[]{"appendToActionArgument", "eclipseCopy", "eclipseCut", "eclipseDelete", "eclipsePaste", "eclipseRedo", "eclipseUndo", "nullAction", "saveToWriter"};

    KeyReferenceDialog(LpexView lpexView) {
        super(null, 4, true, true, false, false, false, null, null);
        this._lpexView = lpexView;
        try {
            this._workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String parser = this._lpexView.query("parser");
        if (parser != null) {
            this.setInfoText(LpexResources.message("keyReferencePP", this._lpexView.query("baseProfile"), parser));
        } else {
            this.setInfoText(LpexResources.message("keyReferenceP", this._lpexView.query("baseProfile")));
        }
    }

    public int open() {
        Shell shell = this.getShell();
        if (shell != null) {
            this.close();
        }
        this.create();
        this.setLocationAndSize();
        return super.open();
    }

    protected void setParentShell(Shell newParentShell) {
        super.setParentShell(newParentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this._table = new Table(parent, 65540);
        this._table.setBackground(parent.getBackground());
        this._table.setLinesVisible(true);
        TableColumn actionNameColumn = new TableColumn(this._table, 16384, 0);
        TableColumn actionKeyColumn = new TableColumn(this._table, 16384, 1);
        this.populateTableWithActionKeys();
        actionNameColumn.pack();
        actionKeyColumn.pack();
        this._table.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                KeyReferenceDialog.this.selectionEvent();
            }
        });
        this._table.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                KeyReferenceDialog.this.hoverEvent(event);
            }
        });
        if (this._workbench != null) {
            this._table.addListener(28, new Listener(){

                public void handleEvent(Event event) {
                    KeyReferenceDialog.this.helpEvent();
                }
            });
        }
        return this._table;
    }

    private void setLocationAndSize() {
        int y;
        int x;
        Shell shell = this.getShell();
        int width = shell.getSize().x;
        int height = shell.getSize().y;
        if (this._workbench != null) {
            Rectangle workbenchBounds = this._workbench.getWorkbenchWindows()[0].getShell().getBounds();
            int maxHeight = workbenchBounds.height / 2;
            if (height > maxHeight) {
                height = maxHeight;
            }
            x = workbenchBounds.x + workbenchBounds.width - width - 10;
            y = workbenchBounds.y + workbenchBounds.height - height - 10;
        } else {
            Rectangle displayBounds = shell.getDisplay().getClientArea();
            int maxHeight = displayBounds.height / 2;
            if (height > maxHeight) {
                height = maxHeight;
            }
            x = displayBounds.width - width - 10;
            y = displayBounds.height - height - 10;
        }
        shell.setBounds(x, y, width, height);
    }

    private void populateTableWithActionKeys() {
        TreeSet<String> treeSet = new TreeSet<String>();
        LpexStringTokenizer st = new LpexStringTokenizer(this._lpexView.query("defaultActions") + " " + this._lpexView.query("actions"));
        while (st.hasMoreTokens()) {
            String actionName = st.nextToken();
            if (!this.showAction(actionName)) continue;
            if (this._workbench != null && actionName.equalsIgnoreCase("cslAction")) {
                actionName = "Show Eclipse key assist";
            }
            treeSet.add(actionName);
        }
        Color unavailableColor = this._table.getDisplay().getSystemColor(16);
        for (String actionName : treeSet) {
            int actionId = this._lpexView.actionId(actionName);
            String keyText = this._lpexView.actionKeyText(actionId);
            TableItem item = new TableItem(this._table, 0);
            item.setText(0, actionName);
            item.setText(1, keyText != null ? keyText : "");
            item.setData((Object)actionName);
            if (actionId == 0 || this._lpexView.actionAvailable(actionId)) continue;
            item.setForeground(unavailableColor);
        }
    }

    private boolean showAction(String actionName) {
        int i = 0;
        while (i < hiddenActions.length) {
            if (hiddenActions[i].equals(actionName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Control getFocusControl() {
        return this._table;
    }

    private void selectionEvent() {
        int selectedIndex = this._table.getSelectionIndex();
        if (selectedIndex >= 0) {
            String actionName = (String)this._table.getItem(selectedIndex).getData();
            if (this._workbench != null && actionName.equalsIgnoreCase("Show Eclipse key assist")) {
                super.close();
                ((IBindingService)this._workbench.getService(IBindingService.class)).openKeyAssistDialog();
                return;
            }
            int actionId = this._lpexView.actionId(actionName);
            if (this._lpexView.actionAvailable(actionId)) {
                super.close();
                this._lpexView.triggerAction(actionId);
            }
        }
    }

    private void hoverEvent(Event event) {
        String tooltip = null;
        TableItem item = this._table.getItem(new Point(event.x, event.y));
        if (item != null) {
            String actionName = (String)item.getData();
            LpexAction action = this._lpexView.action(actionName);
            if (action != null && action instanceof LpexBaseAction) {
                tooltip = ((LpexBaseAction)action).getToolTipText(this._lpexView);
            }
            if (tooltip == null) {
                tooltip = LpexResources.message("popup." + actionName + ".description");
            }
        }
        this._table.setToolTipText(tooltip);
    }

    private void helpEvent() {
        int selectedIndex = this._table.getSelectionIndex();
        if (selectedIndex >= 0) {
            String actionName = (String)this._table.getItem(selectedIndex).getData();
            LpexAction action = this._lpexView.action(actionName);
            Object contextHelpId = null;
            if (action != null && action instanceof LpexBaseAction) {
                contextHelpId = ((LpexBaseAction)action).getHelpId(this._lpexView);
            }
            if (contextHelpId == null) {
                contextHelpId = "com.ibm.lpex.popup_" + actionName + "_context";
            }
            super.close();
            this._workbench.getHelpSystem().displayHelp((String)contextHelpId);
        }
    }
}

