/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import java.util.HashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;

public class CursorHairline
extends LpexViewAdapter
implements PaintListener,
DisposeListener {
    private static HashMap<LpexView, CursorHairline> _cursorHairlines = new HashMap();
    private LpexView _lpexView;
    private LpexWindow _lpexWindow;
    private String _originalCursorWidth;
    private boolean _trackCursor;
    private int _fixedPixelPosition;
    private int _pixelPosition;
    private int _height;
    private int _y;
    private static int _hairlineWidth = 1;
    private int _hairlineStyle = 1;
    private Color _hairlineColor;
    private int _R = 220;
    private int _G = 220;
    private int _B = 220;

    private CursorHairline(LpexView lpexView) {
        this._lpexView = lpexView;
        this._lpexView.addLpexViewListener(this);
        _cursorHairlines.put(lpexView, this);
    }

    public static void install(LpexView lpexView, boolean trackCursor) {
        if (lpexView != null) {
            CursorHairline ch = _cursorHairlines.get(lpexView);
            if (ch == null) {
                ch = new CursorHairline(lpexView);
            }
            ch._trackCursor = trackCursor;
            ch._fixedPixelPosition = -1;
        }
    }

    public static void uninstall(LpexView lpexView) {
        CursorHairline ch = _cursorHairlines.get(lpexView);
        if (ch != null) {
            ch.uninstall();
        }
    }

    private void uninstall() {
        if (this._lpexView != null) {
            this._lpexView.removeLpexViewListener(this);
            if (this._lpexWindow != null) {
                Composite textWindow = this._lpexWindow.textWindow();
                if (!textWindow.isDisposed()) {
                    textWindow.removePaintListener((PaintListener)this);
                    textWindow.removeDisposeListener((DisposeListener)this);
                    if (this._originalCursorWidth != null) {
                        this._lpexView.doCommand("set cursor.width " + this._originalCursorWidth);
                    }
                    textWindow.redraw();
                }
                this._lpexWindow = null;
                this._hairlineColor.dispose();
            }
            _cursorHairlines.remove(this._lpexView);
            this._lpexView = null;
        }
    }

    @Override
    public void shown(LpexView lpexView) {
        if (this._lpexWindow == null) {
            this._lpexWindow = this._lpexView.window();
            if (this._lpexWindow != null) {
                this._hairlineColor = new Color((Device)this._lpexWindow.getDisplay(), this._R, this._G, this._B);
                this._lpexWindow.textWindow().addDisposeListener((DisposeListener)this);
                this._lpexWindow.textWindow().addPaintListener((PaintListener)this);
            }
        }
        if (this._lpexWindow != null) {
            int pixelPosition;
            if (this._lpexView.queryInt("current.cursor.width") == 1) {
                this._originalCursorWidth = this._lpexView.query("cursor.width");
                this._lpexView.doCommand("set cursor.width 2");
            }
            int n = pixelPosition = this._trackCursor || this._fixedPixelPosition == -1 ? this._lpexView.queryInt("pixelPosition") : this._fixedPixelPosition;
            if (!this._trackCursor && this._fixedPixelPosition == -1) {
                this._fixedPixelPosition = pixelPosition;
            }
            if (pixelPosition >= 0) {
                pixelPosition += this._lpexView.queryInt("prefixAreaWidth") + this._lpexView.queryInt("expandHideAreaWidth") - this._lpexView.queryInt("scroll");
            }
            int rowHeight = this._lpexView.queryInt("rowHeight");
            int rows = this._lpexView.queryInt("rows");
            int y = 0;
            int height = 0;
            if (rows > 0) {
                if (this._lpexView.elementOfRow(1) == 0) {
                    y = rowHeight;
                } else {
                    height = rowHeight;
                }
                int i = 2;
                while (i <= rows && this._lpexView.elementOfRow(i) != 0) {
                    height += rowHeight;
                    ++i;
                }
            }
            if (pixelPosition != this._pixelPosition || height != this._height || y != this._y) {
                Composite textWindow = this._lpexWindow.textWindow();
                if (this._height > 0) {
                    textWindow.redraw(this._pixelPosition, this._y, _hairlineWidth, this._height, false);
                }
                if (height > 0 && pixelPosition > 0) {
                    textWindow.redraw(pixelPosition, y, _hairlineWidth, height, false);
                }
                this._pixelPosition = pixelPosition;
                this._height = height;
                this._y = y;
            }
        }
    }

    @Override
    public void disposed(LpexView lpexView) {
        this.uninstall();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.uninstall();
    }

    public void paintControl(PaintEvent e) {
        if (this._lpexWindow != null && this._height > 0 && this._pixelPosition > 0) {
            e.gc.setForeground(this._hairlineColor);
            e.gc.setLineStyle(this._hairlineStyle);
            e.gc.setLineWidth(_hairlineWidth);
            e.gc.drawLine(this._pixelPosition, this._y, this._pixelPosition, this._y + this._height);
        }
    }
}

