/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;

public class ComposeAction
implements LpexAction {
    private static final String[] _compose = new String[]{"\u00c1", "A'", "\u00e1", "a'", "\u00c5", "A*", "\u00e5", "a*", "\u00c2", "A^", "\u00e2", "a^", "\u00c0", "A`", "\u00e0", "a`", "\u00c3", "A~", "\u00e3", "a~", "\u00c4", "A\"", "\u00e4", "a\"", "\u0102", "A&", "\u0103", "a&", "\u00c6", "AE", "\u00e6", "ae", "\u00a6", "/|", "\u00c7", "C,", "\u00e7", "c,", "\u00b8", ",,", "\u00b7", "^.", "\u00b0", "/0", "\u00f7", ":-", "\u00c9", "E'", "\u00e9", "e'", "\u00ca", "E^", "\u00ea", "e^", "\u00c8", "E`", "\u00e8", "e`", "\u00cb", "E\"", "\u00eb", "e\"", "\u2014", "--", "\u00f0", "d-", "\u00d0", "D-", "\u00aa", "a_", "\u00aa", "A_", "\u00ad", "-=", "\u00cd", "I'", "\u00ed", "i'", "\u00ce", "I^", "\u00ee", "i^", "\u00cc", "I`", "\u00ec", "i`", "\u00cf", "I\"", "\u00ef", "i\"", "\u00a1", "!!", "\u00bf", "??", "\u00ab", "<<", "\u00ba", "O_", "\u00ba", "o_", "\u00b5", "/u", "\u00d7", "xx", "\u00d7", "XX", "\u00d1", "N~", "\u00f1", "n~", "\u00ac", "-]", "\u2260", "/=", "\u00d3", "O'", "\u00f3", "o'", "\u00d4", "O^", "\u00f4", "o^", "\u00d2", "O`", "\u00f2", "o`", "\u00d8", "O/", "\u00f8", "o/", "\u00d5", "O~", "\u00f5", "o~", "\u00d6", "O\"", "\u00f6", "o\"", "\u00af", "^_", "\u00b6", "/p", "\u00b1", "+-", "\u00bb", ">>", "\u015e", "S,", "\u015f", "s,", "\u00a7", "/s", "\u00df", "ss", "\u0162", "T,", "\u0163", "t,", "\u00fe", "p-", "\u00de", "P-", "\u2122", "T0", "\u2122", "t0", "\u2122", "(T)", "\u2122", "(t)", "\u00da", "U'", "\u00fa", "u'", "\u00db", "U^", "\u00fb", "u^", "\u00d9", "U`", "\u00f9", "u`", "\u00dc", "U\"", "\u00fc", "u\"", "\u00dd", "Y'", "\u00fd", "y'", "\u00ff", "y\"", "\u00a9", "C0", "\u00a9", "c0", "\u00a9", "(C)", "\u00a9", "(c)", "\u00ae", "R0", "\u00ae", "r0", "\u00ae", "(R)", "\u00ae", "(r)", "\u00a4", "X0", "\u00a4", "x0", "\u00a2", "c|", "\u00a2", "c/", "\u00a2", "C|", "\u00a2", "C/", "\u20ac", "C=", "\u20ac", "c=", "\u20ac", "C-", "\u20ac", "c-", "\u00a3", "L=", "\u00a3", "l=", "\u00a3", "L-", "\u00a3", "l-", "\u00a5", "Y=", "\u00a5", "y=", "\u00a5", "Y-", "\u00a5", "y-", "\u2070", "^0", "\u00b9", "^1", "\u00b2", "^2", "\u00b3", "^3", "\u2074", "^4", "\u2075", "^5", "\u2076", "^6", "\u2077", "^7", "\u2078", "^8", "\u2079", "^9", "\u207a", "^+", "\u207b", "^-", "\u00bd", "1/2", "\u2153", "1/3", "\u00bc", "1/4", "\u2155", "1/5", "\u2159", "1/6", "\u215b", "1/8", "\u2154", "2/3", "\u2156", "2/5", "\u00be", "3/4", "\u2157", "3/5", "\u215c", "3/8", "\u2158", "4/5", "\u215a", "5/6", "\u215d", "5/8", "\u215e", "7/8"};
    public static final LpexCommand composeCommand = new LpexCommand(){

        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            return ComposeAction.doComposeCommand(lpexView, parameters, _compose, "compose", lpexView.queryOn("userParameter.Compose.onlyDefinedOrder"));
        }
    };
    public static final LpexAction composeAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            ComposeAction.promptForCompose(lpexView, "compose");
        }

        @Override
        public boolean available(LpexView lpexView) {
            return lpexView.currentElement() != 0 && !lpexView.queryOn("readonly");
        }
    };

    static boolean doComposeCommand(LpexView lpexView, String parameters, String[] composeTable, String composeCommandName, boolean onlyDefinedOrder) {
        lpexView.doDefaultCommand("set messageText");
        boolean onlySpecialCharacters = lpexView.queryOn("userParameter.Compose.onlySpecialCharacters");
        while (parameters.length() > 0) {
            String c;
            int index = ComposeAction.findSpecialCharacter(parameters, onlyDefinedOrder, composeTable);
            if (index == 0 && onlySpecialCharacters) break;
            String string = c = index != 0 ? composeTable[index - 1] : String.valueOf(parameters.charAt(0));
            if (!ComposeAction.typeIn(lpexView, c)) {
                ComposeAction.promptForCompose(lpexView, composeCommandName, parameters);
                return false;
            }
            if ((parameters = parameters.substring(index != 0 ? composeTable[index].length() : 1)).length() != 0) continue;
            return true;
        }
        lpexView.doCommand("set messageText Cannot compose character from \"" + parameters + "\".");
        ComposeAction.promptForCompose(lpexView, composeCommandName, parameters);
        return false;
    }

    static int findSpecialCharacter(String sequence, boolean onlyDefinedOrder, String[] composeTable) {
        String reverseSequence = onlyDefinedOrder || sequence.length() < 2 ? null : new String(new char[]{sequence.charAt(1), sequence.charAt(0)});
        int i = 1;
        while (i < composeTable.length) {
            String composeSequence = composeTable[i];
            if (composeSequence.length() == 1) {
                if (composeSequence.charAt(0) == sequence.charAt(0)) {
                    return i;
                }
            } else {
                if (sequence.startsWith(composeSequence)) {
                    return i;
                }
                if (!onlyDefinedOrder && composeSequence.length() == 2 && composeSequence.equals(reverseSequence) && !composeSequence.equals("AE") && !composeSequence.equals("ae")) {
                    return i;
                }
            }
            i += 2;
        }
        return 0;
    }

    static boolean typeIn(LpexView lpexView, String c) {
        boolean inserting;
        if (lpexView.queryOn("block.inView") && "stream".equals(lpexView.query("block.type"))) {
            lpexView.doCommand("block delete");
            inserting = true;
        } else {
            inserting = lpexView.queryOn("insertMode");
        }
        boolean success = lpexView.doCommand((inserting ? "insertText " : "replaceText ") + c);
        return success;
    }

    static void promptForCompose(LpexView lpexView, String composeCommand) {
        ComposeAction.promptForCompose(lpexView, composeCommand, null);
    }

    static void promptForCompose(LpexView lpexView, String composeCommand, String composeSequence) {
        String text = composeSequence != null ? LpexStringTokenizer.addQuotes(composeSequence) : "";
        LpexView.doGlobalCommand("set status");
        lpexView.doCommand("input \"Compose:\" " + text + " \"" + composeCommand + " \"");
    }

    @Override
    public void doAction(LpexView lpexView) {
        if (lpexView.command("compose") != composeCommand) {
            lpexView.defineCommand("compose", composeCommand);
        }
        ComposeAction.promptForCompose(lpexView, "compose");
    }

    @Override
    public boolean available(LpexView lpexView) {
        return lpexView.currentElement() != 0 && !lpexView.queryOn("readonly");
    }
}

