/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;
import java.util.HashMap;

final class UserParameterParameter
extends Parameter {
    private static UserParameterParameter _parameter;

    static UserParameterParameter getParameter() {
        if (_parameter == null) {
            _parameter = new UserParameterParameter();
        }
        return _parameter;
    }

    private UserParameterParameter() {
        super("userParameter.");
    }

    @Override
    boolean set(View view, String qualifier, String parameter) {
        if (qualifier.length() == 0 || qualifier.equalsIgnoreCase("view.") || qualifier.equalsIgnoreCase("document.")) {
            return CommandHandler.incomplete(view, "set " + this.name() + qualifier);
        }
        return this.setValue(view, qualifier, parameter.length() != 0 ? parameter : null);
    }

    private boolean setValue(View view, String qualifier, String value) {
        if (qualifier.startsWith("view.")) {
            if (view != null) {
                qualifier = qualifier.substring("view.".length());
                HashMap<String, String> viewUserParameters = view.userParameters();
                if (value == null) {
                    viewUserParameters.remove(qualifier);
                } else {
                    viewUserParameters.put(qualifier, value);
                }
            }
        } else if (qualifier.startsWith("document.")) {
            if (view != null) {
                qualifier = qualifier.substring("document.".length());
                HashMap<String, String> documentUserParameters = view.document().userParameters();
                if (value == null) {
                    documentUserParameters.remove(qualifier);
                } else {
                    documentUserParameters.put(qualifier, value);
                }
            }
        } else {
            Profile.putString("userParameter." + qualifier, value);
        }
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        String userParameter;
        if (qualifier.startsWith("view.")) {
            String userParameter2 = this.getViewScopeValue(view, qualifier = qualifier.substring("view.".length()));
            if (userParameter2 == null) {
                userParameter2 = this.getDocumentScopeValue(view, qualifier);
            }
            if (userParameter2 != null) {
                return userParameter2;
            }
        } else if (qualifier.startsWith("document.") && (userParameter = this.getDocumentScopeValue(view, qualifier = qualifier.substring("document.".length()))) != null) {
            return userParameter;
        }
        return Profile.getString("userParameter." + qualifier);
    }

    private String getViewScopeValue(View view, String qualifier) {
        return view != null ? view.userParameters().get(qualifier) : null;
    }

    private String getDocumentScopeValue(View view, String qualifier) {
        return view != null ? view.document().userParameters().get(qualifier) : null;
    }
}

