/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.View;
import java.util.Locale;

final class SystemPropertyParameter
extends Parameter {
    private static SystemPropertyParameter _parameter;

    static SystemPropertyParameter getParameter() {
        if (_parameter == null) {
            _parameter = new SystemPropertyParameter();
        }
        return _parameter;
    }

    private SystemPropertyParameter() {
        super("systemProperty.");
    }

    @Override
    boolean set(View view, String qualifier, String parameter) {
        if (qualifier.length() == 0) {
            return CommandHandler.incomplete(view, "set " + this.name() + qualifier);
        }
        return this.setValue(view, qualifier, parameter.length() != 0 ? parameter : null);
    }

    boolean setValue(View view, String qualifier, String value) {
        if (LpexStringTokenizer.isValidQuotedString(value)) {
            value = LpexStringTokenizer.removeQuotes(value);
        }
        if ("_locale".equalsIgnoreCase(qualifier)) {
            return this.setValueLocale(view, qualifier, value);
        }
        if ("_memory".equalsIgnoreCase(qualifier) && "gc".equalsIgnoreCase(value)) {
            System.gc();
            if (view != null) {
                view.screen().setMessageText("gc: " + this.jvmMemory());
            }
            return true;
        }
        if ("_laf".equalsIgnoreCase(qualifier) && LpexUtilities.getPlatform() == 0) {
            return this.setValueLookAndFeel(view, qualifier, value);
        }
        try {
            if (value == null) {
                System.clearProperty(qualifier);
            } else {
                System.setProperty(qualifier, value);
            }
            return true;
        }
        catch (NullPointerException x) {
            CommandHandler.noParameters(view, "set " + this.name(qualifier));
        }
        catch (Exception x) {
            CommandHandler.invalidParameter(view, value, "set " + this.name(qualifier));
        }
        return false;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        String property = null;
        try {
            property = System.getProperty(qualifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (property == null) {
            if (qualifier.equalsIgnoreCase("_locale")) {
                property = Locale.getDefault().toString();
            } else if (qualifier.equalsIgnoreCase("_bidi")) {
                property = LpexNls.isBidi() ? "true" : "false";
            } else if (qualifier.startsWith("_env.")) {
                property = System.getenv(qualifier.substring("_env.".length()));
            } else if (qualifier.equalsIgnoreCase("_laf")) {
                property = LpexUtilities.getLookAndFeel();
            } else if (qualifier.equalsIgnoreCase("_lafs")) {
                property = LpexUtilities.getLookAndFeels();
            } else if (qualifier.equalsIgnoreCase("_memory")) {
                property = this.jvmMemory();
            }
        }
        return property;
    }

    private boolean setValueLocale(View view, String qualifier, String value) {
        LpexStringTokenizer st;
        Locale locale = null;
        if (value != null) {
            value = value.replace('_', ' ');
        }
        if ((st = new LpexStringTokenizer(value)).hasMoreTokens()) {
            String language = st.nextToken();
            if (!st.hasMoreTokens()) {
                locale = new Locale(language);
            } else {
                String country = st.nextToken();
                locale = !st.hasMoreTokens() ? new Locale(language, country) : new Locale(language, country, st.nextToken());
            }
        }
        return LpexNls.setDefaultLocale(locale) ? true : CommandHandler.invalidParameter(view, value, "set " + this.name(qualifier));
    }

    private boolean setValueLookAndFeel(View view, String qualifier, String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return LpexUtilities.setLookAndFeel(value) ? true : CommandHandler.invalidParameter(view, value, "set " + this.name(qualifier));
    }

    private String jvmMemory() {
        Runtime rt = Runtime.getRuntime();
        long freeMemory = rt.freeMemory();
        long totalMemory = rt.totalMemory();
        return "total(" + totalMemory + ") - free(" + freeMemory + ") = " + Long.valueOf((totalMemory - freeMemory) / 1000L).intValue() + " KB in use";
    }
}

