/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.List;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.StyleAttributesNode;

final class StyleAttributesList
extends List {
    private char _lastFoundStyleCharacter;
    private StyleAttributesNode _lastFound;

    StyleAttributesList() {
    }

    StyleAttributes find(char styleCharacter) {
        StyleAttributesNode node = this.findNode(styleCharacter);
        return node != null ? node.styleAttributes() : null;
    }

    StyleAttributes find(char fgStyleCharacter, char bgStyleCharacter) {
        StyleAttributesNode bgNode;
        StyleAttributesNode fgNode = this.findNode(fgStyleCharacter != '\u0000' ? fgStyleCharacter : (char)'!');
        if (fgNode == null) {
            return null;
        }
        StyleAttributesNode styleAttributesNode = bgNode = bgStyleCharacter != '\u0000' ? this.findNode(bgStyleCharacter) : null;
        if (bgNode == null) {
            return fgNode.styleAttributes();
        }
        return StyleAttributes.getStyleAttributes(fgNode.styleAttributes(), bgNode.styleAttributes());
    }

    boolean backgroundOnly(char styleCharacter) {
        StyleAttributesNode node = this.findNode(styleCharacter);
        return node != null ? node.backgroundOnly() : false;
    }

    void set(char styleCharacter, StyleAttributes styleAttributes) {
        this.set(styleCharacter, styleAttributes, false);
    }

    void set(char styleCharacter, StyleAttributes styleAttributes, boolean backgroundOnly) {
        StyleAttributesNode node = this.findNode(styleCharacter);
        if (node == null) {
            if (styleAttributes != null) {
                node = new StyleAttributesNode(styleCharacter, styleAttributes, backgroundOnly);
            }
            this.addBefore(null, node);
        } else if (styleAttributes != null) {
            node.setStyleAttributes(styleAttributes, backgroundOnly);
        } else {
            this.remove(node);
        }
    }

    @Override
    List.Node remove(List.Node node) {
        if (node == this._lastFound) {
            this._lastFound = null;
        }
        super.remove(node);
        return node;
    }

    private StyleAttributesNode findNode(char styleCharacter) {
        if (this._lastFound != null && this._lastFoundStyleCharacter == styleCharacter) {
            return this._lastFound;
        }
        List.Node current = this.first();
        while (current != null) {
            if (((StyleAttributesNode)current).styleCharacter() == styleCharacter) {
                this._lastFoundStyleCharacter = styleCharacter;
                this._lastFound = (StyleAttributesNode)current;
                return this._lastFound;
            }
            current = current.next();
        }
        return null;
    }
}

