/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.ProcessPrefixCommand;
import com.ibm.lpex.core.StatusLineListener;
import com.ibm.lpex.core.StyleAttributes;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

final class StatusLine
extends Composite {
    private Field[] _fields;
    private static final int LINE_FIELD_INDEX = 0;
    private static final int COLUMN_FIELD_INDEX = 1;
    private static final int INPUT_MODE_FIELD_INDEX = 2;
    private static final int CHANGES_FIELD_INDEX = 3;
    private static final int BROWSE_FIELD_INDEX = 4;
    private static final int INFO_FIELD_INDEX = 5;
    private static final int PAD_FIELD_INDEX = 6;
    private static final int NUMBER_OF_FIELDS = 7;
    private LpexWindow _lpexWindow;
    private Font _font;
    private Font _boldFont;
    private Font _italicFont;
    private Font _boldItalicFont;
    private MouseListener _mouseListener;
    private int _textHeight;
    private int _spaceWidth;
    private StyleAttributes _styleAttributes;
    private static boolean _isPlatformDoubleBuffering = "carbon".equals(SWT.getPlatform()) || "gtk".equals(SWT.getPlatform());

    StatusLine(LpexWindow lpexWindow) {
        super((Composite)lpexWindow, 786432);
        this._lpexWindow = lpexWindow;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                StatusLine.this.paintComponent(e.gc, e.x, e.width);
            }
        });
        this._fields = new Field[7];
        this._fields[0] = new LineField();
        this._fields[1] = new ColumnField();
        this._fields[2] = new InputModeField();
        this._fields[3] = new ChangesField();
        this._fields[4] = new BrowseField();
        this._fields[5] = new InfoField();
        this._fields[6] = new PadField();
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                StatusLine.this.handleDispose();
            }
        });
        this.initAccessible();
        lpexWindow.statusLineManager().addListener(new StatusLineListener(){

            @Override
            public void line(int line) {
                StatusLine.this.lineField().setLine(line);
            }

            @Override
            public void column(int column) {
                StatusLine.this.columnField().setColumn(column);
            }

            @Override
            public void inputMode(String inputMode) {
                StatusLine.this.inputModeField().setInputMode(inputMode);
            }

            @Override
            public void changes(int changes) {
                StatusLine.this.changesField().setChanges(changes);
            }

            @Override
            public void browseMode(String browseMode) {
                StatusLine.this.browseField().setBrowseMode(browseMode);
            }

            @Override
            public void info(String info) {
                StatusLine.this.infoField().setInfo(info);
            }
        });
        this._mouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                StatusLine.this.handleMouseDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                StatusLine.this.handleMouseDown();
            }

            public void mouseUp(MouseEvent e) {
            }
        };
        this.addMouseListener(this._mouseListener);
    }

    void handleDispose() {
        if (this._mouseListener != null) {
            this.removeMouseListener(this._mouseListener);
            this._mouseListener = null;
        }
        this.disposeFonts();
    }

    private void disposeFonts() {
        if (this._boldFont != null) {
            this._boldFont.dispose();
        }
        if (this._italicFont != null) {
            this._italicFont.dispose();
        }
        if (this._boldItalicFont != null) {
            this._boldItalicFont.dispose();
        }
        this._boldItalicFont = null;
        this._italicFont = null;
        this._boldFont = null;
    }

    private void handleMouseDoubleClick(MouseEvent e) {
        if (this._lpexWindow != null && !this._lpexWindow.isDisposed()) {
            this._lpexWindow.setFocus();
        }
        if (e.button == 1) {
            LpexView lpexView;
            LpexView lpexView2 = lpexView = this._lpexWindow == null || this._lpexWindow.isDisposed() ? null : this._lpexWindow.getLpexView();
            if (lpexView != null && !lpexView.isDisposed()) {
                int x = e.x;
                if (x > this.inputModeField().start() && x < this.inputModeField().end()) {
                    lpexView.doAction(197);
                    lpexView.doCommand("screenShow view");
                } else if (x > this.lineField().start() && x < this.lineField().end()) {
                    lpexView.doAction(137);
                } else if (x > this.infoField().start() && x < this.infoField().end()) {
                    ProcessPrefixCommand.locatePendingCommand(lpexView);
                }
            }
        }
    }

    private void handleMouseDown() {
        if (this._lpexWindow != null && this._lpexWindow.isDisposed()) {
            this._lpexWindow.setFocus();
        }
    }

    private Font currentFont() {
        if (this._styleAttributes != null) {
            if (this._styleAttributes.boldItalic()) {
                if (this._boldItalicFont == null) {
                    this._boldItalicFont = this.deriveFont(3);
                }
                return this._boldItalicFont;
            }
            if (this._styleAttributes.bold()) {
                if (this._boldFont == null) {
                    this._boldFont = this.deriveFont(1);
                }
                return this._boldFont;
            }
            if (this._styleAttributes.italic()) {
                if (this._italicFont == null) {
                    this._italicFont = this.deriveFont(2);
                }
                return this._italicFont;
            }
        }
        return this._font;
    }

    private Font deriveFont(int style) {
        FontData[] fontDatas = this._font.getFont().getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setStyle(style);
            ++i;
        }
        return new Font((Device)this.getDisplay(), fontDatas);
    }

    private void paintComponent(GC g, int x, int width) {
        int i = 0;
        while (i < 7) {
            this._fields[i].invalidate(x, width);
            this._fields[i].paint(g);
            ++i;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this._spaceWidth * 40, this._textHeight);
    }

    private void invalidateStatus() {
        int i = 0;
        while (i < 7) {
            this._fields[i].invalidate();
            ++i;
        }
    }

    private LineField lineField() {
        return (LineField)this._fields[0];
    }

    private ColumnField columnField() {
        return (ColumnField)this._fields[1];
    }

    private InputModeField inputModeField() {
        return (InputModeField)this._fields[2];
    }

    private ChangesField changesField() {
        return (ChangesField)this._fields[3];
    }

    private BrowseField browseField() {
        return (BrowseField)this._fields[4];
    }

    private InfoField infoField() {
        return (InfoField)this._fields[5];
    }

    boolean setFont(Font font, StyleAttributes styleAttributes) {
        boolean fontChanged = false;
        int oldTextHeight = this._textHeight;
        if (this._styleAttributes == null || !this._styleAttributes.equals(styleAttributes)) {
            this.setBackground(styleAttributes.backgroundColor().getColor());
            this.setForeground(styleAttributes.foregroundColor().getColor());
            if (this._styleAttributes == null || this._styleAttributes.bold() != styleAttributes.bold() || this._styleAttributes.italic() != styleAttributes.italic()) {
                fontChanged = true;
            }
            this._styleAttributes = styleAttributes;
            this.invalidateStatus();
        }
        if (this._font == null || !this._font.equals(font)) {
            fontChanged = true;
            this._font = font;
            this.disposeFonts();
        }
        if (fontChanged && this._font != null) {
            this.setFont(this.currentFont().getFont());
            GC g = new GC((Drawable)this);
            g.setFont(this.currentFont().getFont());
            FontMetrics fontMetrics = g.getFontMetrics();
            this._textHeight = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading();
            this._spaceWidth = this.getStringWidth(g, " ");
            this.widthsChanged(g);
            g.dispose();
        }
        return fontChanged && oldTextHeight != this._textHeight && this.isVisible();
    }

    int getStringWidth(GC g, String s) {
        return s != null ? g.stringExtent((String)s).x : 0;
    }

    void localeChanged() {
        if (this._font != null) {
            GC g = new GC((Drawable)this);
            g.setFont(this.currentFont().getFont());
            this.widthsChanged(g);
            g.dispose();
        }
    }

    private void widthsChanged(GC g) {
        this.lineField().newWidth(g);
        this.columnField().newWidth(g);
        this.inputModeField().newWidth(g);
        this.changesField().newWidth(g);
        this.browseField().newWidth(g);
        this.infoField().newWidth(g);
        this.invalidateStatus();
    }

    void updateStatus() {
        int height = this.getSize().y;
        if (height != 0) {
            int i = 0;
            while (i < 7) {
                if (!this._fields[i].valid()) {
                    this.redraw(this._fields[i].start(), 0, this._fields[i].width(), height, false);
                }
                ++i;
            }
        }
    }

    private void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.nameStatusLine");
            }

            public void getHelp(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.descStatusLine");
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }

            public void getValue(AccessibleControlEvent e) {
                StringBuilder statusLine = new StringBuilder(128);
                int i = 0;
                while (i < 7) {
                    if (StatusLine.this._fields[i]._text != null) {
                        if (statusLine.length() != 0) {
                            statusLine.append(", ");
                        }
                        statusLine.append(StatusLine.this._fields[i]._text);
                    }
                    ++i;
                }
                e.result = statusLine.toString();
            }
        });
    }

    private final class BrowseField
    extends Field {
        private BrowseField() {
        }

        void newWidth(GC g) {
            this._width = StatusLine.this.getStringWidth(g, LpexResources.message("status.browse")) + 2 * StatusLine.this._spaceWidth;
            this._textOffset = StatusLine.this._spaceWidth;
        }

        void setBrowseMode(String browseMode) {
            this._text = browseMode;
            this._valid = false;
        }

        @Override
        int start() {
            return StatusLine.this.changesField().end();
        }
    }

    private final class ChangesField
    extends Field {
        private ChangesField() {
        }

        void newWidth(GC g) {
            String maxText = LpexResources.message("status.nchanges", 9999);
            this._width = StatusLine.this.getStringWidth(g, maxText) + 2 * StatusLine.this._spaceWidth;
            this._textOffset = StatusLine.this._spaceWidth;
        }

        void setChanges(int changes) {
            this._text = changes == 0 ? null : (changes == 1 ? LpexResources.message("status.1change") : LpexResources.message("status.nchanges", changes));
            this._valid = false;
        }

        @Override
        int start() {
            return StatusLine.this.inputModeField().end();
        }
    }

    private final class ColumnField
    extends Field {
        private ColumnField() {
        }

        void newWidth(GC g) {
            String maxText = LpexResources.message("status.column", 9999);
            this._width = StatusLine.this.getStringWidth(g, maxText) + 2 * StatusLine.this._spaceWidth;
            this._textOffset = StatusLine.this._spaceWidth;
        }

        void setColumn(int column) {
            this._text = column > 0 ? LpexResources.message("status.column", column) : null;
            this._valid = false;
        }

        @Override
        int start() {
            return StatusLine.this.lineField().end();
        }

        @Override
        boolean doDoubleBufferPaint() {
            return true;
        }
    }

    private abstract class Field {
        protected boolean _valid;
        protected String _text;
        protected int _textOffset;
        protected int _width;

        private Field() {
        }

        boolean valid() {
            return this._valid;
        }

        void invalidate() {
            this._valid = false;
        }

        void invalidate(int x, int width) {
            int x1 = this.start();
            int x2 = x1 + this.width();
            if (x1 <= x + width && x2 >= x) {
                this._valid = false;
            }
        }

        abstract int start();

        int end() {
            return this.start() + this.width();
        }

        int width() {
            return this._width;
        }

        boolean doDoubleBufferPaint() {
            return false;
        }

        void paint(GC g) {
            if (!this._valid) {
                if (this.width() > 0 && StatusLine.this._styleAttributes != null) {
                    if (_isPlatformDoubleBuffering || !this.doDoubleBufferPaint()) {
                        this.doPaint(g, this.start());
                    } else {
                        Image buffer = new Image((Device)StatusLine.this.getDisplay(), this.width(), StatusLine.this.getSize().y);
                        GC bufferGC = new GC((Drawable)buffer);
                        bufferGC.setFont(StatusLine.this.currentFont().getFont());
                        bufferGC.setForeground(StatusLine.this._styleAttributes.foregroundColor().getColor());
                        bufferGC.setBackground(StatusLine.this._styleAttributes.backgroundColor().getColor());
                        this.doPaint(bufferGC, 0);
                        g.drawImage(buffer, this.start(), 0);
                        bufferGC.dispose();
                        buffer.dispose();
                    }
                }
                this._valid = true;
            }
        }

        void doPaint(GC g, int start) {
            int height = StatusLine.this.getSize().y;
            g.fillRectangle(start, 0, this.width(), height);
            if (this._text != null) {
                g.drawString(this._text, start + this._textOffset, 0, true);
                if (StatusLine.this._styleAttributes.underline()) {
                    g.drawLine(start + this._textOffset, height - 1, start + this._textOffset + StatusLine.this.getStringWidth(g, this._text), height - 1);
                }
            }
        }
    }

    private final class InfoField
    extends Field {
        private InfoField() {
        }

        void newWidth(GC g) {
            this._width = StatusLine.this.getStringWidth(g, LpexResources.message("status.pending", "@@@")) + 2 * StatusLine.this._spaceWidth;
            this._textOffset = StatusLine.this._spaceWidth;
        }

        void setInfo(String info) {
            this._text = info;
            this._valid = false;
        }

        @Override
        int start() {
            return StatusLine.this.browseField().end();
        }
    }

    private final class InputModeField
    extends Field {
        private InputModeField() {
        }

        void newWidth(GC g) {
            int insertModeLength = StatusLine.this.getStringWidth(g, LpexResources.message("status.insert"));
            int replaceModeLength = StatusLine.this.getStringWidth(g, LpexResources.message("status.replace"));
            int commandModeLength = StatusLine.this.getStringWidth(g, LpexResources.message("status.command"));
            int n = this._width = insertModeLength > replaceModeLength ? insertModeLength : replaceModeLength;
            if (commandModeLength > this._width) {
                this._width = commandModeLength;
            }
            this._width += 2 * StatusLine.this._spaceWidth;
            this._textOffset = StatusLine.this._spaceWidth;
        }

        void setInputMode(String inputMode) {
            this._text = inputMode;
            this._valid = false;
        }

        @Override
        int start() {
            return StatusLine.this.columnField().end();
        }
    }

    private final class LineField
    extends Field {
        private LineField() {
        }

        void newWidth(GC g) {
            String maxText = LpexResources.message("status.line", 999999);
            this._width = StatusLine.this.getStringWidth(g, maxText) + 2 * StatusLine.this._spaceWidth;
            this._textOffset = StatusLine.this._spaceWidth;
        }

        void setLine(int line) {
            this._text = line > 0 ? LpexResources.message("status.line", line) : null;
            this._valid = false;
        }

        @Override
        int start() {
            return 0;
        }

        @Override
        boolean doDoubleBufferPaint() {
            return true;
        }
    }

    private final class PadField
    extends Field {
        private PadField() {
        }

        @Override
        int start() {
            return StatusLine.this.infoField().end();
        }

        @Override
        int width() {
            int width = StatusLine.this.getSize().x - this.start();
            return width > 0 ? width : 0;
        }
    }
}

