/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.View;

final class SourceHexSubstitutesParameter
extends Parameter {
    private static SourceHexSubstitutesParameter _parameter;

    static SourceHexSubstitutesParameter getParameter() {
        if (_parameter == null) {
            _parameter = new SourceHexSubstitutesParameter();
        }
        return _parameter;
    }

    private SourceHexSubstitutesParameter() {
        super("sourceHexSubstitutes");
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        return view.getHexSubstitutes();
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        LpexStringTokenizer parmTokenizier = new LpexStringTokenizer(parameters);
        int count = parmTokenizier.countTokens();
        boolean noError = true;
        if (count % 2 != 0) {
            noError = false;
            CommandHandler.incomplete(view, "set " + this.name() + " " + parameters);
        } else {
            String badParm = null;
            int i = 0;
            while (parmTokenizier.hasMoreTokens() && noError) {
                badParm = parmTokenizier.nextToken();
                try {
                    Integer.parseInt(badParm, 16);
                    if (i++ % 2 == 0) {
                        noError &= badParm.length() == 2;
                        continue;
                    }
                    noError &= badParm.length() == 4;
                }
                catch (NumberFormatException e) {
                    noError = false;
                    break;
                }
            }
            if (!noError) {
                CommandHandler.invalidParameter(view, badParm, "set " + this.name());
            }
        }
        if (noError) {
            if (parameters.length() == 0) {
                parameters = null;
            }
            view.setHexSubStitutes(parameters);
            view.resetAllDisplayText();
        }
        return noError;
    }
}

