/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.ParameterWordDefault;
import com.ibm.lpex.core.View;

final class SourceEncodingParameter
extends ParameterWordDefault {
    private static SourceEncodingParameter _parameter;

    static SourceEncodingParameter getParameter() {
        if (_parameter == null) {
            _parameter = new SourceEncodingParameter();
        }
        return _parameter;
    }

    private SourceEncodingParameter() {
        super("sourceEncoding", null);
    }

    @Override
    boolean setValue(View view, String value) {
        if (view != null) {
            if (value == null || value.equalsIgnoreCase("null")) {
                view.document()._sourceEncodingParm = value;
                value = null;
            } else {
                if ("native".equals(value)) {
                    value = LpexNls.getNativeEncoding();
                } else {
                    if (!LpexNls.isValidEncoding(value)) {
                        return CommandHandler.invalidParameter(view, value, "set " + this.name());
                    }
                    value = LpexNls.canonicalEncoding(value);
                }
                view.document()._sourceEncodingParm = value;
            }
            LpexNls.setSourceEncoding(view.document(), value);
        }
        return true;
    }

    @Override
    boolean setDefaultValue(String value) {
        return super.setDefaultValue("null".equals(value) ? null : value);
    }

    @Override
    void currentValueChanged(View view) {
        LpexNls.setSourceEncoding(view.document(), this.currentValue(view));
    }

    @Override
    String value(View view) {
        return view != null ? this.value(view.document()) : null;
    }

    String value(Document document) {
        String value = document != null ? document._sourceEncodingParm : null;
        return "null".equals(value) ? null : value;
    }

    @Override
    String defaultValue() {
        String defaultValue = super.defaultValue();
        return "null".equals(defaultValue) ? null : defaultValue;
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        String cur = super.queryCurrent(view, qualifier);
        if (cur == null) {
            String string = cur = view != null ? view.nls().getSourceEncoding() : "native";
        }
        if (cur.equalsIgnoreCase("native")) {
            cur = LpexNls.getNativeEncoding();
        }
        return cur;
    }
}

