/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.View;

final class ResequenceCommand {
    ResequenceCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        int start = 0;
        int increment = 100;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                start = Integer.parseInt(token);
                if (start < 1) {
                    return CommandHandler.invalidParameter(view, token, "resequence");
                }
                increment = start;
                if (st.hasMoreTokens() && (increment = Integer.parseInt(token = st.nextToken())) < 1) {
                    return CommandHandler.invalidParameter(view, token, "resequence");
                }
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "resequence");
                }
            }
            catch (NumberFormatException e) {
                return CommandHandler.invalidParameter(view, token, "resequence");
            }
        }
        if (view != null) {
            Document document = view.document();
            if (document.readonly()) {
                view.setLpexMessageText("document.readonly");
            } else if (document.elementList().maxSequenceNumber() == 1) {
                view.setLpexMessageText("sequenceNumbers.noNumbers");
            } else {
                int rc;
                int n = rc = start == 0 ? document.resequence(view) : document.resequence(view, start, increment);
                if (rc == 0) {
                    view.screen().setMessageKey("resequenceCommand.overflow");
                } else {
                    view.screen().clearMessageKey("resequenceCommand.overflow");
                    if (rc == 2) {
                        document.undo().forceDirty(true);
                    }
                }
            }
        }
        return true;
    }
}

