/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

abstract class ParameterWordsDefault
extends ParameterDefault {
    private String _hardCodedValue;
    private String _installValue;
    private boolean _installValueLoaded;
    private String _defaultValue;
    private boolean _defaultValueLoaded;

    ParameterWordsDefault(String name, String hardCodedValue) {
        super(name);
        this._hardCodedValue = hardCodedValue;
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterWordsDefault.this._installValueLoaded = false;
                if (ParameterWordsDefault.this.defaultValue() == null) {
                    Document document = Document._firstDocument;
                    while (document != null) {
                        View view = document._firstView;
                        while (view != null) {
                            if (ParameterWordsDefault.this.value(view) == null) {
                                ParameterWordsDefault.this.currentValueChanged(view);
                            }
                            view = view._next;
                        }
                        document = document._next;
                    }
                }
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterWordsDefault.this._defaultValueLoaded = false;
                Document document = Document._firstDocument;
                while (document != null) {
                    View view = document._firstView;
                    while (view != null) {
                        if (ParameterWordsDefault.this.value(view) == null) {
                            ParameterWordsDefault.this.currentValueChanged(view);
                        }
                        view = view._next;
                    }
                    document = document._next;
                }
            }
        });
    }

    String installValue() {
        if (!this._installValueLoaded) {
            String value = LpexStringTokenizer.removeQuotes(Install.getString("install." + this.name()));
            this._installValue = value == null ? this._hardCodedValue : value;
            this._installValueLoaded = true;
        }
        return this._installValue;
    }

    private void loadDefaultValue() {
        if (!this._defaultValueLoaded) {
            this._defaultValue = LpexStringTokenizer.removeQuotes(Profile.getString("default." + this.name()));
            this._defaultValueLoaded = true;
        }
    }

    String defaultValue() {
        this.loadDefaultValue();
        return this._defaultValue;
    }

    boolean setDefaultValue(String value) {
        this._defaultValue = value;
        this._defaultValueLoaded = true;
        if (this._defaultValue != null) {
            Profile.putString("default." + this.name(), LpexStringTokenizer.addQuotes(this._defaultValue));
        } else {
            Profile.remove("default." + this.name());
        }
        Document document = Document._firstDocument;
        while (document != null) {
            View view = document._firstView;
            while (view != null) {
                if (this.value(view) == null) {
                    this.currentValueChanged(view);
                }
                view = view._next;
            }
            document = document._next;
        }
        return true;
    }

    String currentValue(View view) {
        String value = this.value(view);
        if (value == null && (value = this.defaultValue()) == null) {
            value = this.installValue();
        }
        return value;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return this.setValue(view, "");
        }
        String token = st.nextToken();
        if (!st.hasMoreTokens() && token.equalsIgnoreCase("default")) {
            return this.setValue(view, null);
        }
        StringBuilder value = new StringBuilder(512);
        value.append(token);
        while (st.hasMoreTokens()) {
            value.append(' ').append(st.nextToken());
        }
        return this.setValue(view, value.toString());
    }

    abstract boolean setValue(View var1, String var2);

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return this.setDefaultValue("");
        }
        String token = st.nextToken();
        if (!st.hasMoreTokens() && token.equalsIgnoreCase("install")) {
            return this.setDefaultValue(null);
        }
        StringBuilder value = new StringBuilder(512);
        value.append(token);
        while (st.hasMoreTokens()) {
            value.append(' ').append(st.nextToken());
        }
        return this.setDefaultValue(value.toString());
    }

    void currentValueChanged(View view) {
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view != null) {
            String value = this.value(view);
            return value == null ? "default" : value;
        }
        return null;
    }

    abstract String value(View var1);

    @Override
    String queryInstall(String qualifier) {
        return this.installValue();
    }

    @Override
    String queryDefault(String qualifier) {
        String value = this.defaultValue();
        return value == null ? "install" : value;
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return this.currentValue(view);
    }
}

