/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.LpexWindow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

final class LpexWindowLayout
extends Layout {
    LpexWindowLayout() {
    }

    protected Point computeSize(Composite parent, int wHint, int hHint, boolean flushCache) {
        LpexWindow lpexWindow = (LpexWindow)parent;
        Composite titleLine = lpexWindow.titleLine();
        Composite statusLine = lpexWindow.statusLine();
        Composite separator0 = lpexWindow.separator0();
        Composite formatLine = lpexWindow.formatLine();
        Composite separator1 = lpexWindow.separator1();
        Composite textWindow = lpexWindow.textWindow();
        Composite messageLine = lpexWindow.messageLine();
        Composite commandLine = lpexWindow.commandLine();
        Composite compareLine = lpexWindow.compareLine();
        Point textWindowPreferredSize = textWindow.computeSize(-1, -1, flushCache);
        int width = 0;
        int height = 0;
        if (titleLine.getVisible()) {
            height += titleLine.computeSize((int)-1, (int)-1, (boolean)flushCache).y;
        }
        if (statusLine.getVisible()) {
            Point statusLinePreferredSize = statusLine.computeSize(-1, -1, flushCache);
            width = statusLinePreferredSize.x;
            Point separator0PreferredSize = separator0.computeSize(-1, -1, flushCache);
            height += statusLinePreferredSize.y + separator0PreferredSize.y;
        }
        if (formatLine.getVisible()) {
            Point formatLinePreferredSize = formatLine.computeSize(-1, -1, flushCache);
            if (formatLinePreferredSize.x > width) {
                width = formatLinePreferredSize.x;
            }
            height += formatLinePreferredSize.y + separator1.computeSize((int)-1, (int)-1, (boolean)flushCache).y;
        }
        if (textWindowPreferredSize.x > width) {
            width = textWindowPreferredSize.x;
        }
        height += textWindowPreferredSize.y;
        if (messageLine.getVisible()) {
            Point messageLinePreferredSize = messageLine.computeSize(-1, -1, flushCache);
            if (messageLinePreferredSize.x > width) {
                width = messageLinePreferredSize.x;
            }
            height += messageLinePreferredSize.y;
        }
        if (commandLine.getVisible()) {
            Point commandLinePreferredSize = commandLine.computeSize(-1, -1, flushCache);
            if (commandLinePreferredSize.x > width) {
                width = commandLinePreferredSize.x;
            }
            height += commandLinePreferredSize.y;
        }
        if (compareLine != null && compareLine.getVisible()) {
            width += compareLine.computeSize((int)-1, (int)-1, (boolean)flushCache).x;
        }
        return new Point(width, height);
    }

    protected void layout(Composite parent, boolean flushCache) {
        int textWindowHeight;
        int commandLineHeight;
        int separator2Height;
        Rectangle parentRect = parent.getClientArea();
        int width = parentRect.width;
        int height = parentRect.height;
        LpexWindow lpexWindow = (LpexWindow)parent;
        Composite titleLine = lpexWindow.titleLine();
        Composite statusLine = lpexWindow.statusLine();
        Composite separator0 = lpexWindow.separator0();
        Composite formatLine = lpexWindow.formatLine();
        Composite separator1 = lpexWindow.separator1();
        Composite textWindow = lpexWindow.textWindow();
        ScrollBar hScrollBar = lpexWindow.horizontalScrollBar();
        Composite separator2 = lpexWindow.separator2();
        Composite messageLine = lpexWindow.messageLine();
        Composite commandLine = lpexWindow.commandLine();
        Composite compareLine = lpexWindow.compareLine();
        int titleLineHeight = titleLine.getVisible() ? titleLine.computeSize((int)-1, (int)-1).y : 0;
        int statusLineHeight = statusLine.getVisible() ? statusLine.computeSize((int)-1, (int)-1).y : 0;
        int separator0Height = statusLineHeight > 0 ? 1 : 0;
        int formatLineHeight = formatLine.getVisible() ? formatLine.computeSize((int)-1, (int)-1).y : 0;
        int separator1Height = formatLineHeight > 0 ? 1 : 0;
        int n = separator2Height = hScrollBar.getVisible() ? 0 : 1;
        if (lpexWindow.isCommandLineOnTop()) {
            separator2Height = 1;
        }
        int messageLineHeight = messageLine.getVisible() ? messageLine.computeSize((int)-1, (int)-1).y : 0;
        int n2 = commandLineHeight = commandLine.getVisible() ? commandLine.computeSize((int)-1, (int)-1).y : 0;
        if (separator2Height != 0 && messageLineHeight == 0 && commandLineHeight == 0) {
            separator2Height = 0;
        }
        int compareLineWidth = 0;
        if (compareLine != null && compareLine.getVisible()) {
            compareLineWidth = compareLine.computeSize((int)-1, (int)-1).x;
            if (compareLineWidth > width) {
                compareLineWidth = 0;
            }
            width -= compareLineWidth;
        }
        if ((textWindowHeight = parentRect.height - titleLineHeight - statusLineHeight - separator0Height - formatLineHeight - separator1Height - separator2Height - messageLineHeight - commandLineHeight) < 0) {
            textWindowHeight = 0;
        }
        if (compareLine != null) {
            compareLine.setBounds(0, 0, compareLineWidth, height);
        }
        int yTop = 0;
        titleLine.setBounds(compareLineWidth, yTop, width, titleLineHeight);
        statusLine.setBounds(compareLineWidth, yTop += titleLineHeight, width, statusLineHeight);
        separator0.setBounds(compareLineWidth, yTop += statusLineHeight, width, separator0Height);
        yTop += separator0Height;
        if (lpexWindow.isCommandLineOnTop()) {
            commandLine.setBounds(compareLineWidth, yTop, width, commandLineHeight);
            messageLine.setBounds(compareLineWidth, yTop += commandLineHeight, width, messageLineHeight);
            separator2.setBounds(compareLineWidth, yTop += messageLineHeight, width, separator2Height);
            yTop += separator2Height;
        }
        formatLine.setBounds(compareLineWidth, yTop, width, formatLineHeight);
        separator1.setBounds(compareLineWidth, yTop += formatLineHeight, width, separator1Height);
        yTop += separator1Height;
        int yBottom = height;
        if (!lpexWindow.isCommandLineOnTop()) {
            commandLine.setBounds(compareLineWidth, yBottom -= commandLineHeight, width, commandLineHeight);
            messageLine.setBounds(compareLineWidth, yBottom -= messageLineHeight, width, messageLineHeight);
            separator2.setBounds(compareLineWidth, yBottom -= separator2Height, width, separator2Height);
        }
        textWindow.setBounds(compareLineWidth, yTop, width, textWindowHeight);
    }
}

