/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.bidi.BidiFlag;
import com.ibm.lpex.bidi.BidiFlagSet;
import com.ibm.lpex.bidi.BidiText;
import com.ibm.lpex.bidi.BidiTransform;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.MaintainBidiMarksParameter;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.ShiftInCharacterParameter;
import com.ibm.lpex.core.ShiftOutCharacterParameter;
import com.ibm.lpex.core.ShowHostCharParameter;
import com.ibm.lpex.core.ShowSosiParameter;
import com.ibm.lpex.core.ShowWhitespaceCharParameter;
import com.ibm.lpex.core.SortCommand;
import com.ibm.lpex.core.SourceCcsidParameter;
import com.ibm.lpex.core.SourceEncodingParameter;
import com.ibm.lpex.core.StatusLine;
import com.ibm.lpex.core.UseSourceColumnsParameter;
import com.ibm.lpex.core.View;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Locale;

public final class LpexNls {
    char SO;
    char SI;
    private static final byte EBCDIC_SO = 14;
    private static final byte EBCDIC_SI = 15;
    public static final char LRM = '\u200e';
    public static final char RLM = '\u200f';
    public static final char SOSI_SPLITTER = '\u200c';
    private static final char LAM = '\u0644';
    private static final String[] mbcsEncodings = new String[]{"Cp942", "Cp942C", "x-IBM942C", "Cp943", "Cp943C", "MS932", "SJIS", "Shift_JIS", "Cp949", "Cp949C", "MS949", "x-windows-949", "Cp1363", "x-IBM1363", "Cp1363C", "x-IBM1363C", "Johab", "x-Johab", "Cp1381", "GBK", "MS936", "Big5", "Big5_HKSCS", "Cp948", "MS950", "MS950_HKSCS", "Cp1370", "ISO2022JP", "JIS0201", "JIS_X0201", "JIS0208", "x-JIS0208", "JIS0212", "JIS_X0212-1990", "ISO2022KR"};
    private static final String[] sosiEncodings = new String[]{"Cp930", "Cp939", "Cp1390", "x-IBM1390", "Cp1399", "x-IBM1399", "Cp933", "x-IBM933", "Cp1364", "x-IBM1364", "Cp935", "Cp1388", "x-IBM1388", "Cp937", "Cp1371", "x-IBM1371"};
    private static final String[] eucEncodings = new String[]{"EUC_JP", "Cp33722", "Cp33722C", "Cp954", "x-IBM954", "Cp954C", "x-IBM954C", "Cp970", "GB18030", "Cp1383", "Cp964", "EUC_TW", "x-EUC_TW"};
    private static final String[] arabicEncodings = new String[]{"Cp420", "Cp420S", "x-IBM420S", "Cp864", "Cp864S", "x-IBM864S", "Cp1046", "Cp1046S", "Cp1256", "Cp1256S", "ISO8859_6", "ISO8859_6S", "MacArabic", "Cp868", "Cp918", "Cp1006", "Cp1097", "Cp1098"};
    private static final String[] hebrewEncodings = new String[]{"Cp424", "Cp856", "Cp862", "Cp867", "Cp1255", "ISO8859_8", "MacHebrew"};
    private static final String[][] alternateEncodings = new String[][]{{"x-IBM1388", "Cp1388"}};
    public static String VISUAL = "visual";
    public static String LOGICAL = "logical";
    public static char FIXED_END = (char)122;
    private View _view;
    private static String _moreMbcsEncodings;
    private static String _moreSosiEncodings;
    private static String _moreArabicEncodings;
    private static String _moreHebrewEncodings;
    private static final Locale _initialLocale;
    private static String _nativeEncoding;
    private static final int TOKEN_INDEX_NOT_SET = -1;
    private static final byte[] BOM_UTF16BE;
    private static final byte[] BOM_UTF16LE;
    private static final byte[] BOM_UTF8;
    private static final String[] _bomEncodings;
    private static BidiFlagSet bidiFlagsVisual;
    private static BidiFlagSet bidiFlagsLogical;

    static {
        _initialLocale = Locale.getDefault();
        LpexNls.setNativeEncoding(null);
        BOM_UTF16BE = new byte[]{-2, -1};
        BOM_UTF16LE = new byte[]{-1, -2};
        BOM_UTF8 = new byte[]{-17, -69, -65};
        _bomEncodings = new String[]{"UTF32", "UTF32BE", "UTF32LE", "UTF8", "UnicodeBigUnmarked", "UnicodeLittleUnmarked"};
        bidiFlagsVisual = new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_NO, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
        bidiFlagsLogical = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_ANY, BidiFlag.TEXT_NOMINAL);
    }

    LpexNls(LpexView lpexView) {
        this._view = lpexView._view;
        if (this._view.document()._sourceEncoding == null) {
            LpexNls.setSourceEncoding(this._view.document(), null);
        }
        this.setSO(0);
        this.setSI(0);
    }

    boolean setSO(int newSO) {
        if (newSO != 0 && (newSO == 9 || this.getSourceWidth((char)newSO) != 1)) {
            return false;
        }
        this.SO = (char)newSO;
        return true;
    }

    boolean setSI(int newSI) {
        if (newSI != 0 && (newSI == 9 || this.getSourceWidth((char)newSI) != 1)) {
            return false;
        }
        this.SI = (char)newSI;
        return true;
    }

    public static boolean isValidEncoding(String encoding) {
        if (encoding == null) {
            return false;
        }
        try {
            "".getBytes(encoding);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isMbcsEncoding(String encoding) {
        if (encoding == null) {
            return false;
        }
        int i = 0;
        while (i < mbcsEncodings.length) {
            if (encoding.equals(mbcsEncodings[i])) {
                return true;
            }
            ++i;
        }
        if (LpexNls.isitEucEncoding(encoding)) {
            return true;
        }
        if (LpexNls.isSosiEncoding(encoding)) {
            return true;
        }
        if (_moreMbcsEncodings == null && (_moreMbcsEncodings = Profile.getString("mbcsEncodings")) == null) {
            _moreMbcsEncodings = "";
        }
        LpexStringTokenizer st = new LpexStringTokenizer(_moreMbcsEncodings);
        while (st.hasMoreTokens()) {
            if (!encoding.equals(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    private static boolean isitEucEncoding(String encoding) {
        if (encoding == null) {
            return false;
        }
        int i = 0;
        while (i < eucEncodings.length) {
            if (encoding.equals(eucEncodings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSosiEncoding(String encoding) {
        if (encoding == null) {
            return false;
        }
        int i = 0;
        while (i < sosiEncodings.length) {
            if (encoding.equals(sosiEncodings[i])) {
                return true;
            }
            ++i;
        }
        if (_moreSosiEncodings == null && (_moreSosiEncodings = Profile.getString("sosiEncodings")) == null) {
            _moreSosiEncodings = "";
        }
        LpexStringTokenizer st = new LpexStringTokenizer(_moreSosiEncodings);
        while (st.hasMoreTokens()) {
            if (!encoding.equals(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    private static boolean isArabicEncoding(String encoding) {
        if (encoding == null) {
            return false;
        }
        int i = 0;
        while (i < arabicEncodings.length) {
            if (encoding.equals(arabicEncodings[i])) {
                return true;
            }
            ++i;
        }
        if (_moreArabicEncodings == null && (_moreArabicEncodings = Profile.getString("arabicEncodings")) == null) {
            _moreArabicEncodings = "";
        }
        if (_moreArabicEncodings.length() != 0) {
            LpexStringTokenizer st = new LpexStringTokenizer(_moreArabicEncodings);
            while (st.hasMoreTokens()) {
                if (!encoding.equals(st.nextToken())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isHebrewEncoding(String encoding) {
        if (encoding == null) {
            return false;
        }
        int i = 0;
        while (i < hebrewEncodings.length) {
            if (encoding.equals(hebrewEncodings[i])) {
                return true;
            }
            ++i;
        }
        if (_moreHebrewEncodings == null && (_moreHebrewEncodings = Profile.getString("hebrewEncodings")) == null) {
            _moreHebrewEncodings = "";
        }
        if (_moreHebrewEncodings.length() != 0) {
            LpexStringTokenizer st = new LpexStringTokenizer(_moreHebrewEncodings);
            while (st.hasMoreTokens()) {
                if (!encoding.equals(st.nextToken())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBidiEncoding(String encoding) {
        return LpexNls.isHebrewEncoding(encoding) || LpexNls.isArabicEncoding(encoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setNativeEncoding(String encoding) {
        if (encoding == null) {
            block21: {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        try {
                            try (OutputStreamWriter osw = new OutputStreamWriter(os);){
                                encoding = osw.getEncoding();
                            }
                            if (os == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (os == null) throw throwable;
                            os.close();
                            throw throwable;
                        }
                        os.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (encoding == null) {
                encoding = System.getProperty("file.encoding");
            }
        } else if (!LpexNls.isValidEncoding(encoding)) {
            return false;
        }
        _nativeEncoding = LpexNls.canonicalEncoding(encoding);
        Document document = Document._firstDocument;
        while (document != null) {
            document.sourceEncodingChanged();
            document = document._next;
        }
        return true;
    }

    public static String getNativeEncoding() {
        return _nativeEncoding;
    }

    public String getFileEncoding() {
        String encoding = this._view.document().fileEncoding();
        return encoding != null ? encoding : LpexNls.getNativeEncoding();
    }

    static void setSourceEncoding(Document doc, String encoding) {
        String oldDocSourceEncoding = doc._sourceEncoding;
        if (encoding == null) {
            encoding = doc.fileEncoding();
            if (encoding == null) {
                encoding = SourceEncodingParameter.getParameter().defaultValue();
            }
            if (encoding == null) {
                encoding = SourceEncodingParameter.getParameter().installValue();
            }
        }
        if (encoding == null || encoding.equals("native")) {
            doc._sourceEncoding = _nativeEncoding;
            doc._sourceMbcs = LpexNls.isMbcsEncoding(_nativeEncoding);
            doc._sourceSosi = LpexNls.isSosiEncoding(_nativeEncoding);
            doc._sourceArabic = LpexNls.isArabicEncoding(_nativeEncoding);
            doc._sourceHebrew = LpexNls.isHebrewEncoding(_nativeEncoding);
        } else {
            if (!LpexNls.isValidEncoding(encoding)) {
                return;
            }
            doc._sourceEncoding = encoding = LpexNls.canonicalEncoding(encoding);
            doc._sourceMbcs = LpexNls.isMbcsEncoding(encoding);
            doc._sourceSosi = LpexNls.isSosiEncoding(encoding);
            doc._sourceArabic = LpexNls.isArabicEncoding(encoding);
            doc._sourceHebrew = LpexNls.isHebrewEncoding(encoding);
        }
        if (oldDocSourceEncoding != null && doc._sourceSosi) {
            View view = doc._firstView;
            while (view != null) {
                LpexNls nls = view.nls();
                if (nls.getSourceWidth(ShiftOutCharacterParameter.getParameter().currentValue(view)) != 1 || nls.getSourceWidth(ShiftInCharacterParameter.getParameter().currentValue(view)) != 1) {
                    nls.setSO(0);
                    nls.setSI(0);
                }
                view = view._next;
            }
        }
        if (!doc._sourceEncoding.equals(oldDocSourceEncoding)) {
            doc.sourceEncodingChanged();
        }
    }

    static void fileEncodingChanged(Document document) {
        if (SourceEncodingParameter.getParameter().value(document) == null && SourceEncodingParameter.getParameter().defaultValue() == null && SourceEncodingParameter.getParameter().installValue() == null) {
            LpexNls.setSourceEncoding(document, null);
        }
    }

    public String getSourceEncoding() {
        return this._view.document()._sourceEncoding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String canonicalEncoding(String encoding) {
        String canonicalEncoding = encoding;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, encoding);){
                        canonicalEncoding = osw.getEncoding();
                        canonicalEncoding = LpexNls.getAlternateEncoding(canonicalEncoding);
                    }
                    if (os == null) return canonicalEncoding;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (os == null) throw throwable;
                    os.close();
                    throw throwable;
                }
                os.close();
                return canonicalEncoding;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return canonicalEncoding;
    }

    private static String getAlternateEncoding(String canonicalEncoding) {
        int i = 0;
        while (i < alternateEncodings.length) {
            if (alternateEncodings[i][0].equalsIgnoreCase(canonicalEncoding)) {
                String preferredAlternate = alternateEncodings[i][1];
                if (Charset.isSupported(preferredAlternate)) {
                    return preferredAlternate;
                }
                LpexLog.log("Attempt to set alternate encoding from " + canonicalEncoding + " to " + alternateEncodings[i][1] + " failed.");
                break;
            }
            ++i;
        }
        return canonicalEncoding;
    }

    public boolean isSourceMbcs() {
        return this._view.document()._sourceMbcs;
    }

    public boolean isSourceSosi() {
        return this._view.document()._sourceSosi;
    }

    public boolean isSourceBidi() {
        return this._view.document()._sourceHebrew || this._view.document()._sourceArabic;
    }

    public boolean isShapedLigatures() {
        return LpexNls.isShapedLigatures(this._view.document()._sourceEncoding, SourceCcsidParameter.getParameter().currentValue(this._view));
    }

    private static boolean isShapedLigatures(Document doc) {
        return LpexNls.isShapedLigatures(doc._sourceEncoding, SourceCcsidParameter.getParameter().currentValue(doc._firstView));
    }

    private static boolean isShapedLigatures(String encoding, int ccsid) {
        if (!"Cp420".equals(encoding)) {
            return false;
        }
        return ccsid == 420 || ccsid == 16804;
    }

    public boolean isIgnoringBidiMarks() {
        return LpexNls.isIgnoringBidiMarks(this._view.document());
    }

    static boolean isIgnoringBidiMarks(Document doc) {
        return (doc._sourceHebrew || doc._sourceArabic) && doc._sourceCcsidVisualBidi;
    }

    static boolean isVisualBidiCcsid(int ccsid) {
        return ccsid == 420 || ccsid == 16804 || ccsid == 424 || ccsid == 12712 || ccsid == 862 || ccsid == 867 || ccsid == 12708 || ccsid == 62208 || ccsid == 62210 || ccsid == 62215 || ccsid == 62217 || ccsid == 62218 || ccsid == 62229 || ccsid == 62230 || ccsid == 62231 || ccsid == 62232 || ccsid == 62233 || ccsid == 62234 || ccsid == 62237 || ccsid == 62246 || ccsid == 62247 || ccsid == 62248;
    }

    public boolean isSmartLogical() {
        if (this.isSourceBidi()) {
            return this._view.document()._sourceCcsidVisualBidi || MaintainBidiMarksParameter.getParameter().currentValue(this._view) || this.parserMaintainsBidiMarks();
        }
        return false;
    }

    public boolean isSyntaxSmartLogical() {
        if (this.isSourceBidi()) {
            return this.parserMaintainsBidiMarks();
        }
        return false;
    }

    private boolean parserMaintainsBidiMarks() {
        View v = this._view.document()._firstView;
        while (v != null) {
            LpexParser parser = v.parsePendingList().lpexParser();
            if (parser != null) {
                return "on".equals(parser.getProperty("document.maintainBidiMarks"));
            }
            v = v._next;
        }
        return false;
    }

    public static boolean isBidiMark(char c) {
        return c == '\u200e' || c == '\u200f';
    }

    private static boolean isAlef(char c) {
        return c == '\u0622' || c == '\u0623' || c == '\u0625' || c == '\u0627';
    }

    public static boolean isLigature(String s, int offset) {
        if (s == null || offset < 0 || s.length() <= offset + 1) {
            return false;
        }
        return s.charAt(offset) == '\u0644' && LpexNls.isAlef(s.charAt(offset + 1));
    }

    static boolean isLeadingSurrogate(String s, int offset) {
        if (s == null || offset < 0 || s.length() <= offset + 1) {
            return false;
        }
        return Character.isHighSurrogate(s.charAt(offset)) && Character.isLowSurrogate(s.charAt(offset + 1));
    }

    static boolean isTrailingSurrogate(String s, int offset) {
        if (s == null || offset < 1 || offset >= s.length()) {
            return false;
        }
        return Character.isLowSurrogate(s.charAt(offset)) && Character.isHighSurrogate(s.charAt(offset - 1));
    }

    static String specialCharacterInfo(char c) {
        if (c == '\u200e') {
            return "LRM";
        }
        if (c == '\u200f') {
            return "RLM";
        }
        if (c == '\u200c') {
            return "ZWNJ";
        }
        if (c == '\u200d') {
            return "ZWJ";
        }
        return null;
    }

    public boolean usingSourceColumns() {
        return LpexNls.usingSourceColumns(this._view.document());
    }

    static boolean usingSourceColumns(Document doc) {
        boolean bUseSourceColumns = UseSourceColumnsParameter.getParameter().currentValue(doc);
        boolean bMultiByte = doc._sourceMbcs;
        boolean bUTF = doc._sourceEncoding.startsWith("UTF");
        return bUseSourceColumns && (bMultiByte || bUTF || LpexNls.isShapedLigatures(doc) || LpexNls.isIgnoringBidiMarks(doc));
    }

    public boolean displayingSosi() {
        return this._view.document()._sourceSosi && ShowSosiParameter.getParameter().currentValue(this._view);
    }

    public boolean displayingWhitespaceChar() {
        return ShowWhitespaceCharParameter.getParameter().currentValue(this._view);
    }

    public boolean displayingHostChar() {
        return ShowHostCharParameter.getParameter().currentValue(this._view);
    }

    boolean nlsSimulator(String parameters) {
        LpexView lpexView = this._view.lpexView();
        if ("clusters".equalsIgnoreCase(parameters = parameters.trim())) {
            lpexView.doCommand("set messageText CLUSTERS: " + DisplayTextLayout.clusters(lpexView.query("text")));
            return true;
        }
        if ("levels".equalsIgnoreCase(parameters)) {
            Element element = this._view.documentPosition().element();
            ElementView elementView = element == null ? null : element.elementView(this._view);
            lpexView.doCommand("set messageText LEVELS: " + DisplayTextLayout.levels(elementView));
            return true;
        }
        if ("text".equalsIgnoreCase(parameters)) {
            lpexView.doCommand("set messageText TEXT: " + LpexNls.unBidiText(lpexView.query("text")));
            return true;
        }
        if ("fullText".equalsIgnoreCase(parameters)) {
            lpexView.doCommand("set messageText FULLTEXT: " + LpexNls.unBidiText(lpexView.query("fullText")));
            return true;
        }
        if ("format".equalsIgnoreCase(parameters)) {
            if (!this.isSourceBidi()) {
                return lpexView.doCommand("set messageText FORMAT: non-bidi source encoding (" + this.getSourceEncoding() + ")");
            }
            if (!this.isSmartLogical()) {
                return lpexView.doCommand("set messageText FORMAT: L (logical) bidi doc.");
            }
            if (!this.isSyntaxSmartLogical()) {
                return lpexView.doCommand("set messageText FORMAT: SL (smart logical) bidi doc.");
            }
            return lpexView.doCommand("set messageText FORMAT: SSL (syntax-smart logical): SL bidi doc with parser support.");
        }
        if ("maintainBidiMarks".equalsIgnoreCase(parameters)) {
            int i = 0;
            while (i < lpexView.elements()) {
                if (!lpexView.show(i)) {
                    this.setTextStyleBidiMarks(i, this.stripStyleBidiMarks(i));
                }
                ++i;
            }
            return true;
        }
        if ("IME".equalsIgnoreCase(parameters)) {
            LpexUtilities.setImeInputMethod(lpexView);
            return true;
        }
        boolean setDefault = false;
        boolean query = false;
        boolean setJapan = false;
        boolean setHost = false;
        if (parameters.length() == 0) {
            setDefault = true;
        } else {
            LpexStringTokenizer st = new LpexStringTokenizer(parameters);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.equalsIgnoreCase("query")) {
                    query = true;
                    continue;
                }
                if (t.equalsIgnoreCase("default")) {
                    setDefault = true;
                    setJapan = false;
                    continue;
                }
                if (t.equalsIgnoreCase("japan")) {
                    setJapan = true;
                    setDefault = false;
                    continue;
                }
                if (!t.equalsIgnoreCase("host") && !t.equals("390")) continue;
                setHost = true;
            }
        }
        if (setDefault) {
            LpexNls.setDefaultLocale(null);
            lpexView.doDefaultCommand("set shiftOutCharacter 0x0000");
            lpexView.doDefaultCommand("set shiftInCharacter 0x0000");
            LpexNls.setNativeEncoding(null);
            lpexView.doDefaultCommand("set sourceEncoding");
        } else if (setJapan) {
            LpexNls.setDefaultLocale(Locale.JAPAN);
            if (!LpexNls.setNativeEncoding("MS932")) {
                LpexNls.setNativeEncoding("SJIS");
            }
            if (setHost) {
                lpexView.doDefaultCommand("set sourceEncoding Cp939");
                lpexView.doDefaultCommand("set shiftOutCharacter 0x00bb");
                lpexView.doDefaultCommand("set shiftInCharacter 0x00ab");
                lpexView.doDefaultCommand("set useSourceColumns on");
            } else {
                lpexView.doDefaultCommand("set sourceEncoding");
            }
        }
        if (query) {
            System.out.println("\n nlsSim defaultLocale=" + String.valueOf(Locale.getDefault()) + ", nativeEncoding=" + LpexNls.getNativeEncoding() + ", sourceEncoding=" + this.getSourceEncoding());
            if (this._view.document()._sourceSosi) {
                System.out.println("         SO=0x" + Integer.toHexString(ShiftOutCharacterParameter.getParameter().currentValue(this._view)) + ", SI=0x" + Integer.toHexString(ShiftInCharacterParameter.getParameter().currentValue(this._view)));
            }
        }
        Element element = this._view.document().elementList().first();
        while (element != null) {
            element.elementView(this._view).resetDisplayText();
            element = element.next();
        }
        return true;
    }

    static String unBidiText(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuilder text = new StringBuilder(s.length() * 2 + 2);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\u200e') {
                c = '\u00bb';
            } else if (c == '\u200f') {
                c = '\u00ab';
            }
            text.append(c).append('\u200e');
            ++i;
        }
        return text.toString();
    }

    private static int getEncodingLength(String s, String encoding) {
        if (s == null) {
            return 0;
        }
        try {
            return s.getBytes(encoding).length;
        }
        catch (Exception exception) {
            return s.length();
        }
    }

    private static int getEncodingLength(char c, String encoding) {
        try {
            int l = Character.valueOf(c).toString().getBytes(encoding).length;
            return l > 2 && LpexNls.isSosiEncoding(encoding) ? 2 : l;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    int sourceLength(String s) {
        return LpexNls.sourceLength(s, this._view.document());
    }

    static int sourceLength(String s, Document doc) {
        if (s == null) {
            return 0;
        }
        if (LpexNls.isShapedLigatures(doc)) {
            int len = s.length();
            int i = 0;
            while (i < s.length()) {
                char c;
                if ((c = s.charAt(i++)) == '\u0644' && i < s.length()) {
                    if (!LpexNls.isAlef(s.charAt(i))) continue;
                    --len;
                    ++i;
                    continue;
                }
                if (!LpexNls.isBidiMark(c)) continue;
                --len;
            }
            return len;
        }
        if (LpexNls.isIgnoringBidiMarks(doc)) {
            int len = s.length();
            int i = 0;
            while (i < s.length()) {
                if (LpexNls.isBidiMark(s.charAt(i))) {
                    --len;
                }
                ++i;
            }
            return len;
        }
        return LpexNls.getEncodingLength(s, doc._sourceEncoding);
    }

    public int sourceLength(char c) {
        return LpexNls.getEncodingLength(c, this._view.document()._sourceEncoding);
    }

    int getSourceWidth(char c) {
        if (LpexNls.isBidiMark(c)) {
            return 0;
        }
        if (Character.isHighSurrogate(c) || Character.isLowSurrogate(c)) {
            return 1;
        }
        if (this._view.document()._sourceEncoding.startsWith("UTF")) {
            return this.sourceLength(c);
        }
        int len = 1;
        if (this.isSourceMbcs() && (len = this.sourceLength(c)) > 2) {
            return 2;
        }
        return len;
    }

    int emulationCharIndex(String s, int index) {
        byte[] ebcdic;
        if (!this._view.document()._sourceSosi || index < 0 || s == null) {
            return index;
        }
        int k = 0;
        int i = 0;
        int j = 0;
        try {
            ebcdic = s.getBytes(this._view.document()._sourceEncoding);
        }
        catch (Exception e) {
            return index;
        }
        boolean dbcs = false;
        while (i < ebcdic.length) {
            if (ebcdic[i] == 14) {
                dbcs = true;
                ++i;
                ++j;
                if (k != index) continue;
                return j;
            }
            if (ebcdic[i] == 15) {
                dbcs = false;
                ++i;
                ++j;
                if (k != index) continue;
                return j;
            }
            if (k == index) {
                return j;
            }
            if (dbcs) {
                ++i;
            }
            ++k;
            ++i;
            ++j;
        }
        return j + (index - k);
    }

    int emulationIndex(String s, int index) {
        byte[] ebcdic;
        if (!this._view.document()._sourceSosi || index < 0 || s == null) {
            return index;
        }
        int k = 0;
        int i = 0;
        int j = 0;
        try {
            ebcdic = s.getBytes(this._view.document()._sourceEncoding);
        }
        catch (Exception e) {
            return index;
        }
        boolean dbcs = false;
        while (i < ebcdic.length) {
            if (k == index) {
                return j;
            }
            if (ebcdic[i] == 14) {
                dbcs = true;
            } else if (ebcdic[i] == 15) {
                dbcs = false;
            } else {
                if (dbcs) {
                    ++i;
                }
                ++k;
            }
            ++i;
            ++j;
        }
        return j + (index - k);
    }

    int indexFromEmulationIndex(String s, int index) {
        byte[] ebcdic;
        if (!this._view.document()._sourceSosi || index < 0 || s == null) {
            return index;
        }
        int k = 0;
        int i = 0;
        int j = 0;
        try {
            ebcdic = s.getBytes(this._view.document()._sourceEncoding);
        }
        catch (Exception e) {
            return index;
        }
        boolean dbcs = false;
        while (i < ebcdic.length) {
            if (j == index) {
                return k;
            }
            if (ebcdic[i] == 14) {
                dbcs = true;
            } else if (ebcdic[i] == 15) {
                dbcs = false;
            } else {
                if (dbcs) {
                    ++i;
                }
                ++k;
            }
            ++i;
            ++j;
        }
        return k + (index - j);
    }

    public int encodingCharIndex(String s, int index) {
        return LpexNls.encodingCharIndex(s, index, this.getSourceEncoding(), SourceCcsidParameter.getParameter().currentValue(this._view));
    }

    static int encodingCharIndex(String s, int index, String encoding, int ccsid) {
        if (index < 0 || s == null) {
            return index;
        }
        if (LpexNls.isSosiEncoding(encoding)) {
            byte[] ebcdic;
            try {
                ebcdic = s.getBytes(encoding);
            }
            catch (Exception e) {
                return index;
            }
            int i = 0;
            int j = 0;
            boolean dbcs = false;
            while (j < ebcdic.length) {
                if (ebcdic[j] == 14) {
                    dbcs = true;
                    ++j;
                    if (i != index) continue;
                    return j;
                }
                if (ebcdic[j] == 15) {
                    dbcs = false;
                    ++j;
                    if (i != index) continue;
                    return j;
                }
                if (i == index) {
                    return j;
                }
                if (dbcs) {
                    ++j;
                }
                ++i;
                ++j;
            }
            return j + (index - i);
        }
        return LpexNls.encodingIndex(s, index, encoding, ccsid);
    }

    int encodingIndex(String s, int index) {
        return LpexNls.encodingIndex(s, index, this.getSourceEncoding(), SourceCcsidParameter.getParameter().currentValue(this._view));
    }

    static int encodingIndex(String s, int index, String encoding, int ccsid) {
        if (index < 0 || s == null) {
            return index;
        }
        int i = 0;
        int j = 0;
        if (LpexNls.isSosiEncoding(encoding)) {
            byte[] ebcdic;
            try {
                ebcdic = s.getBytes(encoding);
            }
            catch (Exception e) {
                return index;
            }
            boolean dbcs = false;
            while (j < ebcdic.length) {
                if (i == index) {
                    return j;
                }
                if (ebcdic[j] == 14) {
                    dbcs = true;
                } else if (ebcdic[j] == 15) {
                    dbcs = false;
                } else {
                    if (dbcs) {
                        ++j;
                    }
                    ++i;
                }
                ++j;
            }
            return j + (index - i);
        }
        boolean isIgnoringBidiMarks = LpexNls.isVisualBidiCcsid(ccsid) && LpexNls.isBidiEncoding(encoding);
        boolean isShapedLigatures = LpexNls.isShapedLigatures(encoding, ccsid);
        while (i < s.length()) {
            if (i >= index) {
                return j;
            }
            if (Character.isHighSurrogate(s.charAt(i)) && i + 1 < s.length() && Character.isLowSurrogate(s.charAt(i + 1))) {
                if (++i >= index) {
                    return j;
                }
                j += LpexNls.getEncodingLength(s.substring(i, i + 2), encoding);
            } else if (!isIgnoringBidiMarks || !LpexNls.isBidiMark(s.charAt(i))) {
                if (isShapedLigatures && LpexNls.isLigature(s, i)) {
                    if (++i >= index) {
                        return j;
                    }
                    ++j;
                } else {
                    j += LpexNls.getEncodingLength(s.charAt(i), encoding);
                }
            }
            ++i;
        }
        return j + (index - i);
    }

    int indexFromEncodingIndex(String s, int index) {
        return LpexNls.indexFromEncodingIndex(s, index, this.getSourceEncoding(), SourceCcsidParameter.getParameter().currentValue(this._view));
    }

    public static int indexFromEncodingIndex(String s, int index, String encoding, int ccsid) {
        if (index < 0 || s == null) {
            return index;
        }
        int i = 0;
        int j = 0;
        if (LpexNls.isSosiEncoding(encoding)) {
            byte[] ebcdic;
            try {
                ebcdic = s.getBytes(encoding);
            }
            catch (Exception e) {
                return index;
            }
            boolean dbcs = false;
            while (j < ebcdic.length) {
                if (ebcdic[j] == 14) {
                    if (j >= index) {
                        return i;
                    }
                    dbcs = true;
                    ++j;
                    continue;
                }
                if (ebcdic[j] == 15) {
                    if (j >= index) {
                        return i;
                    }
                    dbcs = false;
                    ++j;
                    continue;
                }
                if (dbcs) {
                    ++j;
                }
                if (j >= index) {
                    return i;
                }
                ++i;
                ++j;
            }
            return i + (index - j);
        }
        boolean isIgnoringBidiMarks = LpexNls.isVisualBidiCcsid(ccsid) && LpexNls.isBidiEncoding(encoding);
        boolean isShapedLigatures = LpexNls.isShapedLigatures(encoding, ccsid);
        while (i < s.length()) {
            if (j == index) {
                return i;
            }
            if (Character.isHighSurrogate(s.charAt(i)) && i + 1 < s.length() && Character.isLowSurrogate(s.charAt(i + 1))) {
                if ((j += LpexNls.getEncodingLength(s.substring(i, i + 2), encoding)) > index) {
                    return i;
                }
                ++i;
            } else if (isIgnoringBidiMarks && LpexNls.isBidiMark(s.charAt(i))) {
                if (j > index) {
                    return i;
                }
            } else if (isShapedLigatures && LpexNls.isLigature(s, i)) {
                ++j;
                ++i;
            } else if ((j += LpexNls.getEncodingLength(s.charAt(i), encoding)) > index) {
                return i;
            }
            ++i;
        }
        return i + (index - j);
    }

    int sourceColumnFromDisplayIndex(String displayText, int index) {
        if (index < 0 || displayText == null) {
            return index;
        }
        if (this.isShapedLigatures()) {
            boolean visualDocument = this._view.document().visual();
            int i = 0;
            int col = 0;
            while (i < displayText.length()) {
                char c;
                if (i >= index) {
                    return col;
                }
                if ((c = displayText.charAt(i++)) == '\u0644' && i < displayText.length()) {
                    if (LpexNls.isAlef(displayText.charAt(i))) {
                        if (i >= index) {
                            return col;
                        }
                        ++i;
                    }
                    ++col;
                    continue;
                }
                if (visualDocument && i < displayText.length() && LpexNls.isAlef(c)) {
                    if (displayText.charAt(i) == '\u0644') {
                        if (i >= index) {
                            return col;
                        }
                        ++i;
                    }
                    ++col;
                    continue;
                }
                if (LpexNls.isBidiMark(c)) continue;
                ++col;
            }
            return col + (index - i);
        }
        if (this._view.document()._sourceSosi && !this._view.currentShowSosi()) {
            return LpexNls.encodingCharIndex(displayText, index, this.getSourceEncoding(), 0);
        }
        int i = 0;
        int col = 0;
        while (i < displayText.length()) {
            if (i == index) {
                return col;
            }
            col += this.getSourceWidth(displayText.charAt(i));
            ++i;
        }
        return col + (index - i);
    }

    int columnFromDisplayIndex(String displayText, int index) {
        if (index < 0 || displayText == null) {
            return index;
        }
        int i = 0;
        int col = 0;
        while (i < displayText.length()) {
            if (i == index) {
                return col;
            }
            col += this.getSourceWidth(displayText.charAt(i));
            ++i;
        }
        return col + (index - i);
    }

    int displayIndexFromColumn(String displayText, int column) {
        if (column < 0 || displayText == null) {
            return column;
        }
        int i = 0;
        int col = 0;
        while (i < displayText.length()) {
            if (col >= column) {
                return i;
            }
            if ((col += this.getSourceWidth(displayText.charAt(i))) > column) {
                return i;
            }
            ++i;
        }
        return i + (column - col);
    }

    public int sourceTruncate(String s, int textLimit) {
        return LpexNls.sourceTruncate(s, textLimit, this._view.document());
    }

    static int sourceTruncate(String s, int textLimit, Document doc) {
        if (s == null || s.length() == 0 || textLimit <= 0) {
            return 0;
        }
        if (doc._sourceSosi) {
            byte[] ebcdic;
            try {
                ebcdic = s.getBytes(doc._sourceEncoding);
            }
            catch (Exception e) {
                int len = s.length();
                return len > textLimit ? textLimit : len;
            }
            int len = 0;
            while (len < ebcdic.length && ebcdic[len] != 14) {
                if (len >= textLimit) {
                    return len;
                }
                ++len;
            }
            if (len == ebcdic.length) {
                return len;
            }
            boolean dbcs = false;
            int i = len;
            while (len < ebcdic.length) {
                if (ebcdic[len] == 14) {
                    if (textLimit < len + 4) {
                        return i;
                    }
                    dbcs = true;
                } else if (ebcdic[len] == 15) {
                    dbcs = false;
                } else if (dbcs) {
                    if (textLimit < len + 3) {
                        return i;
                    }
                    ++len;
                    ++i;
                } else {
                    if (textLimit <= len) {
                        return i;
                    }
                    ++i;
                }
                ++len;
            }
            return i;
        }
        if (doc._sourceMbcs) {
            int len = 0;
            int i = 0;
            while (i < s.length()) {
                if ((len += LpexNls.getEncodingLength(s.charAt(i), doc._sourceEncoding)) > textLimit) {
                    return i;
                }
                ++i;
            }
            return i;
        }
        if (LpexNls.isShapedLigatures(doc)) {
            int len = 0;
            int i = 0;
            while (i < s.length() && len < textLimit) {
                char c;
                if ((c = s.charAt(i++)) == '\u0644' && i < s.length()) {
                    if (LpexNls.isAlef(s.charAt(i))) {
                        ++i;
                    }
                    ++len;
                    continue;
                }
                if (LpexNls.isBidiMark(c)) continue;
                ++len;
            }
            return i;
        }
        if (LpexNls.isIgnoringBidiMarks(doc)) {
            int len = 0;
            int i = 0;
            while (i < s.length() && len < textLimit) {
                char c;
                if (LpexNls.isBidiMark(c = s.charAt(i++))) continue;
                ++len;
            }
            return i;
        }
        if ("UTF8".equals(doc._sourceEncoding)) {
            int len = 0;
            int i = 0;
            while (i < s.length()) {
                if (Character.isHighSurrogate(s.charAt(i)) && i + 1 < s.length() && Character.isLowSurrogate(s.charAt(i + 1))) {
                    if ((len += LpexNls.getEncodingLength(s.substring(i, i + 2), doc._sourceEncoding)) > textLimit) {
                        return i;
                    }
                    ++i;
                } else if ((len += LpexNls.getEncodingLength(s.charAt(i), doc._sourceEncoding)) > textLimit) {
                    return i;
                }
                ++i;
            }
            return i;
        }
        int len = s.length();
        if (len > textLimit && Character.isHighSurrogate(s.charAt((len = textLimit) - 1))) {
            --len;
        }
        return len;
    }

    public String addSourceSosi(String s) {
        if (s == null || s.length() == 0 || !this._view.document()._sourceSosi) {
            return s;
        }
        return this.addSourceSosi(s, ShiftOutCharacterParameter.getParameter().currentValue(this._view), ShiftInCharacterParameter.getParameter().currentValue(this._view));
    }

    public String addSourceSosi(String s, char shiftOut, char shiftIn) {
        byte[] ebcdic;
        if (s == null || s.length() == 0 || !this._view.document()._sourceSosi) {
            return s;
        }
        try {
            ebcdic = s.getBytes(this._view.document()._sourceEncoding);
        }
        catch (Exception e) {
            return s;
        }
        int i = 0;
        while (i < ebcdic.length && ebcdic[i] != 14) {
            ++i;
        }
        if (i == ebcdic.length) {
            return s;
        }
        int charIndex = i;
        boolean dbcs = false;
        StringBuilder sb = new StringBuilder(s);
        while (i < ebcdic.length) {
            if (ebcdic[i] == 14) {
                sb.insert(charIndex, shiftOut);
                dbcs = true;
            } else if (ebcdic[i] == 15) {
                sb.insert(charIndex, shiftIn);
                dbcs = false;
            } else if (dbcs) {
                ++i;
            }
            ++i;
            ++charIndex;
        }
        return sb.toString();
    }

    void addSosiDisplayStyle(StringBuilder s, StringBuilder background, String t) {
        byte[] ebcdic;
        if (s == null || t == null || !this._view.document()._sourceSosi) {
            return;
        }
        try {
            ebcdic = t.getBytes(this._view.document()._sourceEncoding);
        }
        catch (Exception e) {
            LpexLog.log(e);
            return;
        }
        int i = 0;
        while (i < ebcdic.length && ebcdic[i] != 14) {
            ++i;
        }
        if (i == ebcdic.length) {
            return;
        }
        int charIndex = i;
        boolean dbcs = false;
        try {
            while (i < ebcdic.length) {
                if (ebcdic[i] == 14) {
                    s.insert(charIndex, s.charAt(charIndex));
                    if (background != null) {
                        background.insert(charIndex, background.charAt(charIndex));
                    }
                    dbcs = true;
                } else if (ebcdic[i] == 15) {
                    s.insert(charIndex, s.charAt(charIndex - 1));
                    if (background != null) {
                        background.insert(charIndex, background.charAt(charIndex - 1));
                    }
                    dbcs = false;
                } else if (dbcs) {
                    ++i;
                }
                ++i;
                ++charIndex;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isBidi() {
        return LpexUtilities.isBidi();
    }

    public static boolean hasBidi(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c > '\u0590') {
                if (c <= '\u07b1') {
                    return true;
                }
                if (c >= '\ufb1d' && c <= '\ufefc') {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static String stripBidiMarks(String text) {
        if (text != null) {
            int i = 0;
            int j = 0;
            char[] buf = text.toCharArray();
            while (j < buf.length) {
                if (buf[j] == '\u200e' || buf[j] == '\u200f') {
                    ++j;
                    continue;
                }
                buf[i++] = buf[j++];
            }
            return new String(buf, 0, i);
        }
        return text;
    }

    public String stripStyleBidiMarks(int element) {
        Element e = this._view.document().elementList().elementAt(element);
        if (e == null) {
            return null;
        }
        String style = e.elementView(this._view).style();
        String text = e.text();
        int t = 0;
        while (t < text.length() && t < style.length() && !LpexNls.isBidiMark(text.charAt(t))) {
            ++t;
        }
        if (t == text.length() || t == style.length()) {
            return style;
        }
        StringBuilder sb = new StringBuilder(style.length());
        sb.append(style.substring(0, t++));
        while (t < text.length() && t < style.length()) {
            if (!LpexNls.isBidiMark(text.charAt(t))) {
                sb.append(style.charAt(t));
            }
            ++t;
        }
        while (t < style.length()) {
            sb.append(style.charAt(t++));
        }
        return sb.toString();
    }

    public String cleanBidiStyles(int element, String style) {
        Element e = this._view.document().elementList().elementAt(element);
        if (e == null) {
            return null;
        }
        String text = e.text();
        int t = 0;
        while (t < text.length() && t < style.length() && !LpexNls.isBidiMark(text.charAt(t))) {
            ++t;
        }
        if (t == text.length() || t == style.length()) {
            return style;
        }
        StringBuilder sb = new StringBuilder(style.length());
        sb.append(style.substring(0, t++));
        while (t < text.length() && t < style.length()) {
            if (!LpexNls.isBidiMark(text.charAt(t))) {
                sb.append(style.charAt(t));
            }
            ++t;
        }
        while (t < style.length()) {
            sb.append(style.charAt(t++));
        }
        return sb.toString();
    }

    public static int getNumberOfBidiMarks(String text) {
        return text.length() - LpexNls.stripBidiMarks(text).length();
    }

    public void setStyleBidiMarks(int element, String style) {
        Element e = this._view.document().elementList().elementAt(element);
        if (e == null) {
            return;
        }
        if (style == null) {
            e.elementView(this._view).setStyle(null);
            return;
        }
        String text = e.text();
        int t = 0;
        while (t < text.length() && t < style.length() && !LpexNls.isBidiMark(text.charAt(t))) {
            ++t;
        }
        if (t == text.length() || t == style.length()) {
            e.elementView(this._view).setStyle(style);
            return;
        }
        StringBuilder newStyle = new StringBuilder(style.length());
        newStyle.append(style.substring(0, t));
        int s = t;
        while (t < text.length() && s < style.length()) {
            newStyle.append(style.charAt(s));
            if (LpexNls.isBidiMark(text.charAt(t++))) continue;
            ++s;
        }
        while (s < style.length()) {
            newStyle.append(style.charAt(s++));
        }
        e.elementView(this._view).setStyle(newStyle.toString());
    }

    public void setTextStyleBidiMarks(int element, String style) {
        Element e = this._view.document().elementList().elementAt(element);
        if (e == null) {
            return;
        }
        if (style == null) {
            e.elementView(this._view).setStyle(null);
            return;
        }
        String text = e.text();
        int t = 0;
        while (t < text.length() && t < style.length() && text.charAt(t) < '\u0590') {
            ++t;
        }
        if (t == text.length() || t == style.length()) {
            e.elementView(this._view).setStyle(style);
            return;
        }
        String bidiStyle = style;
        if (this._view.lpexView().parser() instanceof LpexCommonParser) {
            bidiStyle = ((LpexCommonParser)this._view.lpexView().parser()).getBidiStyle(element, style);
        }
        if (bidiStyle.length() != style.length()) {
            System.out.println("Bidi style length (" + bidiStyle.length() + ") is not the same as style length (" + style.length() + ")");
            bidiStyle = style;
        }
        boolean isLastRTL = false;
        boolean isLastAN = false;
        int tokenIndex = -1;
        int s = t;
        char currStyle = s == 0 ? (char)'!' : (char)style.charAt(s - 1);
        char prevStyle = s < 2 ? (char)'!' : (char)style.charAt(s - 2);
        char bidiCurrStyle = s == 0 ? (char)'!' : (char)bidiStyle.charAt(s - 1);
        char endStyle = style.charAt(style.length() - 1);
        char fixStyle = ' ';
        boolean endFixed = bidiStyle.charAt(bidiStyle.length() - 1) == FIXED_END;
        StringBuilder newText = new StringBuilder(text.length());
        newText.append(text.substring(0, t));
        StringBuilder newStyle = new StringBuilder(style.length());
        newStyle.append(style.substring(0, s));
        boolean textChanged = false;
        while (t < text.length()) {
            if (s < style.length()) {
                prevStyle = currStyle;
                currStyle = style.charAt(s);
                if (bidiCurrStyle != bidiStyle.charAt(s)) {
                    if (isLastRTL || isLastAN) {
                        tokenIndex = newText.length();
                    }
                    bidiCurrStyle = bidiStyle.charAt(s);
                }
            }
            char ch = text.charAt(t);
            byte dir = Character.getDirectionality(ch);
            if (ch == '\u200e') {
                tokenIndex = -1;
                isLastRTL = false;
                isLastAN = false;
                newText.append(ch);
                newStyle.append(currStyle);
                ++t;
                continue;
            }
            if (dir == 3) {
                if (tokenIndex != -1) {
                    if (isLastRTL) {
                        newText.insert(tokenIndex, '\u200e');
                        newStyle.insert(tokenIndex, currStyle);
                        textChanged = true;
                        isLastRTL = false;
                    }
                    tokenIndex = -1;
                }
                isLastAN = false;
            } else if (dir == 6) {
                if (tokenIndex != -1) {
                    newText.insert(tokenIndex, '\u200e');
                    newStyle.insert(tokenIndex, currStyle);
                    textChanged = true;
                    tokenIndex = -1;
                    isLastRTL = false;
                }
                isLastAN = true;
            } else if (dir == 1 || dir == 2) {
                if (tokenIndex != -1) {
                    newText.insert(tokenIndex, '\u200e');
                    newStyle.insert(tokenIndex, currStyle);
                    textChanged = true;
                    tokenIndex = -1;
                }
                isLastRTL = true;
                isLastAN = false;
            } else if (dir == 0) {
                tokenIndex = -1;
                isLastRTL = false;
                isLastAN = false;
            }
            newText.append(ch);
            boolean useFix = false;
            if (endFixed && bidiCurrStyle != FIXED_END && currStyle == endStyle) {
                if (fixStyle == ' ') {
                    fixStyle = prevStyle;
                }
                newStyle.append(fixStyle);
                useFix = true;
            }
            if (!useFix) {
                newStyle.append(currStyle);
            }
            ++t;
            ++s;
        }
        if (s < style.length()) {
            newStyle.append(style.substring(s));
        }
        if (textChanged) {
            boolean undoing;
            boolean recording = false;
            boolean bl = undoing = (this._view.parsePending(e) & 0x40) != 0;
            if (undoing) {
                recording = this._view.document().undo().setRecording(false);
            }
            int pos = this._view.documentPosition().element() == e ? this._view.documentPosition().position() : 0;
            String newTextString = newText.toString();
            CommandHandler.doDefaultCommand(this._view, new LpexDocumentLocation(element, 1), "set text " + newTextString);
            if (pos > 0) {
                pos = LpexNls.adjustPositionForNewBidiMarks(text, newTextString, pos);
                this._view.documentPosition().jump(e, pos, false);
            }
            if (undoing) {
                this._view.document().undo().setRecording(recording);
            }
            View v = this._view.document()._firstView;
            while (v != null) {
                v.screen()._needsScreenShow = true;
                v = v._next;
            }
        }
        e.elementView(this._view).setStyle(newStyle.toString());
    }

    static String getSyntaxSmartText(String text, String style) {
        if (text == null || style == null) {
            return text;
        }
        int t = 0;
        while (t < text.length() && t < style.length() && text.charAt(t) < '\u0590') {
            ++t;
        }
        if (t == text.length() || t == style.length()) {
            return text;
        }
        boolean isLastRTL = false;
        boolean isLastAN = false;
        int tokenIndex = -1;
        char currStyle = t == 0 ? (char)'!' : (char)style.charAt(t - 1);
        StringBuilder newText = new StringBuilder(text.length());
        newText.append(text.substring(0, t));
        while (t < text.length()) {
            if (t < style.length() && currStyle != style.charAt(t)) {
                if (isLastRTL || isLastAN) {
                    tokenIndex = newText.length();
                }
                currStyle = style.charAt(t);
            }
            char ch = text.charAt(t);
            byte dir = Character.getDirectionality(ch);
            if (ch == '\u200e') {
                tokenIndex = -1;
                isLastRTL = false;
                isLastAN = false;
            } else if (dir == 3) {
                if (tokenIndex != -1) {
                    if (isLastRTL) {
                        newText.insert(tokenIndex, '\u200e');
                        isLastRTL = false;
                    }
                    tokenIndex = -1;
                }
                isLastAN = false;
            } else if (dir == 6) {
                if (tokenIndex != -1) {
                    newText.insert(tokenIndex, '\u200e');
                    tokenIndex = -1;
                    isLastRTL = false;
                }
                isLastAN = true;
            } else if (dir == 1 || dir == 2) {
                if (tokenIndex != -1) {
                    newText.insert(tokenIndex, '\u200e');
                    tokenIndex = -1;
                }
                isLastRTL = true;
                isLastAN = false;
            } else if (dir == 0) {
                tokenIndex = -1;
                isLastRTL = false;
                isLastAN = false;
            }
            newText.append(ch);
            ++t;
        }
        return newText.toString();
    }

    static int adjustPositionForNewBidiMarks(String oldText, String newText, int pos) {
        int o = 0;
        int n = 0;
        while (n < pos && n < newText.length() && o < oldText.length()) {
            if (LpexNls.isBidiMark(newText.charAt(n)) && !LpexNls.isBidiMark(oldText.charAt(o))) {
                ++pos;
            } else {
                ++o;
            }
            ++n;
        }
        return pos;
    }

    static boolean setDefaultLocale(Locale newLocale) {
        if (newLocale == null) {
            newLocale = _initialLocale;
        }
        try {
            Locale.setDefault(newLocale);
        }
        catch (Exception x) {
            return false;
        }
        LpexResources.localeChanged();
        SortCommand.localeChanged();
        Document document = Document._firstDocument;
        while (document != null) {
            View view = document._firstView;
            while (view != null) {
                if (view.window() != null) {
                    ((StatusLine)view.window().statusLine()).localeChanged();
                    view.window().statusLineManager().localeChanged();
                    ((CommandLine)view.window().commandLine()).localeChanged();
                }
                view = view._next;
            }
            document = document._next;
        }
        return true;
    }

    static String getBomEncoding(byte[] bom) {
        if (BOM_UTF16BE == bom) {
            return "UnicodeBigUnmarked";
        }
        if (BOM_UTF16LE == bom) {
            return "UnicodeLittleUnmarked";
        }
        if (BOM_UTF8 == bom) {
            return "UTF8";
        }
        return null;
    }

    static boolean maySaveBom(String encoding) {
        boolean maySaveBom = false;
        if (encoding != null) {
            encoding = LpexNls.canonicalEncoding(encoding);
            int i = 0;
            while (i < _bomEncodings.length) {
                if (encoding.equals(_bomEncodings[i])) {
                    maySaveBom = true;
                    break;
                }
                ++i;
            }
        }
        return maySaveBom;
    }

    static String getBomEncoding(File file) {
        return LpexNls.getBomEncoding(LpexNls.getBom(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] getBom(File file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream input = new FileInputStream(file);){
                byte[] byArray;
                int first = ((InputStream)input).read();
                if (first == -1) {
                    return null;
                }
                int second = ((InputStream)input).read();
                if (second == -1) {
                    return null;
                }
                if (first == 254 && second == 255) {
                    return BOM_UTF16BE;
                }
                if (first == 255 && second == 254) {
                    return BOM_UTF16LE;
                }
                if (first == 239 && second == 187 && ((InputStream)input).read() == 191) {
                    byArray = BOM_UTF8;
                    return byArray;
                }
                byArray = null;
                return byArray;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    static String getXmlEncoding(File file, byte[] bom) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream input = new FileInputStream(file);){
                String enc;
                String firstLineEncoding = null;
                if (bom != null) {
                    if (((InputStream)input).skip(bom.length) != (long)bom.length) {
                        LpexLog.log(String.valueOf(file) + " did not have the correct format");
                    }
                    firstLineEncoding = LpexNls.getBomEncoding(bom);
                }
                String string = LpexNls.isValidEncoding(enc = LpexNls.readXmlEncoding(input, firstLineEncoding != null ? firstLineEncoding : "UTF8")) ? enc : "UTF8";
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            return "UTF8";
        }
    }

    private static String readXmlEncoding(InputStream input, String firstLineEncoding) throws IOException {
        byte[] tag = "<?xml ".getBytes(firstLineEncoding);
        byte[] xmlPrefix = new byte[tag.length];
        if (input.read(xmlPrefix) < xmlPrefix.length) {
            return null;
        }
        int i = 0;
        while (i < xmlPrefix.length) {
            if (xmlPrefix[i] != tag[i]) {
                return null;
            }
            ++i;
        }
        byte[] xmlDeclaration = new byte[100];
        int count = 0;
        int c = 0;
        while (count < xmlDeclaration.length && (c = input.read()) != -1 && c != 63) {
            xmlDeclaration[count++] = (byte)c;
        }
        if (c != 63) {
            return null;
        }
        return LpexNls.extractXmlEncoding(new String(xmlDeclaration, 0, count, firstLineEncoding));
    }

    static String extractXmlEncoding(String firstLine) {
        int encodingPos = firstLine.indexOf("encoding=");
        if (encodingPos >= 0) {
            int secondQuote;
            int quote = 34;
            int firstQuote = firstLine.indexOf(quote, encodingPos);
            if (firstQuote < 0) {
                quote = 39;
                firstQuote = firstLine.indexOf(quote, encodingPos);
            }
            if (firstQuote >= 0 && (secondQuote = firstLine.indexOf(quote, firstQuote + 1)) != -1) {
                return firstLine.substring(firstQuote + 1, secondQuote);
            }
        }
        return null;
    }

    public boolean formatTo(String targetFormat) {
        if (!targetFormat.equals(VISUAL) && !targetFormat.equals(LOGICAL)) {
            return false;
        }
        int qty = this._view.document().elementList().count();
        int i = 1;
        while (i <= qty) {
            Element e = this._view.document().elementList().elementAt(i);
            String text = e.text();
            if (LpexNls.hasBidi(text)) {
                String vText = targetFormat.equals(VISUAL) ? this.logicalToVisual(text) : this.visualToLogical(text);
                CommandHandler.doDefaultCommand(this._view, new LpexDocumentLocation(i, 1), "set text " + vText);
            }
            ++i;
        }
        if (targetFormat.equals(LOGICAL)) {
            this._view.setBidiFormatted(true);
        }
        return true;
    }

    public String logicalToVisual(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        BidiFlagSet flags1 = bidiFlagsLogical;
        BidiFlagSet flags2 = bidiFlagsVisual;
        BidiTransform bdx = new BidiTransform();
        bdx.flags = flags2;
        bdx.removeMarkers = this.isSmartLogical();
        BidiText src = new BidiText(flags1, text);
        BidiText dst = src.transform(bdx);
        String visualText = dst.toString();
        return visualText;
    }

    public String visualToLogical(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        BidiFlagSet flags2 = bidiFlagsLogical;
        BidiFlagSet flags1 = bidiFlagsVisual;
        BidiTransform bdx = new BidiTransform();
        bdx.flags = flags2;
        bdx.insertMarkers = this.isSmartLogical();
        bdx.winCompatible = true;
        BidiText src = new BidiText(flags1, text);
        BidiText dst = src.transform(bdx);
        String logicalText = dst.toString();
        return logicalText;
    }
}

