/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.cc.UCode_CharStream;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexView;
import java.io.EOFException;
import java.io.IOException;

public class LpexCharStream
implements UCode_CharStream {
    public StringBuffer bufferStyles;
    private long _bufferClasses;
    private int _bufpos;
    private boolean _eofSeen;
    private LpexView _lpexView;
    private boolean _currentStylesSet;
    private int _currentElement;
    private int _beginElement;
    private int _endElement;
    private int _beginMargin;
    private int _endMargin;
    private String _buffer;
    private int _bufferLength;
    private int _tokenBegin;
    private int _tokenBeginLine;
    private long _classClear;
    private long _classSet;
    private char _styleDefault;
    private char _outMarginsStyle;
    private boolean _ignoreWhitespace;
    private boolean _clearPending;
    private boolean _skipShowLines = true;
    private boolean _ignoreBidiMarks;
    private boolean _maintainBidiMarks;
    private boolean _setParseResults = true;
    static final char[] _suffix = new char[]{'\n'};

    public LpexCharStream(LpexView lpexView) {
        this._lpexView = lpexView;
    }

    @Override
    public final char readChar() throws IOException {
        int beginMargin;
        if (this._buffer == null || this._bufpos >= this._bufferLength) {
            this.FillBuff();
        }
        ++this._bufpos;
        if (this._beginMargin != 0 && this._bufpos < (beginMargin = this.beginMargin())) {
            this._bufpos = beginMargin;
        }
        if (this._endMargin != 0 && this._bufpos > this.endMargin()) {
            this._bufpos = this._bufferLength;
        }
        return this._bufpos >= this._bufferLength ? (char)'\n' : this._buffer.charAt(this._bufpos);
    }

    @Override
    public final int getEndColumn() {
        int endMargin;
        int endColumn = this._bufpos + 1;
        if (this._endMargin != 0 && endColumn > (endMargin = this.endMargin() + 1) + 1) {
            endColumn = endMargin + 1;
        }
        return endColumn;
    }

    @Override
    public final int getEndLine() {
        return this._currentElement;
    }

    @Override
    public final int getBeginColumn() {
        return this._tokenBegin + 1;
    }

    @Override
    public final int getBeginLine() {
        return this._tokenBeginLine;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void backup(int amount) {
        if (amount == 0) {
            return;
        }
        this._eofSeen = false;
        if (this._endMargin != 0 && this._bufpos > (endMargin = this.endMargin())) {
            this._bufpos = endMargin;
            if (--amount == 0) {
                return;
            }
        }
        if ((diff = this._bufpos - this.beginMargin() - amount) < -1) ** GOTO lbl18
        this._bufpos -= amount;
        return;
lbl-1000:
        // 2 sources

        {
            --this._currentElement;
            if (this._skipShowLines && this._lpexView.show(this._currentElement)) continue;
            this._buffer = this.getElementText(this._currentElement);
            this._bufferLength = this._buffer.length();
            if (this._endMargin != 0 && this._bufferLength > (endMargin = this.endMargin()) + 1) {
                this._bufferLength = endMargin + 1;
            }
            diff += this._bufferLength - this.beginMargin() + 1;
lbl18:
            // 2 sources

            if (diff >= -1) break;
            ** while (true)
        }
        this._bufpos = this.beginMargin() + diff;
        this.bufferStyles = new StringBuffer(this.getElementStyle(this._currentElement));
        this._bufferClasses = this._lpexView.elementClasses(this._currentElement);
        this._currentStylesSet = false;
    }

    @Override
    public final char BeginToken() throws IOException {
        char c;
        try {
            c = this.readChar();
        }
        catch (IOException e) {
            this._tokenBegin = this._bufpos;
            this._tokenBeginLine = this._currentElement;
            throw e;
        }
        this._tokenBegin = this._bufpos;
        this._tokenBeginLine = this._currentElement;
        return c;
    }

    @Override
    public String GetImage() {
        return "";
    }

    @Override
    public char[] GetSuffix(int len) {
        if (_suffix == null) {
            return null;
        }
        char[] result = new char[_suffix.length];
        System.arraycopy(_suffix, 0, result, 0, _suffix.length);
        return result;
    }

    @Override
    public void Done() {
        this._buffer = null;
        this._bufferLength = 0;
        this.bufferStyles = null;
    }

    public final void Init(int beginElement, int endElement, long classClear, long classSet, char styleDefault, boolean clearPending) {
        this._beginElement = beginElement;
        this._endElement = endElement > this._lpexView.elements() ? this._lpexView.elements() : endElement;
        this._classClear = classClear;
        this._classSet = classSet;
        this._styleDefault = styleDefault;
        this._clearPending = clearPending;
        this._eofSeen = false;
        this._currentElement = -1;
        this._endMargin = 0;
        this._beginMargin = 0;
        this._maintainBidiMarks = false;
        this._setParseResults = true;
        this._currentStylesSet = true;
        this._bufpos = -1;
        this._buffer = null;
        this._bufferLength = 0;
        if (this.bufferStyles == null) {
            this.bufferStyles = new StringBuffer();
        }
        this._ignoreBidiMarks = this._lpexView.nls().isSmartLogical();
    }

    public final void Init(int beginElement, int beginPosition, int endElement, long classClear, long classSet, char styleDefault, boolean clearPending) {
        this.Init(beginElement, endElement, classClear, classSet, styleDefault, clearPending);
        if (beginPosition <= 1) {
            return;
        }
        this._currentElement = this._beginElement;
        this._buffer = this.getElementText(this._currentElement);
        this._bufferLength = this._buffer.length();
        this._bufpos = beginPosition - 2;
        this.bufferStyles.setLength(this._bufferLength);
        String originalStyles = this.getElementStyle(this._currentElement);
        int i = 0;
        while (i < beginPosition - 1 && i < this._bufferLength) {
            this.bufferStyles.setCharAt(i, originalStyles.charAt(i));
            ++i;
        }
        while (i < this._bufferLength) {
            this.bufferStyles.setCharAt(i, this._styleDefault);
            ++i;
        }
        this._bufferClasses = this._lpexView.elementClasses(this._currentElement);
        this._currentStylesSet = false;
    }

    public final boolean setMargins(int beginMargin, int endMargin, char outMarginsStyle) {
        return this.setMargins(beginMargin, endMargin, outMarginsStyle, false);
    }

    public final boolean setMargins(int beginMargin, int endMargin, char outMarginsStyle, boolean ignoreWhitespace) {
        if (beginMargin <= 1) {
            beginMargin = 1;
        }
        if (endMargin != 0 && endMargin < beginMargin) {
            return false;
        }
        this._beginMargin = beginMargin - 1;
        this._endMargin = endMargin == 0 ? 0 : endMargin - 1;
        this._outMarginsStyle = outMarginsStyle;
        this._ignoreWhitespace = ignoreWhitespace;
        return true;
    }

    public final void setParseResults(boolean setParseResults) {
        this._setParseResults = setParseResults;
    }

    public final void setMaintainBidiMarks(boolean maintainBidiMarks) {
        this._maintainBidiMarks = maintainBidiMarks && this._lpexView.nls().isSourceBidi();
    }

    public final int Expand(int endElement) {
        if (endElement > this._lpexView.elements()) {
            endElement = this._lpexView.elements();
        }
        if (this._endElement < endElement) {
            this._endElement = endElement;
            if (this._eofSeen) {
                this._eofSeen = false;
                this._bufpos = -1;
                this._buffer = null;
                this._bufferLength = 0;
                if (this.bufferStyles == null) {
                    this.bufferStyles = new StringBuffer();
                }
            }
        }
        return this._endElement;
    }

    private void FillBuff() throws IOException {
        if (!this._currentStylesSet && this._currentElement >= this._beginElement && this._currentElement <= this._endElement) {
            this.setCurrentStyles();
            if (this._clearPending) {
                this._lpexView.elementParsed(this._currentElement);
            }
        }
        if (this._currentElement == -1) {
            this._currentElement = this._beginElement - 1;
        }
        int tryElement = this._currentElement;
        while (++tryElement <= this._endElement && this._skipShowLines && this._lpexView.show(tryElement)) {
        }
        if (tryElement > this._endElement) {
            this._eofSeen = true;
            throw new EOFException();
        }
        this._currentElement = tryElement;
        this._buffer = this.getElementText(this._currentElement);
        this._bufferLength = this._buffer.length();
        this._bufpos = -1;
        this.bufferStyles.setLength(this._bufferLength);
        int i = 0;
        while (i < this._bufferLength) {
            this.bufferStyles.setCharAt(i, this._styleDefault);
            ++i;
        }
        this._bufferClasses = this._lpexView.elementClasses(this._currentElement) & (this._classClear ^ 0xFFFFFFFFFFFFFFFFL) | this._classSet;
        this._currentStylesSet = false;
    }

    private String getElementText(int element) {
        String text = this._lpexView.elementText(element);
        return this._ignoreBidiMarks ? LpexNls.stripBidiMarks(text) : text;
    }

    private String getElementStyle(int element) {
        return this._ignoreBidiMarks ? this._lpexView.nls().stripStyleBidiMarks(element) : this._lpexView.elementStyle(element);
    }

    private int beginMargin() {
        if (this._beginMargin == 0) {
            return 0;
        }
        if (this._lpexView.nls().usingSourceColumns()) {
            return this._lpexView.nls().indexFromEncodingIndex(this._buffer, this._beginMargin);
        }
        return this._beginMargin;
    }

    public int endMargin() {
        if (this._endMargin == 0) {
            return 0;
        }
        if (this._lpexView.nls().usingSourceColumns()) {
            return this._lpexView.nls().indexFromEncodingIndex(this._buffer, this._endMargin);
        }
        return this._endMargin;
    }

    public final LpexView getLpexView() {
        return this._lpexView;
    }

    public final int getEndElement() {
        return this._endElement;
    }

    public final String getBufferText() {
        return this._buffer;
    }

    public final String getBufferText(int element) {
        if (element == this._currentElement) {
            return this._buffer;
        }
        return this.getElementText(element);
    }

    public final boolean EOFSeen() {
        return this._eofSeen;
    }

    public final void skipChar() {
        ++this._bufpos;
    }

    public final void backupToStart() {
        this._bufpos = -1;
    }

    public final void setStyles(int beginCol, int endCol, char style) {
        if (endCol < beginCol) {
            ++endCol;
        }
        int i = beginCol - 1;
        while (i < endCol && i < this.bufferStyles.length()) {
            this.bufferStyles.setCharAt(i, style);
            ++i;
        }
    }

    public final void setStyles(int element, int beginCol, int endCol, char style) {
        int currentLine;
        int n = currentLine = this.EOFSeen() ? -1 : this._currentElement;
        if (element == currentLine) {
            this.setStyles(beginCol, endCol, style);
            return;
        }
        if (!this._setParseResults) {
            return;
        }
        if (endCol < beginCol) {
            ++endCol;
        }
        StringBuilder styles = new StringBuilder(this.getElementStyle(element));
        int i = beginCol - 1;
        while (i < endCol && i < styles.length()) {
            styles.setCharAt(i, style);
            ++i;
        }
        if (this._ignoreBidiMarks) {
            this._lpexView.nls().setStyleBidiMarks(element, styles.toString());
        } else {
            this._lpexView.setElementStyle(element, styles.toString());
        }
    }

    public final void setClasses(long classes) {
        if (classes != 0L) {
            this._bufferClasses &= this._classSet ^ 0xFFFFFFFFFFFFFFFFL;
            this._bufferClasses |= classes;
        }
    }

    public final void setClasses(int element, long classes) {
        int currentLine;
        int n = currentLine = this.EOFSeen() ? -1 : this._currentElement;
        if (element == currentLine) {
            this.setClasses(classes);
            return;
        }
        if (!this._setParseResults) {
            return;
        }
        if (classes != 0L) {
            long newClasses = this._lpexView.elementClasses(element);
            newClasses &= this._classSet ^ 0xFFFFFFFFFFFFFFFFL;
            this._lpexView.setElementClasses(element, newClasses |= classes);
        }
    }

    public final void removeClasses(long classes) {
        this._bufferClasses &= classes ^ 0xFFFFFFFFFFFFFFFFL;
        if (this._bufferClasses == 0L) {
            this._bufferClasses = this._classSet;
        }
    }

    public final void setCurrentStyles() {
        if (this._beginMargin != 0) {
            int beginMargin = this.beginMargin();
            int i = 0;
            while (i < beginMargin && i < this.bufferStyles.length()) {
                if (!this._ignoreWhitespace || i >= this._buffer.length() || this._buffer.charAt(i) != ' ' && this._buffer.charAt(i) != '\t') {
                    this.bufferStyles.setCharAt(i, this._outMarginsStyle);
                }
                ++i;
            }
        }
        if (this._endMargin != 0) {
            int i;
            boolean doit;
            int endMargin = this.endMargin();
            boolean bl = doit = !this._ignoreWhitespace;
            if (!doit) {
                i = endMargin + 1;
                while (i < this.bufferStyles.length()) {
                    if (i >= this._buffer.length() || this._buffer.charAt(i) != ' ' && this._buffer.charAt(i) != '\t') {
                        doit = true;
                        break;
                    }
                    ++i;
                }
            }
            if (doit) {
                i = endMargin + 1;
                while (i < this.bufferStyles.length()) {
                    this.bufferStyles.setCharAt(i, this._outMarginsStyle);
                    ++i;
                }
            }
        }
        if (this._setParseResults) {
            if (this._maintainBidiMarks) {
                this._lpexView.nls().setTextStyleBidiMarks(this._currentElement, this.bufferStyles.toString());
            } else if (this._ignoreBidiMarks) {
                this._lpexView.nls().setStyleBidiMarks(this._currentElement, this.bufferStyles.toString());
            } else {
                this._lpexView.setElementStyle(this._currentElement, this.bufferStyles.toString());
            }
            this._lpexView.setElementClasses(this._currentElement, this._bufferClasses);
        }
        this._currentStylesSet = true;
    }
}

