/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.View;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

final class LocateCommand {
    LocateCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        Screen screen;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return CommandHandler.noParameters(view, "locate");
        }
        boolean emphasis = false;
        boolean all = false;
        String token = st.nextToken();
        if (token.equalsIgnoreCase("emphasis")) {
            emphasis = true;
            if (!st.hasMoreTokens()) {
                return CommandHandler.incomplete(view, "locate");
            }
            token = st.nextToken();
        }
        if (token.equalsIgnoreCase("all")) {
            all = true;
            if (!st.hasMoreTokens()) {
                return CommandHandler.incomplete(view, "locate");
            }
            token = st.nextToken();
        }
        boolean result = false;
        if (token.equalsIgnoreCase("element")) {
            result = LocateCommand.locateElement(view, st, emphasis);
        } else if (token.equalsIgnoreCase("line")) {
            result = LocateCommand.locateLine(view, st, emphasis);
        } else if (token.equalsIgnoreCase("mark")) {
            result = LocateCommand.locateMark(view, st, emphasis);
        } else if (token.equalsIgnoreCase("sequenceNumber")) {
            result = LocateCommand.locateSequenceNumber(view, st, emphasis);
        } else if (token.equalsIgnoreCase("sequenceText")) {
            result = LocateCommand.locateSequenceText(view, st, emphasis, all);
        } else {
            return CommandHandler.invalidParameter(view, token, "locate");
        }
        if (Display.getCurrent() != null && (screen = view.screen()) != null) {
            screen.show();
        }
        return result;
    }

    private static boolean locateElement(View view, LpexStringTokenizer st, boolean emphasis) {
        if (!st.hasMoreTokens()) {
            return CommandHandler.incomplete(view, "locate element");
        }
        String token = st.nextToken();
        try {
            int element = Integer.parseInt(token);
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "locate element");
            }
            if (view != null) {
                view.verifyDocumentSectionElement(element);
                int sectionElement = element - view.document().linesBeforeStart();
                CommandHandler.setStatus(null);
                if (sectionElement < 1 || sectionElement > view.document().elementList().count()) {
                    view.setLpexMessageText("locate.elementNotFound", element);
                    CommandHandler.setStatus("locate.notFound");
                } else {
                    Element e = view.document().elementList().elementAt(sectionElement);
                    if (e != null) {
                        view.documentPosition().jump(e, 1);
                        if (emphasis) {
                            int len = e.length();
                            if (len == 0) {
                                len = 1;
                            }
                            view.documentPosition().setEmphasisLength(len);
                        }
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            return CommandHandler.invalidParameter(view, token, "locate element");
        }
        return true;
    }

    private static boolean locateLine(View view, LpexStringTokenizer st, boolean emphasis) {
        if (!st.hasMoreTokens()) {
            return CommandHandler.incomplete(view, "locate line");
        }
        String token = st.nextToken();
        try {
            int line = Integer.parseInt(token);
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "locate line");
            }
            if (view != null) {
                view.verifyDocumentSectionLine(line);
                int sectionLine = line - view.document().linesBeforeStart();
                CommandHandler.setStatus(null);
                if (sectionLine < 1 || sectionLine > view.document().elementList().nonShowCount()) {
                    view.setLpexMessageText("locate.lineNotFound", line);
                    CommandHandler.setStatus("locate.notFound");
                } else {
                    Element e = view.document().elementList().nonShowElementAt(sectionLine);
                    if (e != null) {
                        LocateCommand.handleViewNavigateMarkLocation(view);
                        view.documentPosition().jump(e, 1);
                        if (emphasis) {
                            int len = e.length();
                            if (len == 0) {
                                len = 1;
                            }
                            view.documentPosition().setEmphasisLength(len);
                        }
                        LocateCommand.handleViewNavigateMarkLocation(view);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            return CommandHandler.invalidParameter(view, token, "locate line");
        }
        return true;
    }

    private static void handleViewNavigateMarkLocation(final View view) {
        Display display;
        LpexWindow window = view.window();
        if (window != null && !window.isDisposed() && (display = Display.getDefault()) != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    LpexWindow window = view.window();
                    if (window != null && !window.isDisposed()) {
                        LpexAbstractTextEditor editor = null;
                        editor = (LpexAbstractTextEditor)((Object)window.getData("LPEX_ABSTRACT_TEXT_EDITOR"));
                        if (editor != null) {
                            editor.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)editor);
                        }
                    }
                }
            });
        }
    }

    private static boolean locateMark(View view, LpexStringTokenizer st, boolean emphasis) {
        if (!st.hasMoreTokens()) {
            return CommandHandler.incomplete(view, "locate mark");
        }
        String token = st.nextToken();
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "locate mark");
        }
        if (view != null) {
            CommandHandler.setStatus(null);
            MarkList.Mark mark = view.markList().find(token);
            if (mark != null) {
                view.documentPosition().jump(mark.documentLocation());
                if (emphasis) {
                    view.documentPosition().setEmphasisLength(1);
                }
            } else {
                view.setLpexMessageText("locate.markNotFound", token);
                CommandHandler.setStatus("locate.notFound");
            }
        }
        return true;
    }

    private static boolean locateSequenceNumber(View view, LpexStringTokenizer st, boolean emphasis) {
        if (!st.hasMoreTokens()) {
            return CommandHandler.incomplete(view, "locate sequenceNumber");
        }
        String token = st.nextToken();
        try {
            int sequenceNumber = Integer.parseInt(token);
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "locate sequenceNumber");
            }
            if (view != null) {
                CommandHandler.setStatus(null);
                Element e = view.document().elementList().findSequenceNumber(sequenceNumber);
                if (e == null) {
                    view.setLpexMessageText("locate.sequenceNumberNotFound", sequenceNumber);
                    CommandHandler.setStatus("locate.notFound");
                } else {
                    view.documentPosition().jump(e, 1);
                    if (emphasis) {
                        int len = e.length();
                        if (len == 0) {
                            len = 1;
                        }
                        view.documentPosition().setEmphasisLength(len);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            return CommandHandler.invalidParameter(view, token, "locate sequenceNumber");
        }
        return true;
    }

    private static boolean locateSequenceText(View view, LpexStringTokenizer st, boolean emphasis, boolean all) {
        Element e;
        if (!st.hasMoreTokens()) {
            return CommandHandler.incomplete(view, "locate sequenceText");
        }
        String[] from = new String[]{"", ""};
        String[] to = new String[]{"", ""};
        int ranges = 0;
        while (st.hasMoreTokens()) {
            if (ranges == 2) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "locate sequenceText");
            }
            from[ranges] = st.nextToken();
            if (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equalsIgnoreCase("to")) {
                    return CommandHandler.invalidParameter(view, token, "locate sequenceText");
                }
                if (!st.hasMoreTokens()) {
                    return CommandHandler.incomplete(view, "locate sequenceText");
                }
                to[ranges] = st.nextToken();
            } else {
                to[ranges] = from[ranges];
            }
            ++ranges;
        }
        CommandHandler.setStatus(null);
        if (view == null) {
            return true;
        }
        ElementList elementList = view.document().elementList();
        if (elementList.sequenceNumbersTextWidth() == 0) {
            view.setLpexMessageText("locate.noSequenceText");
            CommandHandler.setStatus("locate.noSequenceText");
            return true;
        }
        int i = 0;
        while (i < ranges) {
            if (from[i].compareTo(to[i]) > 0) {
                String temp = from[i];
                from[i] = to[i];
                to[i] = temp;
            }
            ++i;
        }
        boolean found = false;
        boolean wrapped = false;
        Element startElement = null;
        if (all) {
            view.clearClasses(Long.MIN_VALUE);
            e = elementList.first();
            while (e != null) {
                String sequenceText;
                if (!e.show() && (sequenceText = e.sequenceText()) != null) {
                    int i2 = 0;
                    while (i2 < ranges) {
                        if (sequenceText.compareTo(from[i2]) >= 0 && sequenceText.compareTo(to[i2]) <= 0) {
                            ElementView elementView = e.elementView(view);
                            elementView.setClasses(elementView.classes() | Long.MIN_VALUE);
                            if (!found) {
                                view.documentPosition().jump(e, 1);
                            }
                            found = true;
                        }
                        ++i2;
                    }
                }
                e = e.next();
            }
            view.setIncludedClasses(Long.MIN_VALUE);
        } else {
            startElement = e = view.documentPosition().element();
            Element lastElementAfterWrap = e = e == null ? null : e.nextVisible(view);
            while (!found) {
                String sequenceText;
                if (e == null && !wrapped) {
                    e = elementList.firstVisible(view);
                    wrapped = true;
                }
                if (e == null || wrapped && e == lastElementAfterWrap) break;
                if (!e.show() && (sequenceText = e.sequenceText()) != null) {
                    int i3 = 0;
                    while (i3 < ranges) {
                        if (sequenceText.compareTo(from[i3]) >= 0 && sequenceText.compareTo(to[i3]) <= 0) {
                            found = true;
                            view.documentPosition().jump(e, 1);
                            break;
                        }
                        ++i3;
                    }
                }
                e = e.nextVisible(view);
            }
        }
        if (!found) {
            if (emphasis) {
                view.documentPosition().setEmphasisLength(0);
            }
            Object searchText = from[0];
            if (!from[0].equals(to[0])) {
                searchText = (String)searchText + " to " + to[0];
            }
            if (ranges == 2) {
                searchText = (String)searchText + ", " + from[1];
                if (!from[1].equals(to[1])) {
                    searchText = (String)searchText + " to " + to[1];
                }
            }
            view.setLpexMessageText("locate.sequenceTextNotFound", (String)searchText);
            CommandHandler.setStatus("locate.notFound");
        } else {
            e = view.documentPosition().element();
            if (emphasis) {
                int len = e.length();
                if (len == 0) {
                    len = 1;
                }
                view.documentPosition().setEmphasisLength(len);
            }
            if (wrapped && e != startElement) {
                CommandHandler.setStatus("locate.wrapped");
            }
        }
        return true;
    }
}

