/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ActionHandler;
import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.View;

final class KeyRecorder {
    private static KeyRecorder _keyRecorder;
    private List _recordedActions = new List();
    private boolean _recording;
    private boolean _playing;

    private KeyRecorder() {
    }

    static KeyRecorder keyRecorder() {
        if (_keyRecorder == null) {
            _keyRecorder = new KeyRecorder();
        }
        return _keyRecorder;
    }

    boolean recording() {
        return this._recording;
    }

    boolean anythingRecorded() {
        return this._recordedActions.first() != null;
    }

    void setRecording(boolean recording) {
        this._recording = recording;
    }

    void clear() {
        this._recordedActions.clear();
    }

    void play(View view) {
        if (!this._playing) {
            this._playing = true;
            Block block = view == null ? Block.lpexBlock() : view.block();
            RecordedAction recordedAction = (RecordedAction)this._recordedActions.first();
            while (recordedAction != null) {
                recordedAction.play(view);
                block.validate();
                recordedAction = (RecordedAction)recordedAction.next();
            }
            this._playing = false;
        }
    }

    String playString() {
        StringBuilder sb = new StringBuilder(640);
        RecordedAction recordedAction = (RecordedAction)this._recordedActions.first();
        while (recordedAction != null) {
            recordedAction.playString(sb);
            recordedAction = (RecordedAction)recordedAction.next();
        }
        return sb.toString();
    }

    void recordAction(View view, int actionId, String actionArgument) {
        if (this._recording) {
            this._recordedActions.addBefore(null, new RecordedAction(view.actionHandler().actionName(actionId), actionArgument));
        }
    }

    void recordCharacter(boolean insertMode, char character) {
        if (this._recording) {
            RecordedAction lastRecordedAction = (RecordedAction)this._recordedActions.last();
            if (lastRecordedAction != null && !lastRecordedAction.action() && lastRecordedAction.insertMode() == insertMode) {
                lastRecordedAction.appendCharacter(character);
            } else {
                this._recordedActions.addBefore(null, new RecordedAction(insertMode, character));
            }
        }
    }

    static final class RecordedAction
    extends ListNode {
        boolean _action;
        String _actionName;
        String _actionArgument;
        boolean _insertMode;
        String _text;

        RecordedAction(String actionName, String actionArgument) {
            this._action = true;
            this._actionName = actionName;
            this._actionArgument = actionArgument;
        }

        RecordedAction(boolean insertMode, char character) {
            this._action = false;
            this._insertMode = insertMode;
            this._text = String.valueOf(character);
        }

        boolean action() {
            return this._action;
        }

        boolean insertMode() {
            return this._insertMode;
        }

        void appendCharacter(char character) {
            this._text = String.valueOf(this._text) + character;
        }

        void play(View view) {
            if (view == null) {
                return;
            }
            if (this._action) {
                ActionHandler actionHandler = view.actionHandler();
                actionHandler.setArgument(this._actionArgument);
                actionHandler.doAction(actionHandler.id(this._actionName));
                actionHandler.setArgument(null);
            } else {
                int i = 0;
                while (i < this._text.length()) {
                    view.receiveCharacter(this._insertMode, this._text.charAt(i));
                    ++i;
                }
            }
        }

        void playString(StringBuilder sb) {
            if (this._action) {
                sb.append(LpexStringTokenizer.addQuotes("set actionArgument" + (this._actionArgument == null ? "" : this._actionArgument)) + LpexStringTokenizer.addQuotes("action " + this._actionName));
            } else {
                sb.append(LpexStringTokenizer.addQuotes((this._insertMode ? "insertText " : "replaceText ") + this._text));
            }
        }
    }
}

