/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.TextScrollBar;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ScrollBar;

final class HorizontalScrollBar
extends TextScrollBar {
    HorizontalScrollBar(Screen screen) {
        this._screen = screen;
        this._minimum = 0;
    }

    @Override
    void build() {
        boolean needed;
        int currentWidth;
        int value = this._screen.scroll();
        int visibleAmount = this._screen.textAreaWidth();
        int maximum = this._screen._view.maxElementWidth();
        int unitIncrement = 1;
        if (this._screen.textFontMetrics() != null) {
            maximum += this._screen.textFontMetrics().spaceWidth();
            unitIncrement = this._screen.textFontMetrics().spaceWidth();
        }
        if ((currentWidth = this._screen.scroll() + visibleAmount) > maximum) {
            maximum = currentWidth;
        }
        int blockIncrement = visibleAmount;
        if (this._value != value || this._visibleAmount != visibleAmount || this._maximum != maximum || this._blockIncrement != blockIncrement || this._unitIncrement != unitIncrement) {
            this._updateRequired = true;
            this._value = value;
            this._visibleAmount = visibleAmount;
            this._maximum = maximum;
            this._blockIncrement = blockIncrement;
            this._unitIncrement = unitIncrement;
        }
        boolean bl = needed = visibleAmount < maximum;
        if (needed != this._needed) {
            this._updateRequired = true;
            this._needed = needed;
        }
    }

    @Override
    void changeLpexWindow(LpexWindow oldLpexWindow, LpexWindow newLpexWindow) {
        if (oldLpexWindow != null && !oldLpexWindow.textWindow().isDisposed()) {
            oldLpexWindow.horizontalScrollBar().removeSelectionListener((SelectionListener)this);
        }
        if (newLpexWindow != null) {
            newLpexWindow.horizontalScrollBar().addSelectionListener((SelectionListener)this);
        }
        this._updateRequired = true;
    }

    @Override
    ScrollBar scrollBar() {
        return this._screen._lpexWindow != null ? this._screen._lpexWindow.horizontalScrollBar() : null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        int newScroll;
        int scroll = this._screen.scroll();
        if (scroll > (newScroll = this.scrollBar().getSelection())) {
            this._screen._view.documentPosition().scrollLeft(scroll - newScroll);
        } else if (scroll < newScroll) {
            this._screen._view.documentPosition().scrollRight(newScroll - scroll);
        }
        if (this._updateRequired && this._lastTrackValue == newScroll) {
            Document.screenShow();
        } else {
            this._tracking = true;
            Document.screenShow();
            this._tracking = false;
        }
        this._lastTrackValue = newScroll;
    }
}

