/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.View;

final class FieldsParameter
extends Parameter {
    private static FieldsParameter _parameter;

    static FieldsParameter getParameter() {
        if (_parameter == null) {
            _parameter = new FieldsParameter();
        }
        return _parameter;
    }

    private FieldsParameter() {
        super("fields");
    }

    @Override
    boolean isQueryOnly(String qualifier) {
        return qualifier != null;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        int count = 0;
        int lastField = 0;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                int field = Integer.parseInt(token);
                if (field <= lastField) {
                    return CommandHandler.invalidParameter(view, token, "set " + this.name());
                }
                ++count;
                lastField = field;
            }
            catch (NumberFormatException e) {
                return CommandHandler.invalidParameter(view, token, "set " + this.name());
            }
        }
        int[] fields = null;
        if (count > 0) {
            fields = new int[count];
            st = new LpexStringTokenizer(parameters);
            int i = 0;
            while (i < count) {
                try {
                    fields[i] = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (view != null) {
            view.setFields(fields);
        }
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view != null) {
            int[] fields = null;
            if ("element".equals(qualifier) && documentLocation != null) {
                Element element = view.document().elementList().elementAt(documentLocation.element);
                if (element != null) {
                    fields = view.fields(element);
                }
            } else {
                fields = view.fields();
            }
            if (fields != null) {
                StringBuilder queryString = new StringBuilder(120);
                int i = 0;
                while (i < fields.length) {
                    if (queryString.length() != 0) {
                        queryString.append(' ');
                    }
                    queryString.append(fields[i]);
                    ++i;
                }
                return queryString.toString();
            }
        }
        return null;
    }
}

