/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.View;

final class ElementClassesParameter
extends Parameter {
    private static ElementClassesParameter _parameter;

    static ElementClassesParameter getParameter() {
        if (_parameter == null) {
            _parameter = new ElementClassesParameter();
        }
        return _parameter;
    }

    private ElementClassesParameter() {
        super("elementClasses");
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        if (view != null) {
            long classes = 0L;
            LpexStringTokenizer st = new LpexStringTokenizer(parameters);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                long mask = view.classes().mask(token);
                if (mask == 0L) {
                    return CommandHandler.invalidParameter(view, token, "set " + this.name(qualifier));
                }
                classes |= mask;
            }
            Element element = view.documentPosition().element();
            if (element != null) {
                element.elementView(view).setClasses(classes);
            }
        }
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        Element element;
        if (view != null && documentLocation != null && (element = view.document().elementList().elementAt(documentLocation.element)) != null) {
            return view.classes().names(element.elementView(view).classes());
        }
        return null;
    }
}

