/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ProcessPrefixCommand;
import com.ibm.lpex.core.View;

final class DeleteCommand {
    DeleteCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        Element currentElement;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        int count = 1;
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                count = Integer.parseInt(token);
                if (count < 1) {
                    return CommandHandler.invalidParameter(view, token, "delete");
                }
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "delete");
                }
            }
            catch (NumberFormatException e) {
                return CommandHandler.invalidParameter(view, token, "delete");
            }
        }
        if (view != null && (currentElement = view.documentPosition().element()) != null) {
            Element visibleBeforeFirst = currentElement.prevVisible(view);
            Element beforeFirst = currentElement.prev();
            Element afterLast = null;
            int i = 0;
            while (i < count) {
                afterLast = currentElement.next();
                view.deleteElement(currentElement);
                currentElement = view.documentPosition().element();
                if (currentElement == null || currentElement == visibleBeforeFirst) break;
                ++i;
            }
            ProcessPrefixCommand.coalesceExcludes(view, beforeFirst, afterLast);
            view.verifyDocumentSection();
        }
        return true;
    }
}

