/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.View;

final class DefaultParameter
extends Parameter {
    private static DefaultParameter _parameter;

    static DefaultParameter getParameter() {
        if (_parameter == null) {
            _parameter = new DefaultParameter();
        }
        return _parameter;
    }

    private DefaultParameter() {
        super("default.");
    }

    @Override
    boolean isQueryOnly(String qualifier) {
        Parameter p = Parameters.getParameter(qualifier);
        return p != null ? p.isQueryOnly(qualifier) : false;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        Parameter p = Parameters.getParameter(qualifier);
        if (p == null || !p.hasDefaultSetting()) {
            return CommandHandler.invalidParameter(view, qualifier, "set " + this.name());
        }
        return p.setDefault(view, Parameters.getQualifierString(qualifier), parameters);
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        Parameter p = Parameters.getParameter(qualifier);
        if (p != null && p.hasDefaultSetting()) {
            return p.queryDefault(Parameters.getQualifierString(qualifier));
        }
        return null;
    }
}

