/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexCursorListener;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.View;

final class CursorListenerList
extends List {
    private View _view;
    private Element _lastCursorElement;

    CursorListenerList(View view) {
        this._view = view;
        this._lastCursorElement = this._view.documentPosition().element();
    }

    void addListener(LpexCursorListener listener) {
        if (this.find(listener) == null) {
            this.addAfter(null, new ListenerNode(listener));
        }
    }

    void removeListener(LpexCursorListener listener) {
        List.Node node;
        if (listener != null && (node = this.find(listener)) != null) {
            this.remove(node);
        }
    }

    void elementChanged() {
        Element currentCursorElement = this._view.documentPosition().element();
        if (this._lastCursorElement != currentCursorElement) {
            this.beginScanning();
            List.Node node = this.first();
            while (node != null) {
                ListenerNode listenerNode = (ListenerNode)node;
                try {
                    if (!listenerNode.isNotifying()) {
                        listenerNode.setNotifying(true);
                        listenerNode.listener().elementChanged(this._view.lpexView());
                        listenerNode.setNotifying(false);
                        this._lastCursorElement = currentCursorElement;
                    }
                }
                catch (Throwable e) {
                    String errorText = LpexResources.message("exception.listener", listenerNode.listener().toString());
                    this._view.screen().setMessageText(errorText);
                    LpexLog.log(this._view, errorText, e);
                    this.remove(node);
                }
                node = node.next();
            }
            this.endScanning();
        }
    }

    List.Node find(LpexCursorListener listener) {
        List.Node node = this.first();
        while (node != null) {
            if (((ListenerNode)node).listener() == listener) {
                return node;
            }
            node = node.next();
        }
        return null;
    }

    private static class ListenerNode
    extends ListNode {
        private LpexCursorListener _listener;
        private boolean _isNotifying;

        ListenerNode(LpexCursorListener listener) {
            this._listener = listener;
        }

        LpexCursorListener listener() {
            return this._listener;
        }

        boolean isNotifying() {
            return this._isNotifying;
        }

        void setNotifying(boolean isNotifying) {
            this._isNotifying = isNotifying;
        }
    }
}

