/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.BlockTypeResetter;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.CommandString;
import com.ibm.lpex.core.CommandStringList;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.EditLine;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.FindTextCommand;
import com.ibm.lpex.core.LocateCommand;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.UpdateProfileCommand;
import com.ibm.lpex.core.View;
import com.ibm.lpex.core.VisualEditLine;
import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

final class CommandLine
extends Composite
implements Listener,
SelectionListener,
ModifyListener,
FocusListener {
    static final int MODE_COMMANDS = 0;
    static final int MODE_FIND = 1;
    static final int MODE_FIND_AND_REPLACE = 2;
    static final int MODE_FIND_MARK = 3;
    static final int MODE_INPUT = 4;
    static final int MODE_SET_PARSER = 5;
    static final int MODE_EDIT_LINE = 6;
    static final int MODE_VISUAL_EDIT_LINE = 7;
    private static final int MODES = 8;
    private static String[] _labelTextIds;
    private Widget _inputFocusWidget;
    private Event _focusEvent = new Event();
    LpexWindow _lpexWindow;
    LpexMultiWindow _lpexMultiWindow;
    private EditLine _editLine;
    private VisualEditLine _visualEditLine;
    private boolean _forceVisible;
    private int _mode;
    private String[] _savedText;
    private View _inputView;
    private String _inputLabelText;
    private String[] _inputText;
    private int _inputTextIndex;
    private String _inputCommand;
    private boolean _ignoreItemStateChanged;
    private Label _label;
    private int _labelBorder = 5;
    private CommandEntry _commandEntry;
    private Composite _findButtonsBox;
    private Button _findNextButton;
    private Button _findPrevButton;
    private Button _findAllButton;
    private Composite _replaceBox;
    private Label _replaceLabel;
    private Text _replaceEntry;
    private Button _replaceNextButton;
    private Button _replaceAllButton;
    private Button _caseSensitiveCheckBox;
    private Button _wholeWordCheckBox;
    private Button _regularExpressionCheckBox;
    private Button _wrapCheckBox;
    private Button _selectFoundTextCheckBox;
    private Button _blockCheckBox;
    private Button _columnsCheckBox;
    private Label _startColumnTextFieldLabel;
    private Text _startColumnTextField;
    private Label _endColumnTextFieldLabel;
    private Text _endColumnTextField;
    private Composite _findOptionsScrollPane;
    private static UUID _lpexWindowIdWithFocus;
    private static UUID _lpexWindowViewIdWithFocus;
    private static CommandStringList _commandList;
    private static CommandStringList _findList;
    private static CommandStringList _replaceList;
    private TraverseListener _traverseMnemonicListener;
    private BlockTypeResetter pendingBlockModeReset = new BlockTypeResetter();

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "commandLine.find";
        stringArray[2] = "commandLine.find";
        stringArray[3] = "commandLine.findMark";
        stringArray[5] = "commandLine.setParser";
        _labelTextIds = stringArray;
    }

    private static CommandStringList commandList() {
        if (_commandList == null) {
            _commandList = new CommandStringList();
            _commandList.load("commandList");
        }
        return _commandList;
    }

    private static CommandStringList findList() {
        if (_findList == null) {
            _findList = new CommandStringList();
            CommandLine._findList._current = new CommandString("");
        }
        return _findList;
    }

    private static CommandStringList replaceList() {
        if (_replaceList == null) {
            _replaceList = new CommandStringList();
        }
        return _replaceList;
    }

    CommandLine(LpexWindow lpexWindow) {
        super((Composite)lpexWindow, 0);
        this._lpexWindow = lpexWindow;
        Composite parent = this._lpexWindow.getParent();
        if (parent instanceof LpexMultiWindow) {
            this._lpexMultiWindow = (LpexMultiWindow)parent;
        }
        this.setLayout(new CommandLineLayout());
        this._mode = 0;
        this._savedText = new String[8];
        this._lpexWindow.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommandLine.this.handleDispose();
            }
        });
    }

    private void handleDispose() {
        if (_commandList != null) {
            _commandList.save("commandList");
        }
    }

    void localeChanged() {
        this.setMode(0);
        if (this._findOptionsScrollPane != null) {
            this._findOptionsScrollPane.dispose();
            this._findOptionsScrollPane = null;
        }
        if (this._replaceBox != null) {
            this._replaceBox.dispose();
            this._replaceBox = null;
        }
        if (this._findButtonsBox != null) {
            this._findButtonsBox.dispose();
            this._findButtonsBox = null;
        }
    }

    void doEnter() {
        this.commandEntry().doEnter();
    }

    Widget inputFocusWidget() {
        return this._inputFocusWidget;
    }

    private EditLine editLine() {
        if (this._editLine == null) {
            this._editLine = new EditLine(this);
        }
        return this._editLine;
    }

    private VisualEditLine visualEditLine() {
        if (this._visualEditLine == null) {
            this._visualEditLine = new VisualEditLine(this);
        }
        return this._visualEditLine;
    }

    private Label label() {
        if (this._label == null) {
            this._label = new Label((Composite)this, 0);
            this.listenToTraverseMnemonic((Control)this._label);
        }
        return this._label;
    }

    private CommandEntry commandEntry() {
        if (this._commandEntry == null) {
            this._commandEntry = new CommandEntry();
            this._commandEntry.getControl().addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 8 && CommandLine.this._endColumnTextField != null && CommandLine.this._endColumnTextField.isVisible()) {
                        CommandLine.this._endColumnTextField.setFocus();
                        event.doit = false;
                    }
                }
            });
        }
        return this._commandEntry;
    }

    private Button createButton(Composite parent, String msgId) {
        Button button = new Button(parent, 0x1000008);
        button.setText(LpexResources.message(msgId));
        button.addListener(1, (Listener)this);
        button.addSelectionListener((SelectionListener)this);
        button.addFocusListener((FocusListener)this);
        this.listenToTraverseMnemonic((Control)button);
        return button;
    }

    private Composite findButtonsBox() {
        if (this._findButtonsBox == null) {
            this._findButtonsBox = new Composite((Composite)this, 0);
            GridLayout gridLayout = new GridLayout();
            this._labelBorder = gridLayout.marginWidth;
            this._findButtonsBox.setLayout((Layout)gridLayout);
            gridLayout.numColumns = 3;
            gridLayout.marginHeight = 1;
            this._findButtonsBox.setLayoutData((Object)new GridData(784));
            this._findNextButton = this.createButton(this._findButtonsBox, "commandLine.next");
            this._findPrevButton = this.createButton(this._findButtonsBox, "commandLine.prev");
            this._findAllButton = this.createButton(this._findButtonsBox, "commandLine.all");
            this._findNextButton.setData("ID", (Object)"commandLine_findNext");
            this._findPrevButton.setData("ID", (Object)"commandLine_findPrev");
            this._findAllButton.setData("ID", (Object)"commandLine_findAll");
        }
        return this._findButtonsBox;
    }

    private Text replaceEntry() {
        this.replaceBox();
        return this._replaceEntry;
    }

    private Composite replaceBox() {
        if (this._replaceBox == null) {
            this._replaceBox = new Composite((Composite)this, 0);
            this._replaceLabel = new Label(this._replaceBox, 0);
            this._replaceLabel.setText(LpexResources.message("commandLine.replace"));
            this.listenToTraverseMnemonic((Control)this._replaceLabel);
            this._replaceEntry = new Text(this._replaceBox, 2052);
            this._replaceEntry.addListener(1, (Listener)this);
            this._replaceEntry.addFocusListener((FocusListener)this);
            this._replaceEntry.setData("ID", (Object)"commandLine_replace");
            this._replaceNextButton = this.createButton(this._replaceBox, "commandLine.replaceNext");
            this._replaceAllButton = this.createButton(this._replaceBox, "commandLine.replaceAll");
            this._replaceNextButton.setData("ID", (Object)"commandLine_replaceNext");
            this._replaceAllButton.setData("ID", (Object)"commandLine_replaceAll");
            this._replaceBox.setLayout((Layout)new ReplaceBoxLayout());
        }
        return this._replaceBox;
    }

    private Button createCheckBox(Composite parent, String msgId) {
        Button checkBox = new Button(parent, 0x1000020);
        checkBox.setText(LpexResources.message(msgId));
        checkBox.addListener(1, (Listener)this);
        checkBox.addFocusListener((FocusListener)this);
        checkBox.addSelectionListener((SelectionListener)this);
        this.listenToTraverseMnemonic((Control)checkBox);
        return checkBox;
    }

    private Button caseSensitiveCheckBox() {
        this.findOptionsScrollPane();
        return this._caseSensitiveCheckBox;
    }

    private Button wholeWordCheckBox() {
        this.findOptionsScrollPane();
        return this._wholeWordCheckBox;
    }

    private Button regularExpressionCheckBox() {
        this.findOptionsScrollPane();
        return this._regularExpressionCheckBox;
    }

    private Button wrapCheckBox() {
        this.findOptionsScrollPane();
        return this._wrapCheckBox;
    }

    private Button selectFoundTextCheckBox() {
        this.findOptionsScrollPane();
        return this._selectFoundTextCheckBox;
    }

    private Button blockCheckBox() {
        this.findOptionsScrollPane();
        return this._blockCheckBox;
    }

    private Button columnsCheckBox() {
        this.findOptionsScrollPane();
        return this._columnsCheckBox;
    }

    private Text startColumnTextField() {
        this.findOptionsScrollPane();
        return this._startColumnTextField;
    }

    private Text endColumnTextField() {
        this.findOptionsScrollPane();
        return this._endColumnTextField;
    }

    private Composite findOptionsScrollPane() {
        if (this._findOptionsScrollPane == null) {
            this._findOptionsScrollPane = new Group((Composite)this, 0);
            GridLayout gridLayout = new GridLayout();
            this._findOptionsScrollPane.setLayout((Layout)gridLayout);
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            this._findOptionsScrollPane.setLayoutData((Object)new GridData(32));
            Composite box = new Composite(this._findOptionsScrollPane, 0);
            GridLayout gridLayout1 = new GridLayout();
            box.setLayout((Layout)gridLayout1);
            gridLayout1.numColumns = 5;
            gridLayout1.marginHeight = 0;
            gridLayout1.marginWidth = 0;
            box.setLayoutData((Object)new GridData(48));
            this._caseSensitiveCheckBox = this.createCheckBox(box, "commandLine.caseSensitive");
            this._wholeWordCheckBox = this.createCheckBox(box, "commandLine.wholeWord");
            this._regularExpressionCheckBox = this.createCheckBox(box, "commandLine.regularExpression");
            this._wrapCheckBox = this.createCheckBox(box, "commandLine.wrap");
            this._selectFoundTextCheckBox = this.createCheckBox(box, "commandLine.selectFoundText");
            this._caseSensitiveCheckBox.setData("ID", (Object)"commandLine_findCase");
            this._wholeWordCheckBox.setData("ID", (Object)"commandLine_findWholeWord");
            this._regularExpressionCheckBox.setData("ID", (Object)"commandLine_findRegEx");
            this._wrapCheckBox.setData("ID", (Object)"commandLine_findWrap");
            this._selectFoundTextCheckBox.setData("ID", (Object)"commandLine_findSelect");
            Composite box1 = new Composite(this._findOptionsScrollPane, 0);
            GridLayout gridLayout2 = new GridLayout();
            box1.setLayout((Layout)gridLayout2);
            gridLayout2.numColumns = 6;
            gridLayout2.marginHeight = 0;
            gridLayout2.marginWidth = 0;
            box1.setLayoutData((Object)new GridData(48));
            this._blockCheckBox = this.createCheckBox(box1, "commandLine.restrictSearchToSelection");
            this._columnsCheckBox = this.createCheckBox(box1, "commandLine.restrictSearchToColumns");
            this._blockCheckBox.setData("ID", (Object)"commandLine_findInSelection");
            this._columnsCheckBox.setData("ID", (Object)"commandLine_findInColumns");
            this._startColumnTextFieldLabel = new Label(box1, 0);
            this._startColumnTextFieldLabel.setText(LpexResources.message("commandLine.startColumn"));
            this.listenToTraverseMnemonic((Control)this._startColumnTextFieldLabel);
            this._startColumnTextField = new Text(box1, 2052);
            this.setUpColumnField(this._startColumnTextField, "commandLine_findStartColumn");
            this._endColumnTextFieldLabel = new Label(box1, 0);
            this._endColumnTextFieldLabel.setText(LpexResources.message("commandLine.endColumn"));
            this.listenToTraverseMnemonic((Control)this._endColumnTextFieldLabel);
            this._endColumnTextField = new Text(box1, 2052);
            this.setUpColumnField(this._endColumnTextField, "commandLine_findEndColumn");
            this._endColumnTextField.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 16) {
                        CommandLine.this.commandEntry().requestFocus();
                        event.doit = false;
                    }
                }
            });
        }
        return this._findOptionsScrollPane;
    }

    private void enableStartEndColumns() {
        if (this._columnsCheckBox != null) {
            boolean columns = this._columnsCheckBox.getSelection();
            this._startColumnTextFieldLabel.setEnabled(columns);
            this._startColumnTextField.setEnabled(columns);
            this._endColumnTextFieldLabel.setEnabled(columns);
            this._endColumnTextField.setEnabled(columns);
            this._findOptionsScrollPane.update();
        }
    }

    private void setUpColumnField(Text columnField, String id) {
        columnField.setTextLimit(3);
        GC gc = new GC((Drawable)columnField);
        int widthHint = 3 * gc.textExtent((String)"9").x;
        gc.dispose();
        GridData gd = new GridData();
        gd.widthHint = widthHint;
        columnField.setLayoutData((Object)gd);
        columnField.addListener(1, (Listener)this);
        columnField.addModifyListener((ModifyListener)this);
        columnField.addFocusListener((FocusListener)this);
        columnField.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                int i = 0;
                while (i < e.text.length()) {
                    char c = e.text.charAt(i);
                    if (c < '0' || c > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        columnField.setData("ID", (Object)id);
    }

    boolean forceVisible() {
        return this._forceVisible;
    }

    void setForceVisible(boolean forceVisible) {
        this._forceVisible = forceVisible;
        if (forceVisible && !this.isVisible()) {
            this.setVisible(true);
            this._lpexWindow.layout();
            this._lpexWindow.getParent().getParent().layout(true);
        }
        if (!forceVisible && this.isVisible()) {
            this.resetBlockType(this._lpexWindow.getLpexView());
        }
    }

    int getMode() {
        return this._mode;
    }

    void setMode(int mode) {
        String parser;
        if (mode >= 8 || mode < 0) {
            return;
        }
        if (this._inputView == null && mode == 4) {
            mode = 0;
        }
        if ((mode == 1 || mode == 2) && this._lpexWindow.getLpexView() != null) {
            this._lpexWindow.getLpexView()._view.preserveFindPosition();
        }
        if (this._mode == mode) {
            return;
        }
        String text = this.commandEntry().getText();
        if (this._mode == 1 || this._mode == 2) {
            String replaceText;
            if (text.length() > 0 && CommandLine.findList()._current == null) {
                CommandLine.findList().add(text);
                CommandLine.findList()._current = (CommandString)CommandLine.findList().first();
            }
            if (!(this._mode != 2 || (replaceText = this.replaceEntry().getText()).length() <= 0 || CommandLine.replaceList()._current != null && CommandLine.replaceList()._current.commandString().equals(replaceText))) {
                CommandLine.replaceList().add(replaceText);
                CommandLine.replaceList()._current = (CommandString)CommandLine.replaceList().first();
            }
        } else if (this._mode != 0) {
            this._savedText[this._mode] = text;
        }
        this._mode = mode;
        String labelText = "";
        if (this._mode == 4) {
            if (this._inputLabelText != null) {
                labelText = this._inputLabelText;
            }
        } else {
            String labelTextId = _labelTextIds[this._mode];
            if (labelTextId != null) {
                labelText = LpexResources.message(labelTextId);
            }
        }
        this.label().setText(labelText);
        if (this._mode == 1 || this._mode == 2) {
            this.commandEntry().loadFindCombo();
        } else {
            this.commandEntry().loadCommandLineCombo();
        }
        if (this._savedText[this._mode] != null) {
            this.commandEntry().changeText(this._savedText[this._mode]);
            this._savedText[this._mode] = null;
        } else if (this._mode == 1 || this._mode == 2) {
            this.setFindOptions();
        } else {
            this.commandEntry().changeText("");
        }
        if (this._mode == 5 && this._lpexWindow.getLpexView() != null && (parser = this._lpexWindow.getLpexView()._view.parsePendingList().parser()) != null && parser.length() > 0) {
            this.commandEntry().changeText(parser);
        }
        if (this._mode == 6) {
            this.editLine().setEditLine();
        } else if (this._mode == 7) {
            this.visualEditLine().setEditLine();
        } else {
            String id = null;
            switch (this._mode) {
                case 0: {
                    id = "commandLine";
                    break;
                }
                case 1: 
                case 2: {
                    id = "commandLine_find";
                    break;
                }
                case 3: {
                    id = "commandLine_findMark";
                    break;
                }
                case 4: {
                    id = "commandLine_input";
                    break;
                }
                case 5: {
                    id = "commandLine_setParser";
                    break;
                }
            }
            this.commandEntry().getControl().setData("ID", (Object)id);
            this.commandEntry().selectAll();
        }
        this.layout();
        this._lpexWindow.layout();
        this._lpexWindow.getParent().getParent().layout(true);
    }

    void setInput(View view, String labelText, String text, String command) {
        this._inputView = view;
        this._inputLabelText = labelText;
        this._inputCommand = command;
        this._inputText = text != null ? text.split("\u0000") : new String[1];
        this._inputTextIndex = 0;
        this._savedText[4] = this._inputText[0];
        if (this._mode == 4) {
            if (this._inputView == null) {
                this.setMode(0);
            } else {
                this.label().setText(this._inputLabelText != null ? this._inputLabelText : "");
                this.commandEntry().changeText(this._inputText[0]);
                this._savedText[4] = null;
            }
            this.layout();
            this._lpexWindow.layout();
            this._lpexWindow.getParent().getParent().layout(true);
        }
    }

    void setCommandText(String commandText) {
        if (this._mode == 0) {
            if (commandText == null) {
                commandText = "";
            }
            this.commandEntry().changeText(commandText);
            this.commandEntry().select(commandText.length(), commandText.length());
        } else {
            this._savedText[0] = commandText;
        }
    }

    public void requestFocus() {
        if (this._mode != 6 && this._mode != 7) {
            this.commandEntry().requestFocus();
        }
        if (this._mode == 0 && LpexUtilities.isBidi()) {
            LpexUtilities.setKeyboardLanguage(0);
        }
    }

    public void handleEvent(Event e) {
        if (e.character == '\u001b') {
            this._lpexWindow.textWindowRequestFocus();
            return;
        }
        if (e.widget == this._replaceEntry && (e.keyCode == 0x1000001 || e.keyCode == 0x1000002)) {
            CommandStringList list = CommandLine.replaceList();
            String text = this._replaceEntry.getText();
            if (text.length() > 0 && list._current != null && !list._current.commandString().equals(text)) {
                list._current = null;
            }
            if (text.length() > 0 && list._current == null) {
                list.add(text);
                list._current = (CommandString)list.first();
            }
            if (e.keyCode == 0x1000001) {
                if (list._current == null) {
                    list._current = (CommandString)list.first();
                } else if (text.equals(list._current.commandString()) && list._current.next() != null) {
                    list._current = (CommandString)list._current.next();
                }
            } else if (list._current != null && list._current.prev() != null) {
                list._current = (CommandString)list._current.prev();
            }
            if (list._current != null) {
                String newText = list._current.commandString();
                this._replaceEntry.setText(newText);
                e.doit = false;
            }
            return;
        }
        if (this._lpexWindow.getLpexView() != null) {
            this._lpexWindow.getLpexView()._view.actionHandler().doKeyEvent(e);
        }
    }

    private void setFindOptions() {
        View view = this._lpexWindow.getLpexView()._view;
        boolean asis = FindTextCommand.asisParameter().currentValue(view);
        boolean wholeWord = FindTextCommand.wholeWordParameter().currentValue(view);
        boolean regularExpression = FindTextCommand.regularExpressionParameter().currentValue(view);
        boolean wrap = FindTextCommand.wrapParameter().currentValue(view);
        boolean mark = FindTextCommand.markParameter().currentValue(view);
        boolean columns = FindTextCommand.columnsParameter().currentValue(view);
        boolean incremental = FindTextCommand.incrementalParameter().currentValue(view);
        int startColumn = FindTextCommand.startColumnParameter().currentValue(view);
        int endColumn = FindTextCommand.endColumnParameter().currentValue(view);
        String replaceText = FindTextCommand.replaceTextParameter().currentValue(view);
        String findText = "";
        if (this._lpexWindow.getLpexView().queryOn("block.inView")) {
            findText = this._lpexWindow.getLpexView()._view.block().selectedText();
        }
        Element start = this._lpexWindow.getLpexView()._view.block().topElement();
        Element end = this._lpexWindow.getLpexView()._view.block().bottomElement();
        boolean multiLineSelection = false;
        if (start == null || end == null || start.equals(end)) {
            if (findText == null || findText.length() == 0) {
                findText = FindTextCommand.findTextParameter().currentValue(view);
            } else {
                incremental = false;
            }
        } else {
            incremental = false;
            multiLineSelection = true;
            if (findText == null || findText.length() == 0) {
                findText = FindTextCommand.findTextParameter().currentValue(view);
            } else {
                int index = -1;
                index = findText.indexOf("\r\n");
                if (index == -1) {
                    index = findText.indexOf("\n");
                }
                findText = findText.substring(0, index);
            }
        }
        this.findButtonsBox();
        this.replaceBox();
        this._ignoreItemStateChanged = true;
        this.caseSensitiveCheckBox().setSelection(asis);
        this.wholeWordCheckBox().setSelection(wholeWord);
        this.regularExpressionCheckBox().setSelection(regularExpression);
        this.wrapCheckBox().setSelection(wrap);
        this.selectFoundTextCheckBox().setSelection(mark);
        if (multiLineSelection && start != null && start.getDocument() == view.document()) {
            this.blockCheckBox().setSelection(true);
        } else {
            this.blockCheckBox().setSelection(false);
        }
        this.columnsCheckBox().setSelection(columns);
        this.startColumnTextField().setText(String.valueOf(startColumn));
        this.endColumnTextField().setText(String.valueOf(endColumn));
        this.enableStartEndColumns();
        this._ignoreItemStateChanged = false;
        if (this._mode == 2) {
            this.replaceEntry().setText(replaceText != null ? replaceText : "");
        }
        if (incremental) {
            this.commandEntry().changeText(findText);
        } else {
            this.commandEntry().changeText(findText, false);
        }
    }

    private boolean setFindText() {
        View view = this._lpexWindow.getLpexView()._view;
        String findText = this.commandEntry().getText();
        FindTextCommand.FindTextParameter findTextParameter = FindTextCommand.findTextParameter();
        findTextParameter.setValue(view, findText);
        findTextParameter.setDefaultValue(findText);
        if (findText.length() == 0) {
            return false;
        }
        boolean asis = this.caseSensitiveCheckBox().getSelection();
        FindTextCommand.asisParameter().setValue(view, asis ? 1 : 0);
        boolean wholeWord = this.wholeWordCheckBox().getSelection();
        FindTextCommand.wholeWordParameter().setValue(view, wholeWord ? 1 : 0);
        boolean regularExpression = this.regularExpressionCheckBox().getSelection();
        FindTextCommand.RegularExpressionParameter regularExpressionParameter = FindTextCommand.regularExpressionParameter();
        regularExpressionParameter.setValue(view, regularExpression ? 1 : 0);
        regularExpressionParameter.setDefaultValue(regularExpression ? 1 : 0);
        boolean wrap = this.wrapCheckBox().getSelection();
        FindTextCommand.wrapParameter().setValue(view, wrap ? 1 : 0);
        boolean mark = this.selectFoundTextCheckBox().getSelection();
        FindTextCommand.markParameter().setValue(view, mark ? 1 : 0);
        boolean block = this.blockCheckBox().getSelection();
        FindTextCommand.blockParameter().setValue(view, block ? 1 : 0);
        boolean columns = this.columnsCheckBox().getSelection();
        FindTextCommand.columnsParameter().setValue(view, columns ? 1 : 0);
        int startColumn = 1;
        try {
            startColumn = Integer.parseInt(this.startColumnTextField().getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        FindTextCommand.startColumnParameter().setValue(view, startColumn, false);
        int endColumn = 80;
        try {
            endColumn = Integer.parseInt(this.endColumnTextField().getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        FindTextCommand.endColumnParameter().setValue(view, endColumn, false);
        if (this._mode == 2) {
            String replaceText = this.replaceEntry().getText();
            FindTextCommand.replaceTextParameter().setValue(view, replaceText);
            FindTextCommand.replaceTextParameter().setDefaultValue(replaceText);
        }
        return true;
    }

    private void findText(String findCommandOptions) {
        View view = this._lpexWindow.getLpexView()._view;
        if (view != null && this.setFindText()) {
            view.beginUserAction();
            StringBuffer commandString = new StringBuffer(1024);
            commandString.append("findText " + findCommandOptions);
            if (commandString.charAt(commandString.length() - 1) != ' ') {
                commandString.append(" ");
            }
            commandString.append("uiMode");
            view.commandHandler().doCommand(commandString.toString());
            CommandLine.findList().add(this.commandEntry().getText());
            CommandLine.findList()._current = (CommandString)CommandLine.findList().first();
            view.preserveFindPosition();
            view.endUserAction();
            Document.screenShow();
            String srchText = this.commandEntry().getText();
            if (this._mode == 1 || this._mode == 2) {
                this.commandEntry().loadFindCombo();
            } else {
                this.commandEntry().loadCommandLineCombo();
            }
            this.commandEntry().setTextWithoutNotify(srchText);
            Control c = this.commandEntry().getControl();
            if (c instanceof Combo) {
                Combo combo = (Combo)c;
                combo.setFocus();
                combo.setSelection(new Point(srchText.length(), srchText.length()));
            }
        }
    }

    private void liveFindText() {
        View view = this._lpexWindow.getLpexView()._view;
        if (view != null) {
            if (!FindTextCommand.incrementalParameter().currentValue(view)) {
                return;
            }
            view.beginUserAction();
            view.restoreFindPosition();
            if (this.setFindText()) {
                view.commandHandler().doCommand("findText checkStart noBeep uiMode");
            } else {
                view.documentPosition().setEmphasisLength(0);
            }
            view.endUserAction();
            Document.screenShow();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.actionPerformed(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.actionPerformed(e);
    }

    private void actionPerformed(SelectionEvent e) {
        if (e.widget == this._findNextButton) {
            this.findText("");
        } else if (e.widget == this._findPrevButton) {
            this.findText("up");
        } else if (e.widget == this._findAllButton) {
            this.findText("all");
        } else if (e.widget == this._replaceNextButton) {
            this.findText("checkStart replace");
        } else if (e.widget == this._replaceAllButton) {
            this.findText("replace all");
        } else if (!this._ignoreItemStateChanged) {
            if (e.widget == this._columnsCheckBox) {
                this.enableStartEndColumns();
            }
            this.liveFindText();
        }
    }

    public void modifyText(ModifyEvent e) {
        if (!this._ignoreItemStateChanged && this.columnsCheckBox().getSelection()) {
            this.liveFindText();
        }
    }

    public void focusGained(FocusEvent e) {
        this._inputFocusWidget = e.widget;
        _lpexWindowIdWithFocus = this._lpexWindow.getLpexWindowId();
        LpexView aView = this._lpexWindow.getLpexView();
        if (aView != null) {
            _lpexWindowViewIdWithFocus = aView.getLpexViewId();
        } else {
            _lpexWindowIdWithFocus = null;
            _lpexWindowViewIdWithFocus = null;
        }
        this._lpexWindow.setFocusWidget(this._inputFocusWidget);
        this.notifyListeners(15, this._focusEvent);
    }

    public void focusLost(FocusEvent e) {
        try {
            this._inputFocusWidget = null;
            this._lpexWindow.setFocusWidget(null);
            this.notifyListeners(16, this._focusEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void listenToTraverseMnemonic(Control control) {
        if (this._lpexMultiWindow != null) {
            if (this._traverseMnemonicListener == null) {
                this._traverseMnemonicListener = new TraverseListener(){

                    public void keyTraversed(TraverseEvent event) {
                        if (event.detail == 128) {
                            CommandLine.this.handleTraverseMnemonic(event);
                        }
                    }
                };
            }
            control.addTraverseListener(this._traverseMnemonicListener);
        }
    }

    private void handleTraverseMnemonic(TraverseEvent e) {
        if (e.doit) {
            Composite eventParent = ((Control)e.widget).getParent();
            while (eventParent != null && !(eventParent instanceof LpexWindow)) {
                eventParent = eventParent.getParent();
            }
            LpexWindow anLpexWindow = null;
            LpexView aView = null;
            if (eventParent != null && eventParent instanceof LpexWindow) {
                anLpexWindow = (LpexWindow)eventParent;
            }
            if (anLpexWindow != null) {
                aView = anLpexWindow.getLpexView();
            }
            if (!(anLpexWindow == null || aView == null || _lpexWindowIdWithFocus != null && _lpexWindowIdWithFocus == anLpexWindow.getLpexWindowId() || _lpexWindowViewIdWithFocus != null && _lpexWindowViewIdWithFocus == aView.getLpexViewId())) {
                e.doit = false;
                return;
            }
        }
    }

    public void setBlockTypeToCharacter(LpexView view) {
        this.pendingBlockModeReset.setBlockTypeToCharacter(view);
    }

    public void resetBlockType(LpexView view) {
        this.pendingBlockModeReset.resetBlockTypeToStream(view);
    }

    final class CommandEntry
    implements Listener,
    ModifyListener,
    SelectionListener {
        private Combo _text;

        CommandEntry() {
            this._text = new Combo((Composite)CommandLine.this, 2052);
            this._text.addListener(1, (Listener)this);
            this._text.addListener(1, (Listener)CommandLine.this);
            this._text.addSelectionListener((SelectionListener)this);
            this._text.addModifyListener((ModifyListener)this);
            this._text.addFocusListener((FocusListener)CommandLine.this);
            this._text.setData("ID", (Object)"commandLine");
            this.loadCommandLineCombo();
            this.initAccessible();
        }

        private void loadCommandLineCombo() {
            this._text.removeAll();
            CommandString item = (CommandString)CommandLine.commandList().first();
            ArrayList<String> alreadyAdded = new ArrayList<String>();
            while (item != null) {
                String itemString = item.commandString();
                boolean alreadyPresent = false;
                for (String s : alreadyAdded) {
                    if (!itemString.equals(s)) continue;
                    alreadyPresent = true;
                    break;
                }
                if (!alreadyPresent) {
                    alreadyAdded.add(itemString);
                    this._text.add(itemString);
                }
                item = (CommandString)item.next();
            }
        }

        private void loadFindCombo() {
            CommandString item = (CommandString)CommandLine.findList().first();
            this._text.removeModifyListener((ModifyListener)this);
            this._text.removeSelectionListener((SelectionListener)this);
            this._text.removeAll();
            this._text.addModifyListener((ModifyListener)this);
            this._text.addSelectionListener((SelectionListener)this);
            ArrayList<String> alreadyAdded = new ArrayList<String>();
            while (item != null) {
                String itemString = item.commandString();
                boolean alreadyPresent = false;
                for (String s : alreadyAdded) {
                    if (!itemString.equals(s)) continue;
                    alreadyPresent = true;
                    break;
                }
                if (!alreadyPresent) {
                    alreadyAdded.add(itemString);
                    this._text.add(itemString);
                }
                item = (CommandString)item.next();
            }
        }

        private void initAccessible() {
            this._text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = ((CommandEntry)CommandEntry.this).CommandLine.this._mode == 0 ? LpexResources.message("accessible.nameCommandLine") : null;
                }

                public void getHelp(AccessibleEvent e) {
                    e.result = ((CommandEntry)CommandEntry.this).CommandLine.this._mode == 0 ? LpexResources.message("accessible.descCommandEntry") : (((CommandEntry)CommandEntry.this).CommandLine.this._mode == 1 ? LpexResources.message("accessible.descFind") : (((CommandEntry)CommandEntry.this).CommandLine.this._mode == 2 ? LpexResources.message("accessible.descFindAndReplace") : (((CommandEntry)CommandEntry.this).CommandLine.this._mode == 4 ? LpexResources.message("accessible.descInput") : null)));
                }

                public void getKeyboardShortcut(AccessibleEvent e) {
                    String shortcut;
                    LpexView lpexView = ((CommandEntry)CommandEntry.this).CommandLine.this._lpexWindow.getLpexView();
                    if (lpexView != null && ((CommandEntry)CommandEntry.this).CommandLine.this._mode == 0 && (shortcut = lpexView.actionKeyText(69)) != null) {
                        e.result = shortcut;
                    }
                }
            });
        }

        Control getControl() {
            return this._text;
        }

        String getText() {
            return this._text.getText();
        }

        void setText(String t) {
            this._text.setText(t != null ? t : "");
        }

        void setTextWithoutNotify(String t) {
            this._text.removeModifyListener((ModifyListener)this);
            this._text.removeSelectionListener((SelectionListener)this);
            this.setText(t);
            this._text.addModifyListener((ModifyListener)this);
            this._text.addSelectionListener((SelectionListener)this);
        }

        void select(int start, int end) {
            this._text.setSelection(new Point(start, end));
        }

        void selectAll() {
            this._text.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CommandEntry.this._text.isDisposed()) {
                        CommandEntry.this._text.setSelection(new Point(0, CommandEntry.this._text.getText().length()));
                    }
                }
            });
        }

        void requestFocus() {
            this._text.setFocus();
        }

        Point computeSize(int wHint, int hHint, boolean changed) {
            return this._text.computeSize(wHint, hHint, changed);
        }

        Point computeSize(int wHint, int hHint) {
            return this._text.computeSize(wHint, hHint);
        }

        void setBounds(int x, int y, int width, int height) {
            this._text.setBounds(x, y, width, height);
        }

        void setVisible(boolean visible) {
            this._text.setVisible(visible);
        }

        public void handleEvent(Event e) {
            if (e.character == '\r') {
                this.doEnter();
                if (CommandLine.this._mode == 0) {
                    e.doit = false;
                }
            } else if ((e.keyCode == 0x1000001 || e.keyCode == 0x1000002) && CommandLine.this._lpexWindow.getLpexView() != null) {
                View view = CommandLine.this._lpexWindow.getLpexView()._view;
                if (CommandLine.this._mode == 0 && !view.vi() || CommandLine.this._mode == 1 || CommandLine.this._mode == 2) {
                    CommandStringList list = CommandLine.this._mode == 0 ? CommandLine.commandList() : CommandLine.findList();
                    String text = this.getText();
                    if ((CommandLine.this._mode == 1 || CommandLine.this._mode == 2) && text.length() > 0 && CommandLine.findList()._current == null) {
                        CommandLine.findList().add(text);
                        CommandLine.findList()._current = (CommandString)CommandLine.findList().first();
                    }
                    if (e.keyCode == 0x1000001) {
                        String commandString = this.getText();
                        if (list._current == null) {
                            list._current = (CommandString)list.first();
                        } else if (commandString.equals(list._current.commandString()) && list._current.next() != null) {
                            list._current = (CommandString)list._current.next();
                        }
                    } else if (list._current != null && list._current.prev() != null) {
                        list._current = (CommandString)list._current.prev();
                    }
                    if (list._current != null) {
                        if (CommandLine.this._mode != 0 || e.doit) {
                            this.changeText(list._current.commandString());
                            this.selectAll();
                        }
                        if (CommandLine.this._mode == 0) {
                            e.doit = false;
                        }
                    }
                } else if (CommandLine.this._mode == 3) {
                    String markName = this.getText();
                    MarkList.Mark mark = null;
                    if (markName.length() > 0) {
                        mark = view.markList().find(markName);
                    }
                    if (e.keyCode == 0x1000001) {
                        mark = mark == null ? view.markList().firstNamed() : view.markList().nextNamed(mark);
                    } else if (mark != null) {
                        mark = view.markList().prevNamed(mark);
                    }
                    if (mark != null) {
                        this.changeText(mark.name());
                    }
                } else if (CommandLine.this._mode == 4) {
                    int inputTextIndex = CommandLine.this._inputTextIndex;
                    inputTextIndex = e.keyCode == 0x1000001 ? --inputTextIndex : ++inputTextIndex;
                    if (inputTextIndex < 0) {
                        inputTextIndex = 0;
                    } else if (inputTextIndex >= CommandLine.this._inputText.length) {
                        inputTextIndex = CommandLine.this._inputText.length - 1;
                    }
                    if (inputTextIndex != CommandLine.this._inputTextIndex) {
                        CommandLine.this._inputTextIndex = inputTextIndex;
                        this.changeText(CommandLine.this._inputText[CommandLine.this._inputTextIndex]);
                    }
                    this.selectAll();
                } else if (CommandLine.this._mode == 5) {
                    String parserName = this.getText();
                    String parsers = UpdateProfileCommand.ParsersParameter.getParameter().queryCurrent(view, null);
                    if (parsers != null) {
                        LpexStringTokenizer st = new LpexStringTokenizer(parsers);
                        String previousParser = null;
                        String nextParser = null;
                        while (st.hasMoreTokens()) {
                            String parser = st.nextToken();
                            if (parser.equals(parserName)) {
                                if (!st.hasMoreTokens()) break;
                                nextParser = st.nextToken();
                                break;
                            }
                            previousParser = parser;
                        }
                        if ((parserName = e.keyCode == 0x1000001 ? previousParser : nextParser) != null) {
                            this.changeText(parserName);
                            this.selectAll();
                        }
                    }
                }
            }
        }

        void doEnter() {
            if (CommandLine.this._mode == 1 || CommandLine.this._mode == 2) {
                CommandLine.this.findText("");
            } else if (CommandLine.this._lpexWindow.getLpexView() != null) {
                View view = CommandLine.this._lpexWindow.getLpexView()._view;
                String commandString = this.getText();
                if (commandString.length() > 0 || CommandLine.this._mode == 0 && !view.vi() || CommandLine.this._mode == 5) {
                    view.beginUserAction();
                    switch (CommandLine.this._mode) {
                        case 0: {
                            if (view.vi()) {
                                view.viHandler().doCommand(commandString);
                                this.updateCombo(commandString);
                                if (this._text.isDisposed()) break;
                                this.changeText("");
                                CommandLine.this._lpexWindow.textWindowRequestFocus();
                                break;
                            }
                            if (commandString.trim().length() == 0) {
                                view.screen().setMessageText(null);
                                if (commandString.length() == 0) break;
                                this.changeText("");
                                break;
                            }
                            if (view.commandHandler().doCommand(commandString)) {
                                if (CommandLine.commandList()._current == null) {
                                    CommandLine.commandList().add(commandString);
                                }
                                if (CommandLine.this._mode == 0 && !commandString.toLowerCase().startsWith("findtext")) {
                                    this.changeText("");
                                }
                                this.updateCombo(commandString);
                                break;
                            }
                            this.selectAll();
                            break;
                        }
                        case 3: {
                            LocateCommand.doCommand(view, "emphasis mark " + commandString);
                            if (CommandHandler.getStatus() == null) {
                                CommandLine.this._lpexWindow.textWindowRequestFocus();
                                break;
                            }
                            this.selectAll();
                            break;
                        }
                        case 5: {
                            UpdateProfileCommand.ParserParameter.getParameter().setValue(view, commandString);
                            UpdateProfileCommand.doCommand(view, "");
                            CommandLine.this._lpexWindow.textWindowRequestFocus();
                            break;
                        }
                        case 4: {
                            if (CommandLine.this._inputView == null || CommandLine.this._inputView.commandHandler().doCommand(CommandLine.this._inputCommand + commandString) && CommandHandler.getStatus() == null) {
                                CommandLine.this._lpexWindow.textWindowRequestFocus();
                                break;
                            }
                            this.selectAll();
                            break;
                        }
                    }
                    view.endUserAction();
                    Document.screenShow();
                }
            }
        }

        private void updateCombo(String commandString) {
            this._text.add(commandString, 0);
        }

        public void modifyText(ModifyEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            if (CommandLine.this._lpexWindow.getLpexView() != null && (CommandLine.this._mode == 0 || CommandLine.this._mode == 1 || CommandLine.this._mode == 2)) {
                CommandStringList list;
                String text = this.getText();
                CommandStringList commandStringList = list = CommandLine.this._mode == 0 ? CommandLine.commandList() : CommandLine.findList();
                if (text.length() > 0 && list._current != null && !list._current.commandString().equals(text)) {
                    list._current = null;
                }
                if (CommandLine.this._mode == 1 || CommandLine.this._mode == 2) {
                    CommandLine.this.liveFindText();
                }
            }
        }

        private void changeText(String newText) {
            this.changeText(newText, true);
        }

        private void changeText(String newText, boolean notify) {
            if (!this._text.isDisposed()) {
                this._text.removeModifyListener((ModifyListener)this);
                this._text.removeSelectionListener((SelectionListener)this);
                this.setText(newText);
                this._text.addModifyListener((ModifyListener)this);
                this._text.addSelectionListener((SelectionListener)this);
                if (notify) {
                    this.textChanged();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (CommandLine.this._mode != 1 && CommandLine.this._mode != 2) {
                this.doEnter();
            }
        }
    }

    final class CommandLineLayout
    extends Layout {
        CommandLineLayout() {
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean flushCache) {
            if (CommandLine.this._mode == 6) {
                return CommandLine.this.editLine().computeSize(-1, -1, flushCache);
            }
            if (CommandLine.this._mode == 7) {
                return CommandLine.this.visualEditLine().computeSize(-1, -1, flushCache);
            }
            Point labelPreferredSize = CommandLine.this.label().computeSize(-1, -1, flushCache);
            Point commandEntryPreferredSize = CommandLine.this.commandEntry().computeSize(-1, -1, flushCache);
            int height = labelPreferredSize.y > commandEntryPreferredSize.y ? labelPreferredSize.y : commandEntryPreferredSize.y;
            int width = labelPreferredSize.x + CommandLine.this._labelBorder * 2 + commandEntryPreferredSize.x;
            if (CommandLine.this._mode == 1 || CommandLine.this._mode == 2) {
                Point buttonsPreferredSize = CommandLine.this.findButtonsBox().computeSize(-1, -1, flushCache);
                if (buttonsPreferredSize.y > height) {
                    height = buttonsPreferredSize.y;
                }
                Point findOptionsScrollPanePreferredSize = CommandLine.this.findOptionsScrollPane().computeSize(-1, -1, flushCache);
                height += findOptionsScrollPanePreferredSize.y;
                if (findOptionsScrollPanePreferredSize.x > (width += buttonsPreferredSize.x)) {
                    width = findOptionsScrollPanePreferredSize.x;
                }
                if (CommandLine.this._mode == 2) {
                    Point replaceBoxPreferredSize = CommandLine.this.replaceBox().computeSize(-1, -1, flushCache);
                    height += replaceBoxPreferredSize.y;
                    if (replaceBoxPreferredSize.x > width) {
                        width = replaceBoxPreferredSize.x;
                    }
                }
            }
            return new Point(width, height);
        }

        protected void layout(Composite parent, boolean flushCache) {
            int findButtonsWidth;
            Rectangle parentRect = parent.getClientArea();
            if (CommandLine.this._mode == 6 || CommandLine.this._mode == 7) {
                if (CommandLine.this._label != null) {
                    CommandLine.this._label.setVisible(false);
                }
                if (CommandLine.this._commandEntry != null) {
                    CommandLine.this._commandEntry.setVisible(false);
                }
                if (CommandLine.this._findButtonsBox != null) {
                    CommandLine.this._findButtonsBox.setVisible(false);
                }
                if (CommandLine.this._replaceBox != null) {
                    CommandLine.this._replaceBox.setVisible(false);
                }
                if (CommandLine.this._findOptionsScrollPane != null) {
                    CommandLine.this._findOptionsScrollPane.setVisible(false);
                }
                if (CommandLine.this._mode == 6) {
                    CommandLine.this.editLine().setVisible(true);
                    CommandLine.this.editLine().setBounds(0, 0, parentRect.width, parentRect.height);
                } else {
                    CommandLine.this.visualEditLine().setVisible(true);
                    CommandLine.this.visualEditLine().setBounds(0, 0, parentRect.width, parentRect.height);
                }
                return;
            }
            if (CommandLine.this._editLine != null) {
                CommandLine.this._editLine.setVisible(false);
            }
            if (CommandLine.this._visualEditLine != null) {
                CommandLine.this._visualEditLine.setVisible(false);
            }
            if (CommandLine.this._label != null) {
                CommandLine.this._label.setVisible(true);
            }
            Point labelSize = CommandLine.this.label().computeSize(-1, -1);
            int labelBorder = CommandLine.this._labelBorder;
            if (CommandLine.this.label().getText().length() == 0) {
                labelSize.x = 0;
                labelBorder = 0;
            }
            CommandLine.this.commandEntry().setVisible(true);
            int commandEntryHeight = CommandLine.this._commandEntry.computeSize((int)-1, (int)-1).y;
            int commandRowHeight = labelSize.y > commandEntryHeight ? labelSize.y : commandEntryHeight;
            int replaceRowHeight = 0;
            int findOptionsRowHeight = 0;
            if (CommandLine.this._mode == 1 || CommandLine.this._mode == 2) {
                Point findButtonsSize = CommandLine.this.findButtonsBox().computeSize(-1, -1);
                if (commandRowHeight < findButtonsSize.y) {
                    commandRowHeight = findButtonsSize.y;
                }
                findButtonsWidth = findButtonsSize.x;
                CommandLine.this.findButtonsBox().setVisible(true);
                if (CommandLine.this._mode == 2) {
                    replaceRowHeight = CommandLine.this.replaceBox().computeSize((int)-1, (int)-1).y;
                    CommandLine.this.replaceBox().setVisible(true);
                } else if (CommandLine.this._replaceBox != null) {
                    CommandLine.this._replaceBox.setVisible(false);
                }
                findOptionsRowHeight = CommandLine.this.findOptionsScrollPane().computeSize((int)-1, (int)-1).y;
                CommandLine.this.findOptionsScrollPane().setVisible(true);
            } else {
                findButtonsWidth = 0;
                if (CommandLine.this._findButtonsBox != null) {
                    CommandLine.this._findButtonsBox.setVisible(false);
                }
                if (CommandLine.this._replaceBox != null) {
                    CommandLine.this._replaceBox.setVisible(false);
                }
                if (CommandLine.this._findOptionsScrollPane != null) {
                    CommandLine.this._findOptionsScrollPane.setVisible(false);
                }
            }
            int commandEntryWidth = parentRect.width - labelBorder * 2 - labelSize.x - findButtonsWidth;
            if (commandEntryWidth < 0) {
                commandEntryWidth = 0;
            }
            CommandLine.this.label().setBounds(labelBorder, (commandRowHeight - labelSize.y) / 2, labelSize.x, commandRowHeight);
            CommandLine.this.commandEntry().setBounds(labelBorder * 2 + labelSize.x, (commandRowHeight - commandEntryHeight) / 2, commandEntryWidth, commandEntryHeight);
            if (CommandLine.this._findButtonsBox != null) {
                CommandLine.this._findButtonsBox.setBounds(labelBorder * 2 + labelSize.x + commandEntryWidth, 0, findButtonsWidth, commandRowHeight);
            }
            if (CommandLine.this._replaceBox != null) {
                CommandLine.this._replaceBox.setBounds(0, commandRowHeight, parentRect.width, replaceRowHeight);
            }
            if (CommandLine.this._findOptionsScrollPane != null) {
                CommandLine.this._findOptionsScrollPane.setBounds(0, commandRowHeight + replaceRowHeight, parentRect.width, findOptionsRowHeight);
            }
        }
    }

    final class ReplaceBoxLayout
    extends Layout {
        ReplaceBoxLayout() {
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean flushCache) {
            int spacing = 5;
            Point labelPreferredSize = CommandLine.this._replaceLabel.computeSize(-1, -1, flushCache);
            Point replaceEntryPreferredSize = CommandLine.this._replaceEntry.computeSize(-1, -1, flushCache);
            int height = labelPreferredSize.y > replaceEntryPreferredSize.y ? labelPreferredSize.y : replaceEntryPreferredSize.y;
            int width = labelPreferredSize.x + CommandLine.this._labelBorder * 2 + replaceEntryPreferredSize.x;
            Point replaceNextButtonPreferredSize = CommandLine.this._replaceNextButton.computeSize(-1, -1, flushCache);
            if (replaceNextButtonPreferredSize.y > height) {
                height = replaceNextButtonPreferredSize.y;
            }
            Point replaceAllButtonPreferredSize = CommandLine.this._replaceAllButton.computeSize(-1, -1, flushCache);
            if (replaceAllButtonPreferredSize.y > height) {
                height = replaceAllButtonPreferredSize.y;
            }
            return new Point(width += replaceNextButtonPreferredSize.x + replaceAllButtonPreferredSize.x + spacing * 3, height);
        }

        protected void layout(Composite parent, boolean flushCache) {
            int spacing = 5;
            Point labelSize = CommandLine.this._replaceLabel.computeSize(-1, -1);
            int replaceEntryHeight = CommandLine.this._replaceEntry.computeSize((int)-1, (int)-1).y;
            Rectangle parentRect = parent.getClientArea();
            int replaceRowHeight = labelSize.y > replaceEntryHeight ? labelSize.y : replaceEntryHeight;
            Point replaceNextButtonSize = CommandLine.this._replaceNextButton.computeSize(-1, -1);
            if (replaceRowHeight < replaceNextButtonSize.y) {
                replaceRowHeight = replaceNextButtonSize.y;
            }
            Point replaceAllButtonSize = CommandLine.this._replaceAllButton.computeSize(-1, -1);
            if (replaceRowHeight < replaceAllButtonSize.y) {
                replaceRowHeight = replaceAllButtonSize.y;
            }
            CommandLine.this._replaceLabel.setBounds(CommandLine.this._labelBorder, (replaceRowHeight - labelSize.y) / 2 + 1, labelSize.x, replaceRowHeight);
            int replaceEntryWidth = parentRect.width - CommandLine.this._labelBorder * 2 - labelSize.x - replaceNextButtonSize.x - replaceAllButtonSize.x - spacing * 3;
            CommandLine.this._replaceEntry.setBounds(CommandLine.this._labelBorder * 2 + labelSize.x, (replaceRowHeight - replaceEntryHeight) / 2, replaceEntryWidth, replaceEntryHeight);
            CommandLine.this._replaceNextButton.setBounds(CommandLine.this._labelBorder * 2 + labelSize.x + replaceEntryWidth + spacing, 0, replaceNextButtonSize.x, replaceRowHeight);
            CommandLine.this._replaceAllButton.setBounds(CommandLine.this._labelBorder * 2 + labelSize.x + replaceEntryWidth + replaceNextButtonSize.x + spacing * 2, 0, replaceAllButtonSize.x, replaceRowHeight);
        }
    }
}

